% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_redcap_tables.R
\name{read_redcap_tables}
\alias{read_redcap_tables}
\title{Download REDCap data}
\usage{
read_redcap_tables(
  uri,
  token,
  records = NULL,
  fields = NULL,
  events = NULL,
  forms = NULL,
  raw_or_label = "label",
  split_forms = "all"
)
}
\arguments{
\item{uri}{REDCap database API uri}

\item{token}{API token}

\item{records}{records to download}

\item{fields}{fields to download}

\item{events}{events to download}

\item{forms}{forms to download}

\item{raw_or_label}{raw or label tags}

\item{split_forms}{Whether to split "repeating" or "all" forms, default is
all.}
}
\value{
list of instruments
}
\description{
Implementation of REDCap_split with a focused data acquisition approach using
REDCapR::redcap_read and only downloading specified fields, forms and/or
events using the built-in focused_metadata including some clean-up.
Works with classical and longitudinal projects with or without repeating
instruments.
}
\examples{
# Examples will be provided later
}
