% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{ASExons}
\alias{ASExons}
\title{"ASExons"}
\usage{
ASExons(Data, Exonthreshold = 0.5, Groups = list(group1 = NULL, group2 =
  NULL), paired = FALSE, significancelevel = 0.05)
}
\arguments{
\item{Data}{The Data on which testing of the array scores should be conducted. This can be either the output of the REIDS model or the ExonTesting function.}

\item{Exonthreshold}{The exon score threshold to be maintained. If not NULL, probesets with an exon score lower than this value are not considered further and the p-values will be adjusted for multiplicity after testing. If NULL, all probesets are considered and a multiplicity correction is not performed.}

\item{Groups}{A list with elements specifying the columns of the data in each group.}

\item{paired}{Logical. Are the groups paired? If TRUE the mean paired differences are calculated and tested whether these are significantly different from zero or not.}

\item{significancelevel}{The significance level to be maintained on the p-values. The filtering on the significance is conducted only if an Exonthreshold is specified and the p-value are adjusted for multiplicity.}
}
\value{
A data frame with one line per exon. The columns contain the gene ID, the exon ID, the test statistic, a p-value and an adjusted p-value. If the groups are paired also the mean paired difference is given. Only the probesets with high enough exon scores and a significant test are kept in the data frame.
}
\description{
The ASExons functions can be performed either on the output of the REIDS model or on the ExonTesting model and identifies the alternatively spliced exons. It filters probesets on their exon scores, adjusts p-values for multiplicity and only keeps the significant probesets.
}
\examples{
data(TC12000010_REIDS_Output)
ASTest=ASExons(Data=TC12000010_REIDS_Output,Exonthreshold=0.5,Groups=list(c(1:9),c(10:18)),
paired=FALSE,significancelevel=0.05)
}
