/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique.gene;

import javalain.algorithmegenetique.DomaineEntier;
import javalain.algorithmegenetique.Gene;
import javalain.algorithmegenetique.gene.ReelDouble;

public final class Entier
extends Gene {
    private DomaineEntier interv;
    private int valeur;

    public Entier(DomaineEntier i) {
        this.interv = i;
        this.valeur = (int)(Math.random() * (double)this.interv.getTaille()) + this.interv.getMin();
    }

    private Entier(DomaineEntier i, int d) {
        this.interv = i;
        this.valeur = d;
    }

    public void set(int i) {
        if (i < this.interv.getMin() || i > this.interv.getMax()) {
            throw new IllegalArgumentException("Entier, set (int i) : le nombre n'appartient pas \u00e0 l'intervalle de definition.");
        }
        this.valeur = i;
    }

    public int get() {
        return this.valeur;
    }

    public Gene melanger(Gene g) {
        switch ((int)(Math.random() * 3.0)) {
            case 0: {
                return new Entier(this.interv, this.valeur);
            }
            case 1: {
                return new Entier(this.interv, ((Entier)g).valeur);
            }
        }
        double x = Math.random() * 1.5 - 0.25;
        int y = (int)(x * (double)this.valeur + (1.0 - x) * (double)((Entier)g).valeur);
        if (y > this.interv.getMax()) {
            y = this.interv.getMax();
        }
        if (y < this.interv.getMin()) {
            y = this.interv.getMin();
        }
        return new Entier(this.interv, y);
    }

    public void mutation() {
        switch ((int)(Math.random() * 3.0)) {
            case 0: {
                this.valeur += (int)(Math.random() * (double)Math.min(this.interv.getRayon(), this.interv.getMax() - this.valeur + 1));
                break;
            }
            case 1: {
                this.valeur -= (int)(Math.random() * (double)Math.min(this.interv.getRayon(), this.valeur - this.interv.getMin() + 1));
                break;
            }
            default: {
                this.valeur = (int)(Math.random() * (double)this.interv.getTaille()) + this.interv.getMin();
            }
        }
    }

    public Gene copier() {
        return new Entier(this.interv, this.valeur);
    }

    public Gene creer() {
        return new Entier(this.interv);
    }

    public boolean estEgalA(Gene g) {
        if (g instanceof Entier) {
            return this.valeur == ((Entier)g).valeur;
        }
        if (g instanceof ReelDouble) {
            return (double)this.valeur == ((ReelDouble)g).get();
        }
        return false;
    }

    public StringBuilder afficher() {
        return new StringBuilder().append(this.valeur);
    }
}

