/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.NegativeBinomialDist;
import umontreal.iro.lecuyer.util.RootFinder;

public class PascalDist
extends NegativeBinomialDist {
    private int n;
    private static final double EPSI = 1.0E-10;

    public PascalDist(int n, double d) {
        this.setParams(n, d);
    }

    public static double[] getMLE(int[] nArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        double d = 0.0;
        int n2 = Integer.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            d += (double)nArray[i];
            if (nArray[i] <= n2) continue;
            n2 = nArray[i];
        }
        double d2 = d / (double)n;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d3 += ((double)nArray[i] - d2) * ((double)nArray[i] - d2);
        }
        if (d2 >= (d3 /= (double)n)) {
            throw new UnsupportedOperationException("mean >= variance");
        }
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = 0;
            for (int j = 0; j < n; ++j) {
                if (nArray[j] <= i) continue;
                ++n3;
            }
            nArray2[i] = n3;
        }
        double[] dArray = new double[2];
        Function function = new Function(n, n2, d2, nArray2);
        dArray[1] = RootFinder.brentDekker(1.0E-10, 0.9999999999, function, 1.0E-5);
        if (dArray[1] >= 1.0) {
            dArray[1] = 0.999999999999999;
        }
        dArray[0] = Math.round(dArray[1] * d2 / (1.0 - dArray[1]));
        if (dArray[0] == 0.0) {
            dArray[0] = 1.0;
        }
        return dArray;
    }

    public static double[] getMaximumLikelihoodEstimate(int[] nArray, int n) {
        return PascalDist.getMLE(nArray, n);
    }

    public static PascalDist getInstanceFromMLE(int[] nArray, int n) {
        double[] dArray = PascalDist.getMaximumLikelihoodEstimate(nArray, n);
        return new PascalDist((int)dArray[0], dArray[1]);
    }

    public int getN() {
        return this.n;
    }

    public void setParams(int n, double d) {
        this.setParams((double)n, d);
        this.n = n;
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.n, this.p};
        return dArray;
    }

    public String toString() {
        return super.toString();
    }

    private static class Function
    implements MathFunction {
        protected int m;
        protected int max;
        protected double mean;
        protected int[] Fj;

        public Function(int n, int n2, double d, int[] nArray) {
            this.m = n;
            this.max = n2;
            this.mean = d;
            this.Fj = new int[nArray.length];
            System.arraycopy(nArray, 0, this.Fj, 0, nArray.length);
        }

        public double evaluate(double d) {
            double d2 = 0.0;
            double d3 = d * this.mean / (1.0 - d);
            for (int i = 0; i < this.max; ++i) {
                d2 += (double)this.Fj[i] / (d3 + (double)i);
            }
            return d2 + (double)this.m * Math.log(d);
        }

        public double evaluateN(int n, double d) {
            double d2 = 0.0;
            for (int i = 0; i < this.max; ++i) {
                d2 += (double)(this.Fj[i] / (n + i));
            }
            return d2 + (double)this.m * Math.log(d);
        }
    }
}

