/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import cern.colt.list.AbstractList;
import cern.colt.list.IntArrayList;
import umontreal.iro.lecuyer.hups.CycleBasedPointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.rng.RandomStream;

public abstract class CycleBasedPointSetBase2
extends CycleBasedPointSet {
    private int[] digitalShift;
    protected int numBits;
    protected double normFactor;

    public double getCoordinate(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 <= n) {
            n3 = ((AbstractList)this.cycles.get(n5)).size();
            n4 += n3;
            ++n5;
        }
        AbstractList abstractList = (AbstractList)this.cycles.get(n5 - 1);
        int[] nArray = ((IntArrayList)abstractList).elements();
        int n6 = (n - n4 + n3 + n2) % abstractList.size();
        int n7 = 0;
        if (this.digitalShift != null) {
            n7 = this.digitalShift[n2];
        }
        return (double)(n7 ^ nArray[n6]) * this.normFactor;
    }

    public PointSetIterator iterator() {
        return new CycleBasedPointSetBase2Iterator();
    }

    public void addRandomShift(int n, int n2, RandomStream randomStream) {
        int n3;
        if (null == randomStream) {
            throw new IllegalArgumentException("\n   Calling addRandomShift with null stream");
        }
        if (0 == n2) {
            n2 = Math.max(1, this.dim);
        }
        if (this.digitalShift == null) {
            this.digitalShift = new int[n2];
            this.capacityShift = n2;
        } else if (n2 > this.capacityShift) {
            for (n3 = Math.max(4, this.capacityShift); n2 > n3; n3 *= 2) {
            }
            int[] nArray = new int[n3];
            this.capacityShift = n3;
            for (int i = 0; i < this.dimShift; ++i) {
                nArray[i] = this.digitalShift[i];
            }
            this.digitalShift = nArray;
        }
        this.dimShift = n2;
        n3 = this.numBits < 31 ? (1 << this.numBits) - 1 : Integer.MAX_VALUE;
        for (int i = n; i < n2; ++i) {
            this.digitalShift[i] = randomStream.nextInt(0, n3);
        }
        this.shiftStream = randomStream;
    }

    public void clearRandomShift() {
        super.clearRandomShift();
        this.digitalShift = null;
    }

    public String formatPoints() {
        StringBuffer stringBuffer = new StringBuffer(this.toString());
        for (int i = 0; i < this.numCycles; ++i) {
            AbstractList abstractList = (AbstractList)this.cycles.get(i);
            int[] nArray = ((IntArrayList)abstractList).elements();
            stringBuffer.append("\nCycle " + i + ": (");
            boolean bl = true;
            for (int j = 0; j < abstractList.size(); ++j) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(nArray[j]);
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public class CycleBasedPointSetBase2Iterator
    extends CycleBasedPointSet.CycleBasedPointSetIterator {
        protected int[] curCycleI;

        public CycleBasedPointSetBase2Iterator() {
            this.resetCurCycle(0);
        }

        protected void init() {
        }

        public void resetCurCycle(int n) {
            this.curCycleIndex = n;
            this.curCycle = (AbstractList)CycleBasedPointSetBase2.this.cycles.get(n);
            this.curCycleI = ((IntArrayList)this.curCycle).elements();
        }

        public double nextCoordinate() {
            if (this.curPointIndex >= CycleBasedPointSetBase2.this.numPoints) {
                this.outOfBounds();
            }
            int n = this.curCycleI[this.curCoordInCycle];
            if (CycleBasedPointSetBase2.this.digitalShift != null) {
                if (this.curCoordIndex >= CycleBasedPointSetBase2.this.dimShift) {
                    CycleBasedPointSetBase2.this.addRandomShift(CycleBasedPointSetBase2.this.dimShift, this.curCoordIndex + 1, CycleBasedPointSetBase2.this.shiftStream);
                }
                n ^= CycleBasedPointSetBase2.this.digitalShift[this.curCoordIndex];
            }
            ++this.curCoordIndex;
            ++this.curCoordInCycle;
            if (this.curCoordInCycle >= this.curCycle.size()) {
                this.curCoordInCycle = 0;
            }
            return (double)n * CycleBasedPointSetBase2.this.normFactor;
        }

        public void nextCoordinates(double[] dArray, int n) {
            if (this.curPointIndex >= CycleBasedPointSetBase2.this.numPoints) {
                this.outOfBounds();
            }
            if (this.curCoordIndex + n >= CycleBasedPointSetBase2.this.dimShift) {
                CycleBasedPointSetBase2.this.addRandomShift(CycleBasedPointSetBase2.this.dimShift, this.curCoordIndex + n + 1, CycleBasedPointSetBase2.this.shiftStream);
            }
            int n2 = this.curCoordInCycle;
            int n3 = this.curCycle.size();
            for (int i = 0; i < n; ++i) {
                int n4 = this.curCycleI[this.curCoordInCycle++];
                if (this.curCoordInCycle >= n3) {
                    this.curCoordInCycle = 0;
                }
                dArray[i] = CycleBasedPointSetBase2.this.digitalShift == null ? (double)n4 * CycleBasedPointSetBase2.this.normFactor : (double)(CycleBasedPointSetBase2.this.digitalShift[this.curCoordIndex + i] ^ n4) * CycleBasedPointSetBase2.this.normFactor;
            }
            this.curCoordIndex += n;
        }

        public int nextPoint(double[] dArray, int n) {
            if (this.getCurPointIndex() >= CycleBasedPointSetBase2.this.getNumPoints()) {
                this.outOfBounds();
            }
            this.curCoordIndex = 0;
            this.curCoordInCycle = this.startPointInCycle;
            this.nextCoordinates(dArray, n);
            this.resetToNextPoint();
            return this.curPointIndex;
        }
    }
}

