% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showDigitizedImage.R
\name{showDigitizedImage}
\alias{showDigitizedImage}
\title{Show points selected on a structure image and saved in an R data file}
\usage{
showDigitizedImage(
  nms,
  deviceType,
  pch.show,
  col.show,
  cex.show,
  connect,
  col.connect,
  lwd.connect,
  col.scaleBar,
  lwd.scaleBar,
  showScaleBarLength,
  cex.scaleBar,
  showAnnuliLabels,
  annuliLabels,
  col.ann,
  cex.ann,
  offset.ann
)
}
\arguments{
\item{nms}{A string (or vector of strings) that indicates the R data file(s) created with \code{\link{digitizeRadii}}. If missing the user will be provided a dialog box from which to choose the file(s). The file(s) must be in the current working directory (see \code{\link{getwd}} result). May also be a single \code{RFishBC} object created with \code{\link{digitizeRadii}}.}

\item{deviceType}{See details in \code{\link{RFBCoptions}}.}

\item{pch.show}{See details in \code{\link{RFBCoptions}}.}

\item{col.show}{See details in \code{\link{RFBCoptions}}.}

\item{cex.show}{See details in \code{\link{RFBCoptions}}.}

\item{connect}{See details in \code{\link{RFBCoptions}}.}

\item{col.connect}{See details in \code{\link{RFBCoptions}}.}

\item{lwd.connect}{See details in \code{\link{RFBCoptions}}.}

\item{col.scaleBar}{See details in \code{\link{RFBCoptions}}.}

\item{lwd.scaleBar}{See details in \code{\link{RFBCoptions}}.}

\item{showScaleBarLength}{See details in \code{\link{RFBCoptions}}.}

\item{cex.scaleBar}{See details in \code{\link{RFBCoptions}}.}

\item{showAnnuliLabels}{See details in \code{\link{RFBCoptions}}.}

\item{annuliLabels}{See details in \code{\link{RFBCoptions}}.}

\item{col.ann}{See details in \code{\link{RFBCoptions}}.}

\item{cex.ann}{See details in \code{\link{RFBCoptions}}.}

\item{offset.ann}{See details in \code{\link{RFBCoptions}}.}
}
\value{
None, but an image is plotted with, at least, the selected points.
}
\description{
Show points selected on a structure image to represent annuli that were saved to an R data file using \code{\link{digitizeRadii}}. This allows the user to reexaminine the selected points or overlay selected points from multiple readings of the structure.
}
\details{
This function requires interaction from the user. A detailed description of its use is in \href{http://derekogle.com/RFishBC/articles/MeasureRadii/seeRadiiData.html}{this vignette} on the \href{http://derekogle.com/RFishBC/index.html}{RFishBC website}.
}
\examples{
## None because this requires interaction from the user.
## See the link to the extensive documentation in the Details.

}
\seealso{
\code{\link{digitizeRadii}} and \code{\link{RFBCoptions}}.
}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
