% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listFiles.R
\name{listFiles}
\alias{listFiles}
\title{List files with a specific extension in a folder/directory}
\usage{
listFiles(ext, other = NULL, path = ".", ignore.case = TRUE, ...)
}
\arguments{
\item{ext}{A single string that contains the file extension pattern to match.}

\item{other}{Other strings to match in file names that were already matched by the extension in \code{ext}.}

\item{path}{A single string that contains the full path name for the folder/directory for which to list files. Defaults to the current working directory (see \code{\link{getwd}} result).}

\item{ignore.case}{A logical for whether pattern matching should be case sensitive (\code{=FALSE}) or not (\code{TRUE}; DEFAULT).}

\item{\dots}{Parameters to be given to \code{\link{list.files}}.}
}
\value{
Character vector.
}
\description{
This returns a vector with all file names with the \code{ext} extension in the \code{path} folder/directory. In \pkg{RfishBC} this is used primarily to create a list of image file names for use in \code{\link{digitizeRadii}} or RData file names created with \code{\link{digitizeRadii}} and to be given to \code{\link{combineData}}.
}
\details{
An example of using this function is in \href{https://derekogle.com/RFishBC/articles/MeasureRadii/collectRadiiData.html}{this vignette} and \href{https://derekogle.com/RFishBC/articles/MeasureRadii/seeRadiiData.html}{this vignette} on the \href{https://derekogle.com/RFishBC/index.html}{RFishBC website}.
}
\examples{
## See the link to the extensive documentation in the Details.

}
\seealso{
\code{\link{digitizeRadii}} and \code{\link{combineData}}; and \code{\link{list.files}} in base R.
}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
