#' RForcecom
#' 
#' Data Integration Feature for Force.com and Salesforce.com
#'
#' @name RForcecom
#' @aliases RForcecom RForcecom-package
#' @docType package
#' @importFrom RCurl basicHeaderGatherer basicTextGatherer curlPerform curlEscape
#' @importFrom XML xmlTreeParse xmlRoot xmlValue getNodeSet newXMLNode xmlParse xmlToDataFrame xmlToList xmlGetAttr
#' @importFrom httr POST content upload_file add_headers
#' @importFrom plyr rbind.fill ldply
#' @importFrom utils read.csv type.convert
#' @importFrom methods as
#' @details 
#' \tabular{ll}{
#' Package: \tab RForcecom\cr
#' Type: \tab Package\cr
#' Version: \tab 0.9\cr
#' Date: \tab 2015-10-26\cr
#' License: \tab Apache License 2.0\cr
#' LazyLoad: \tab yes\cr
#' }
#' @author Takekatsu Hiramura <thira@@plavox.info>
#' @references 
#' Force.com REST API Developer's Guide\cr
#' \url{https://developer.salesforce.com/docs/atlas.en-us.api_rest.meta/api_rest/}
#' 
#' Web Services API Developer's Guide\cr
#' \url{https://developer.salesforce.com/docs/atlas.en-us.api.meta/api/}
#' 
#' Bulk API Developer's Guide\cr
#' \url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
#' @keywords package connection
#' @seealso XML RCurl httr plyr
#' @examples
#' \dontrun{
#'  # Sign in to the Force.com
#'  username <- "yourname@@yourcompany.com"
#'  password <- "YourPasswordSECURITY_TOKEN"
#'  session <- rforcecom.login(username, password)
#'      
#'  # Execute a SOQL
#'  soqlQuery <- "SELECT Id, Name, Industry, AnnualRevenue FROM Account"
#'  rforcecom.query(session, soqlQuery)
#'  
#'  # Execute a SOSL
#'  queryString <- "United"
#'  rforcecom.search(session, queryString)
#'  
#'  # Create a record
#'  objectName <- "Account"
#'  fields <- c(Name="R Analytics Service Ltd", Phone="5555-5555-5555")
#'  rforcecom.create(session, objectName, fields)
#'      
#'  # Retrieve record
#'  objectName <- "Account"
#'  fields <- c("name", "Industry", "AnnualRevenue")
#'  rforcecom.retrieve(session, objectName, fields)
#'  
#'  # Update a record
#'  objectName <- "Account"
#'  id <- "999x000000xxxxxZZZ"
#'  fields <- c(Phone="9999-9999-9999")
#'  rforcecom.update(session, objectName, id, fields)
#'      
#'  # Upsert a record
#'  objectName <- "Account";
#'  externalIdField <- "AccountMaster__c"
#'  externalId <- "AM-00000151"
#'  fields <- c(Name="ABC Network Company", Phone="3333-3333-3333")
#'  rforcecom.upsert(session, objectName, externalIdField, externalId, fields)
#'      
#'  # Delete a record
#'  objectName <- "Account";
#'  id <- "999x000000xxxxxZZZ"
#'  rforcecom.delete(session, objectName, id)
#'      
#'  # Retrieve a server timestamp
#'  rforcecom.getServerTimestamp(session)
#'  
#'  # Logout
#'  rforcecom.logout(session)
#'  
#'  ####
#'  # Using the Bulk API
#'  ####
#'  
#'  # Sign in to the Force.com
#'  username <- "yourname@@yourcompany.com"
#'  password <- "YourPasswordSECURITY_TOKEN"
#'  instanceURL <- "https://xxx.salesforce.com/"
#'  apiVersion <- "34.0"
#'  session <- rforcecom.login(username, password, instanceURL, apiVersion)
#'  
#'  
#'  ## BULK INSERT
#'  
#'  # create a sample data.frame of 1000 records
#'  n <- 1000
#'  data <- data.frame(Name=paste('New Record:', 1:n), 
#'                     stringsAsFactors=FALSE)
#'  
#'  # run an insert job into the Account object
#'  job_info <- rforcecom.createBulkJob(session, 
#'                                      operation='insert', 
#'                                      object='Account')
#'  
#'  # split into batch sizes of 500 (2 batches for our 1000 row sample dataset)
#'  batches_info <- rforcecom.createBulkBatch(session, 
#'                                            jobId=job_info$id, 
#'                                            data, 
#'                                            multiBatch = TRUE, 
#'                                            batchSize=500)
#'  
#'  # check on status of each batch
#'  batches_status <- lapply(batches_info, 
#'                           FUN=function(x){
#'                            rforcecom.checkBatchStatus(session, 
#'                                                       jobId=x$jobId, 
#'                                                       batchId=x$id)
#'                                                       })
#'  # get details on each batch
#'  batches_detail <- lapply(batches_info, 
#'                           FUN=function(x){
#'                            rforcecom.getBatchDetails(session, 
#'                                                      jobId=x$jobId, 
#'                                                      batchId=x$id)
#'                                                      })
#'  # close the job
#'  close_job_info <- rforcecom.closeBulkJob(session, jobId=job_info$id)
#'  
#'  
#'  ## BULK DELETE THE PRIOR INSERT
#'  
#'  # format the data
#'  batch_details_together <- plyr::ldply(batches_detail)
#'  delete_ids <- data.frame(id=batch_details_together[,"Id"], 
#'                           stringsAsFactors=FALSE)
#'  
#'  job_info <- rforcecom.createBulkJob(session, operation='delete', object='Account')
#'  batches_info <- rforcecom.createBulkBatch(session, 
#'                                            jobId=job_info$id, 
#'                                            data=delete_ids)
#'  # check on status of each batch
#'  batches_status <- lapply(batches_info, 
#'                           FUN=function(x){
#'                            rforcecom.checkBatchStatus(session, 
#'                                                       jobId=x$jobId, 
#'                                                       batchId=x$id)
#'                                                       })
#'  # get details on each batch
#'  batches_detail <- lapply(batches_info, 
#'                           FUN=function(x){
#'                            rforcecom.getBatchDetails(session, 
#'                                                      jobId=x$jobId, 
#'                                                      batchId=x$id)
#'                                                      })
#'  # close the job
#'  close_job_info <- rforcecom.closeBulkJob(session, jobId=job_info$id)
#'  
#'  
#'  ## BULK QUERY
#'  
#'  query <- "SELECT Id, Name FROM Account LIMIT 10"
#'  job_info <- rforcecom.createBulkJob(session, operation='query', object='Account')
#'  batch_query_info <- rforcecom.submitBulkQuery(session, 
#'                                                jobId=job_info$id, 
#'                                                query=query)
#'                                                
#'  batch_query_status <- rforcecom.checkBatchStatus(session, 
#'                                                   jobId=batch_query_info$jobId, 
#'                                                   batchId=batch_query_info$id)
#'                                                   
#'  batch_query_details <- rforcecom.getBatchDetails(session, 
#'                                                   jobId=batch_query_info$jobId, 
#'                                                   batchId=batch_query_info$id)
#'                                                  
#'  batch_query_recordset <- rforcecom.getBulkQueryResult(session, 
#'                                                        jobId=batch_query_info$jobId, 
#'                                                        batchId=batch_query_info$id, 
#'                                                        resultId=batch_query_details$result)
#'  close_job_info <- rforcecom.closeBulkJob(session, jobId=job_info$id)
#'  
#'  
#'  ## BULK INSERT ATTACHMENTS
#'  
#'  # prepare your .zip file and request.txt manifest before calling these functions
#'  file <- 'request.zip'
#'  job_info <- rforcecom.createBulkJob(session, operation='insert', object='Attachment')
#'  batch_attachment_info <- rforcecom.insertBulkAttachments(session, 
#'                                                           jobId=job_info$id, 
#'                                                           file=file)
#'  batch_attachment_status <- rforcecom.checkBatchStatus(session, 
#'                                                        jobId=batch_attachment_info$jobId, 
#'                                                        batchId=batch_attachment_info$id)
#'  batch_attachment_details <- rforcecom.getBatchDetails(session, 
#'                                                        jobId=batch_attachment_info$jobId, 
#'                                                        batchId=batch_attachment_info$id)
#'  # close the job
#'  close_job_info <- rforcecom.closeBulkJob(session, jobId=job_info$id)
#'  
#'  }
NULL