% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rforcecom.login.R
\name{rforcecom.login}
\alias{rforcecom.login}
\title{Sign in to the Force.com (Salesforce.com)}
\usage{
rforcecom.login(username, password, loginURL, apiVersion)
}
\arguments{
\item{username}{Your username for login to the Salesforce.com. In many cases, username is your E-mail address.}

\item{password}{Your password for login to the Salesforce.com. Note: DO NOT FORGET your Security Token. (Ex.) If your password is "Pass1234" and your security token is "XYZXYZXYZXYZ", you should set "Pass1234XYZXYZXYZXYZ".}

\item{loginURL}{(optional) Login URL. If your environment is sandbox specify (ex:) "https://test.salesforce.com/".}

\item{apiVersion}{(optional) Version of the REST API and SOAP API that you want to use. (ex:) "35.0" Supported versions from v20.0 and up.}
}
\value{
\item{sessionID}{Session ID.}
\item{instanceURL}{Instance URL.}
\item{apiVersion}{API Version.}
}
\description{
This function retrives a session ID from Salesforce.com.
}
\examples{
\dontrun{
# Sign in to the Force.com
username <- "yourname@yourcompany.com"
password <- "YourPasswordSECURITY_TOKEN"
session <- rforcecom.login(username, password)
}
}
\seealso{
\code{\link{rforcecom.query}}
 \code{\link{rforcecom.search}}
 \code{\link{rforcecom.create}}
 \code{\link{rforcecom.delete}}
 \code{\link{rforcecom.retrieve}}
 \code{\link{rforcecom.update}}
 \code{\link{rforcecom.upsert}}
 \code{\link{rforcecom.getServerTimestamp}}
 \code{\link{rforcecom.getObjectDescription}}
 \code{\link{rforcecom.getObjectList}}
 \code{\link{rforcecom.queryMore}}
}
\keyword{connection}

