% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rforcecom.submitBulkQuery.R
\name{rforcecom.submitBulkQuery}
\alias{rforcecom.submitBulkQuery}
\title{Submit Bulk Query Batch to a Bulk API Job}
\usage{
rforcecom.submitBulkQuery(session, jobId, query)
}
\arguments{
\item{session}{a named character vector defining parameters of the api connection as returned by \link{rforcecom.login}}

\item{jobId}{a character string defining the salesforce id assigned to a submitted job as returned by \link{rforcecom.createBulkJob}}

\item{query}{a character string defining a valid SOQL query on the Salesforce object associated with the job}
}
\value{
A \code{list} parameters of the batch
}
\description{
This function takes a SOQL text string and submits the query to 
an already existing Bulk API Job of operation "query"
}
\note{
Bulk API query doesn't support the following SOQL:
\itemize{
   \item COUNT
   \item ROLLUP
   \item SUM
   \item GROUP BY CUBE
   \item OFFSET
   \item Nested SOQL queries
   \item Relationship fields
   }
   Additionally, Bulk API can't access or query compound address or compound geolocation fields.
}
\examples{
\dontrun{
my_query <- "SELECT Id, Name FROM Account LIMIT 10"
query_info <- rforcecom.submitBulkQuery(session, jobId=job_info$id, query=my_query)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
\concept{
bulk batch salesforce api
}

