/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.modulesupport.Configurable;
import freak.core.observer.AbstractObserver;
import freak.core.population.IndividualList;

public class NumberOfIndividuals
extends AbstractObserver
implements IndividualListEventListener,
Configurable {
    public NumberOfIndividuals(Schedule schedule) {
        super(schedule);
        this.setMeasure(1);
    }

    public Class getOutputDataType() {
        return double[].class;
    }

    public String getName() {
        return "Number of Individuals";
    }

    public String getDescription() {
        return "Computes the number of observed individuals.";
    }

    public void individualList(IndividualListEvent evt) {
        IndividualList individualList = evt.getIndividualList();
        this.updateViews(new Double(individualList.size()));
    }

    public void createEvents() {
        super.createEvents();
        this.getSchedule().getEventController().addEvent(this, "Get individuals from", IndividualListEvent.class, this.getSchedule().getPopulationManager());
    }
}

