/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset.math;

import freak.module.fitness.pointset.math.EquationSolver;
import freak.module.fitness.pointset.math.matrix.Matrix;
import freak.module.fitness.pointset.math.matrix.Vector;
import freak.module.fitness.pointset.math.matrix.view.MatrixSimpleOperation;
import freak.module.fitness.pointset.math.matrix.view.NormalView;
import freak.module.fitness.pointset.math.matrix.view.VectorView;

class GaussianElimination
extends EquationSolver {
    public GaussianElimination(Matrix m, Vector b) throws Exception {
        super(m, b);
    }

    void solve(NormalView pMat, VectorView pB) throws Exception {
        if (!pMat.isSquared() || pB.getDimension() != pMat.getCol()) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        MatrixSimpleOperation matSOP = new MatrixSimpleOperation(pMat);
        MatrixSimpleOperation bSOP = new MatrixSimpleOperation(pB);
        int i = 0;
        while (i < pMat.getCol()) {
            int max = i;
            int j = i + 1;
            while (j < pMat.getCol()) {
                if (Math.abs(pMat.get(j, i)) > Math.abs(pMat.get(max, i))) {
                    max = j;
                }
                ++j;
            }
            if (i != max) {
                matSOP.swapRows(i, max);
                bSOP.swapRows(i, max);
            }
            if (pMat.get(i, i) == 0.0) {
                throw new RuntimeException("Matrix is singular.");
            }
            j = i + 1;
            while (j < pMat.getCol()) {
                pB.set(j, pB.get(j) - pB.get(i) * pMat.get(j, i) / pMat.get(i, i));
                ++j;
            }
            j = i + 1;
            while (j < pMat.getCol()) {
                double m = pMat.get(j, i) / pMat.get(i, i);
                int k = i + 1;
                while (k < pMat.getCol()) {
                    pMat.set(j, k, pMat.get(j, k) - pMat.get(i, k) * m);
                    ++k;
                }
                pMat.set(j, i, 0.0);
                ++j;
            }
            ++i;
        }
        this.result = new Vector(pMat.getCol());
        VectorView resView = new VectorView(this.result);
        int j = pMat.getCol() - 1;
        while (j >= 0) {
            double t = 0.0;
            int k = j + 1;
            while (k < pMat.getCol()) {
                t += pMat.get(j, k) * resView.get(k);
                ++k;
            }
            resView.set(j, (pB.get(j) - t) / pMat.get(j, j));
            --j;
        }
    }

    protected boolean willSolveChangeTheMatrix() {
        return true;
    }
}

