/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.bitstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class OneMax
extends AbstractStaticSingleObjectiveFitnessFunction {
    public OneMax(Schedule schedule) {
        super(schedule);
    }

    public double evaluate(Genotype genotype) {
        BitSet result = ((BitStringGenotype)genotype).getBitSet();
        return result.cardinality();
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        return ((BitString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        int dimension = ((BitString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
        BitSet bs = new BitSet(dimension);
        bs.set(0, dimension);
        return new BitStringGenotype(bs, dimension);
    }

    public String getDescription() {
        return "The fitness value of an individual is the number of ones in its genotype.";
    }

    public String getName() {
        return "OneMax";
    }
}

