/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.runframe;

import freak.core.control.GenerationIndex;
import freak.gui.runframe.GoToDialogUI;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class GoToDialog
extends GoToDialogUI {
    GenerationIndex goTo;

    public GoToDialog(Frame parent, GenerationIndex initDefault) {
        super(parent, true);
        this.setFromIndex(initDefault);
        this.jTextFieldBatch.selectAll();
        this.jTextFieldBatch.requestFocus();
        this.jTextFieldBatch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GoToDialog.this.jTextFieldRun.selectAll();
                GoToDialog.this.jTextFieldRun.requestFocusInWindow();
            }
        });
        this.jTextFieldRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GoToDialog.this.jTextFieldGeneration.selectAll();
                GoToDialog.this.jTextFieldGeneration.requestFocusInWindow();
            }
        });
        this.jTextFieldGeneration.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GoToDialog.this.ok();
            }
        });
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GoToDialog.this.ok();
            }
        });
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GoToDialog.this.cancel();
            }
        });
    }

    private void ok() {
        this.parse();
        if (this.goTo != null) {
            this.setVisible(false);
        }
    }

    private void cancel() {
        this.setVisible(false);
    }

    private void setFromIndex(GenerationIndex generationIndex) {
        this.jTextFieldBatch.setText(String.valueOf(generationIndex.batch));
        this.jTextFieldRun.setText(String.valueOf(generationIndex.run));
        this.jTextFieldGeneration.setText(String.valueOf(generationIndex.generation));
    }

    private void parse() {
        try {
            int batch = this.parse(this.jTextFieldBatch);
            int run = this.parse(this.jTextFieldRun);
            int generation = this.parse(this.jTextFieldGeneration);
            if (batch <= 0 || run <= 0 || generation <= 0 || batch == 0 && run == 0 && generation == 0) {
                throw new NumberFormatException("Please enter only positive or only zero values.");
            }
            this.goTo = new GenerationIndex(batch, run, generation);
        }
        catch (NumberFormatException exc) {
            JOptionPane.showMessageDialog(this, exc.getMessage(), "Illegal Generation Index", 0);
        }
    }

    private int parse(JTextField textField) {
        try {
            return Integer.parseInt(textField.getText());
        }
        catch (NumberFormatException exc) {
            textField.selectAll();
            textField.requestFocusInWindow();
            throw new NumberFormatException("Please enter an integer number.");
        }
    }
}

