/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.foundation;

import edu.ucsb.cs.jicos.foundation.Command;
import edu.ucsb.cs.jicos.foundation.CommandSynchronous;
import edu.ucsb.cs.jicos.foundation.Mailer;
import edu.ucsb.cs.jicos.foundation.RemoteExceptionHandler;
import edu.ucsb.cs.jicos.foundation.Service;
import edu.ucsb.cs.jicos.foundation.ServiceImpl;
import edu.ucsb.cs.jicos.foundation.ServiceName;
import edu.ucsb.cs.jicos.services.Hsp;
import edu.ucsb.cs.jicos.services.commands.Ping;
import java.rmi.RemoteException;

public abstract class Proxy
extends Thread {
    private static final CommandSynchronous PING;
    private ServiceName serviceName;
    private ServiceImpl containingServiceImpl;
    private boolean kill;
    private transient RemoteExceptionHandler remoteExceptionHandler;
    private transient Mailer mailer;
    private boolean anInternalService;
    private Service remoteService;
    private long term;
    private long expirationTime;
    private long remainingTime;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$foundation$Proxy;

    public Proxy(ServiceName serviceName, ServiceImpl serviceImpl, RemoteExceptionHandler remoteExceptionHandler, long l) {
        if (!$assertionsDisabled && serviceName == null) {
            throw new AssertionError();
        }
        this.serviceName = serviceName;
        this.containingServiceImpl = serviceImpl;
        this.remoteExceptionHandler = remoteExceptionHandler;
        this.term = l;
        this.remoteService = serviceName.service();
        if (serviceImpl != null) {
            this.mailer = serviceImpl.addMail(this.remoteService, remoteExceptionHandler);
        } else {
            this.anInternalService = true;
        }
        this.renew();
        this.start();
    }

    public void containingServiceImpl(ServiceImpl serviceImpl) {
        if (!$assertionsDisabled && serviceImpl == null) {
            throw new AssertionError();
        }
        this.containingServiceImpl = serviceImpl;
    }

    public abstract void evict();

    public Object execute(CommandSynchronous commandSynchronous, RemoteExceptionHandler remoteExceptionHandler) {
        if (!$assertionsDisabled && remoteExceptionHandler == null) {
            throw new AssertionError();
        }
        return commandSynchronous.execute(this, remoteExceptionHandler);
    }

    public void execute(Command command) {
        command.execute(this);
    }

    public void kill() {
        this.kill = true;
    }

    public boolean offerRenewal() {
        if (this.containingServiceImpl == null) {
            this.renew();
            return true;
        }
        if (this.containingServiceImpl instanceof Hsp) {
            Hsp hsp = (Hsp)this.containingServiceImpl;
            if (this.term == 3000L && hsp.getPendingResults() > 0) {
                this.renew();
                return true;
            }
        }
        try {
            this.remoteService.executeCommand(this.containingServiceImpl, PING);
        }
        catch (RemoteException remoteException) {
            System.out.println("Proxy.offerRenewal: RemoteException.");
            return false;
        }
        this.renew();
        return true;
    }

    public void remoteExceptionHandler(RemoteExceptionHandler remoteExceptionHandler) {
        if (!$assertionsDisabled && remoteExceptionHandler == null) {
            throw new AssertionError();
        }
        this.remoteExceptionHandler = remoteExceptionHandler;
    }

    public Service remoteService() {
        return this.remoteService;
    }

    public synchronized void renew() {
        this.expirationTime = System.currentTimeMillis() + this.term;
        this.remainingTime = this.term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.remainingTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.kill) {
                return;
            }
            Proxy proxy = this;
            synchronized (proxy) {
                this.remainingTime = this.expirationTime - System.currentTimeMillis();
                if (this.remainingTime < 0L && !this.offerRenewal()) {
                    this.evict();
                    break;
                }
            }
        }
    }

    public void sendCommand(Command command) {
        if (!$assertionsDisabled && command == null) {
            throw new AssertionError();
        }
        if (this.anInternalService) {
            try {
                command.execute((ServiceImpl)this.remoteService);
            }
            catch (Exception exception) {
                this.containingServiceImpl.exceptionHandler(exception);
            }
        } else {
            this.mailer.add(command);
        }
    }

    public ServiceName serviceName() {
        return this.serviceName;
    }

    public void setTerm(long l) {
        if (!$assertionsDisabled && l <= 0L) {
            throw new AssertionError();
        }
        this.term = l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$edu$ucsb$cs$jicos$foundation$Proxy == null ? (class$edu$ucsb$cs$jicos$foundation$Proxy = Proxy.class$("edu.ucsb.cs.jicos.foundation.Proxy")) : class$edu$ucsb$cs$jicos$foundation$Proxy).desiredAssertionStatus();
        PING = new Ping();
    }
}

