/*
 * Decompiled with CFR 0.152.
 */
package freak.module.searchspace;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.modulesupport.Configurable;
import freak.core.population.Genotype;
import freak.core.searchspace.AbstractSearchSpace;
import freak.core.searchspace.HasDimension;
import freak.core.searchspace.HasMetric;
import freak.module.searchspace.GeneralStringGenotype;

public class GeneralString
extends AbstractSearchSpace
implements Configurable,
HasMetric,
HasDimension {
    private int numChars = 3;
    private int dimension = 20;

    public GeneralString(Schedule schedule) {
        super(schedule);
    }

    public String getName() {
        return "General String";
    }

    public String getDescription() {
        return "The search space {0,...,k-1}^dimension.";
    }

    public double getSize() {
        return Math.pow(this.numChars, this.dimension);
    }

    public double getDistance(Genotype gt1, Genotype gt2) {
        int[] gta2;
        int distance = 0;
        int[] gta1 = ((GeneralStringGenotype)gt1).getIntArray();
        if (gta1.length != (gta2 = ((GeneralStringGenotype)gt2).getIntArray()).length) {
            throw new RuntimeException("Size of both genotypes is not equal");
        }
        int i = 0;
        while (i < gta1.length) {
            if (gta1[i] != gta2[i]) {
                ++distance;
            }
            ++i;
        }
        return distance;
    }

    public Genotype getRandomGenotype() {
        int[] genotype = new int[this.dimension];
        RandomElement re = this.schedule.getRandomElement();
        if (re == null) {
            throw new NullPointerException("no random element");
        }
        int i = 0;
        while (i < this.dimension) {
            genotype[i] = re.choose(0, this.numChars - 1);
            ++i;
        }
        return new GeneralStringGenotype(genotype, this.numChars);
    }

    public void setPropertyNumberOfChars(Integer num) {
        if (num > 1) {
            this.numChars = num;
        }
    }

    public int getNumChars() {
        return this.numChars;
    }

    public Integer getPropertyNumberOfChars() {
        return new Integer(this.numChars);
    }

    public String getLongDescriptionForDimension() {
        return "The length of all strings.";
    }

    public String getLongDescriptionForNumberOfChars() {
        return "The size of one character's domain.";
    }

    public String getShortDescriptionForNumberOfChars() {
        return "k";
    }

    public void setPropertyDimension(Integer dim) {
        if (dim > 1) {
            this.dimension = dim;
        }
    }

    public Integer getPropertyDimension() {
        return new Integer(this.dimension);
    }

    public int getDimension() {
        return this.dimension;
    }
}

