/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphSelectionModel;
import org.jgraph.graph.GraphTransferable;
import org.jgraph.graph.ParentMap;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphDropTargetListener;

public class BasicGraphUI
extends GraphUI
implements Serializable {
    public static final boolean DNDPREVIEW = System.getProperty("java.version").compareTo("1.4.0") < 0 || System.getProperty("java.version").compareTo("1.4.0") > 0;
    public static int SCROLLBORDER = 18;
    public static float SCROLLSTEP = 0.05f;
    public static int MAXCELLS = 20;
    public static int MAXHANDLES = 20;
    public static int MAXCLIPCELLS = 20;
    protected Dimension preferredMinSize;
    protected JGraph graph;
    protected GraphLayoutCache graphLayoutCache;
    protected GraphCellEditor cellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected boolean validCachedPreferredSize;
    protected GraphModel graphModel;
    protected GraphSelectionModel graphSelectionModel;
    protected CellHandle handle;
    protected BasicMarqueeHandler marquee;
    protected Component editingComponent;
    protected CellView focus;
    protected Object editingCell;
    protected boolean editorHasDifferentSize;
    protected Point insertionLocation;
    protected int dropAction = 0;
    protected boolean snapSelectedView = false;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected KeyListener keyListener;
    protected ComponentListener componentListener;
    protected CellEditorListener cellEditorListener = this.createCellEditorListener();
    protected GraphSelectionListener graphSelectionListener;
    protected GraphModelListener graphModelListener;
    protected Observer graphViewObserver;
    protected TransferHandler defaultTransferHandler;
    protected GraphDropTargetListener defaultDropTargetListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicGraphUI();
    }

    protected void setModel(GraphModel graphModel) {
        this.cancelEditing(this.graph);
        if (this.graphModel != null && this.graphModelListener != null) {
            this.graphModel.removeGraphModelListener(this.graphModelListener);
        }
        this.graphModel = graphModel;
        if (this.graphModel != null && this.graphModelListener != null) {
            this.graphModel.addGraphModelListener(this.graphModelListener);
        }
        if (this.graphModel != null) {
            this.updateSize();
        }
    }

    protected void setGraphLayoutCache(GraphLayoutCache graphLayoutCache) {
        this.cancelEditing(this.graph);
        if (this.graphLayoutCache != null && this.graphViewObserver != null) {
            this.graphLayoutCache.deleteObserver(this.graphViewObserver);
        }
        this.graphLayoutCache = graphLayoutCache;
        if (this.graphLayoutCache != null && this.graphViewObserver != null) {
            this.graphLayoutCache.addObserver(this.graphViewObserver);
        }
        this.updateSize();
    }

    protected void setMarquee(BasicMarqueeHandler basicMarqueeHandler) {
        this.marquee = basicMarqueeHandler;
    }

    protected void setSelectionModel(GraphSelectionModel graphSelectionModel) {
        this.cancelEditing(this.graph);
        if (this.graphSelectionListener != null && this.graphSelectionModel != null) {
            this.graphSelectionModel.removeGraphSelectionListener(this.graphSelectionListener);
        }
        this.graphSelectionModel = graphSelectionModel;
        if (this.graphSelectionModel != null && this.graphSelectionListener != null) {
            this.graphSelectionModel.addGraphSelectionListener(this.graphSelectionListener);
        }
        if (this.graph != null) {
            this.graph.repaint();
        }
    }

    public CellHandle getHandle(JGraph jGraph) {
        return this.handle;
    }

    protected Object getFocusedCell() {
        if (this.focus != null) {
            return this.focus.getCell();
        }
        return null;
    }

    public Dimension getPreferredSize(JGraph jGraph, CellView cellView) {
        if (cellView != null) {
            boolean bl;
            Component component;
            boolean bl2;
            Object object = cellView.getCell();
            String string = jGraph.convertValueToString(object);
            boolean bl3 = string != null && string.length() > 0;
            boolean bl4 = bl2 = GraphConstants.getIcon(cellView.getAllAttributes()) != null;
            if ((bl3 || bl2) && (component = cellView.getRendererComponent(jGraph, bl = this.getFocusedCell() == object && jGraph.hasFocus(), false, false)) != null) {
                jGraph.add(component);
                component.validate();
                return component.getPreferredSize();
            }
            return cellView.getBounds().getSize();
        }
        return null;
    }

    public Point getInsertionLocation() {
        return this.insertionLocation;
    }

    public void setInsertionLocation(Point point) {
        this.insertionLocation = point;
    }

    public void selectCellsForEvent(JGraph jGraph, Object[] objectArray, MouseEvent mouseEvent) {
        this.selectCellsForEvent(objectArray, mouseEvent);
    }

    public void selectCellsForEvent(Object[] objectArray, MouseEvent mouseEvent) {
        if (objectArray == null) {
            return;
        }
        if (this.isToggleSelectionEvent(mouseEvent)) {
            int n = 0;
            while (n < objectArray.length) {
                this.toggleSelectionCellForEvent(objectArray[n], mouseEvent);
                ++n;
            }
        } else if (this.isAddToSelectionEvent(mouseEvent)) {
            this.graph.addSelectionCells(objectArray);
        } else {
            this.graph.setSelectionCells(objectArray);
        }
    }

    public void selectCellForEvent(Object object, MouseEvent mouseEvent) {
        if (this.isToggleSelectionEvent(mouseEvent)) {
            this.toggleSelectionCellForEvent(object, mouseEvent);
        } else if (this.isAddToSelectionEvent(mouseEvent)) {
            this.graph.addSelectionCell(object);
        } else {
            this.graph.setSelectionCell(object);
        }
    }

    protected void toggleSelectionCellForEvent(Object object, MouseEvent mouseEvent) {
        if (this.graph.isCellSelected(object)) {
            this.graph.removeSelectionCell(object);
        } else {
            this.graph.addSelectionCell(object);
        }
    }

    public boolean isAddToSelectionEvent(MouseEvent mouseEvent) {
        return mouseEvent.isShiftDown();
    }

    public boolean isToggleSelectionEvent(MouseEvent mouseEvent) {
        return mouseEvent.isControlDown();
    }

    public boolean isForceMarqueeEvent(MouseEvent mouseEvent) {
        if (this.marquee != null) {
            return this.marquee.isForceMarqueeEvent(mouseEvent);
        }
        return false;
    }

    public boolean isConstrainedMoveEvent(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            return mouseEvent.isShiftDown();
        }
        return false;
    }

    public boolean isEditing(JGraph jGraph) {
        return this.editingComponent != null;
    }

    public boolean stopEditing(JGraph jGraph) {
        if (this.editingComponent != null && this.cellEditor.stopCellEditing()) {
            this.completeEditing(false, false, true);
            return true;
        }
        return false;
    }

    public void cancelEditing(JGraph jGraph) {
        if (this.editingComponent != null) {
            this.completeEditing(false, true, false);
        }
    }

    public void startEditingAtCell(JGraph jGraph, Object object) {
        jGraph.scrollCellToVisible(object);
        if (object != null) {
            this.startEditing(object, null);
        }
    }

    public Object getEditingCell(JGraph jGraph) {
        return this.editingCell;
    }

    public void installUI(JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("null component passed to BasicGraphUI.installUI()");
        }
        this.graph = (JGraph)jComponent;
        this.marquee = this.graph.getMarqueeHandler();
        this.prepareForUIInstall();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.installComponents();
        this.completeUIInstall();
    }

    protected void prepareForUIInstall() {
        this.stopEditingInCompleteEditing = true;
        this.preferredSize = new Dimension();
        this.setGraphLayoutCache(this.graph.getGraphLayoutCache());
        this.setModel(this.graph.getModel());
    }

    protected void completeUIInstall() {
        this.setSelectionModel(this.graph.getSelectionModel());
        this.updateSize();
    }

    protected void installDefaults() {
        if (this.graph.getBackground() == null || this.graph.getBackground() instanceof UIResource) {
            this.graph.setBackground(UIManager.getColor("Tree.background"));
        }
        if (this.graph.getFont() == null || this.graph.getFont() instanceof UIResource) {
            this.graph.setFont(UIManager.getFont("Tree.font"));
        }
        this.graph.setMarqueeColor(UIManager.getColor("Table.gridColor"));
        this.graph.setHandleColor(UIManager.getColor("MenuItem.selectionBackground"));
        this.graph.setLockedHandleColor(UIManager.getColor("MenuItem.background"));
        this.graph.setGridColor(UIManager.getColor("Tree.selectionBackground"));
        this.graph.setOpaque(true);
    }

    protected void installListeners() {
        TransferHandler transferHandler = this.graph.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            this.defaultTransferHandler = this.createTransferHandler();
            this.graph.setTransferHandler(this.defaultTransferHandler);
        }
        if (this.graphLayoutCache != null) {
            this.graphViewObserver = this.createGraphViewObserver();
            this.graphLayoutCache.addObserver(this.graphViewObserver);
        }
        DropTarget dropTarget = this.graph.getDropTarget();
        try {
            if (dropTarget != null) {
                this.defaultDropTargetListener = new GraphDropTargetListener();
                dropTarget.addDropTargetListener(this.defaultDropTargetListener);
            }
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.graph.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.graph.addMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.graph.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.graph.addKeyListener(this.keyListener);
        }
        if ((this.graphModelListener = this.createGraphModelListener()) != null && this.graphModel != null) {
            this.graphModel.addGraphModelListener(this.graphModelListener);
        }
        if ((this.graphSelectionListener = this.createGraphSelectionListener()) != null && this.graphSelectionModel != null) {
            this.graphSelectionModel.addGraphSelectionListener(this.graphSelectionListener);
        }
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.graph, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.graph, 0, inputMap);
        SwingUtilities.replaceUIActionMap(this.graph, this.createActionMap());
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("Tree.ancestorInputMap");
        }
        if (n == 0) {
            return (InputMap)UIManager.get("Tree.focusInputMap");
        }
        return null;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("selectPrevious", new GraphIncrementAction(1, "selectPrevious"));
        actionMapUIResource.put("selectPreviousChangeLead", new GraphIncrementAction(1, "selectPreviousLead"));
        actionMapUIResource.put("selectPreviousExtendSelection", new GraphIncrementAction(1, "selectPreviousExtendSelection"));
        actionMapUIResource.put("selectParent", new GraphIncrementAction(4, "selectParent"));
        actionMapUIResource.put("selectParentChangeLead", new GraphIncrementAction(4, "selectParentChangeLead"));
        actionMapUIResource.put("selectNext", new GraphIncrementAction(3, "selectNext"));
        actionMapUIResource.put("selectNextChangeLead", new GraphIncrementAction(3, "selectNextLead"));
        actionMapUIResource.put("selectNextExtendSelection", new GraphIncrementAction(3, "selectNextExtendSelection"));
        actionMapUIResource.put("selectChild", new GraphIncrementAction(2, "selectChild"));
        actionMapUIResource.put("selectChildChangeLead", new GraphIncrementAction(2, "selectChildChangeLead"));
        actionMapUIResource.put("cancel", new GraphCancelEditingAction("cancel"));
        actionMapUIResource.put("startEditing", new GraphEditAction("startEditing"));
        actionMapUIResource.put("selectAll", new GraphSelectAllAction("selectAll", true));
        actionMapUIResource.put("clearSelection", new GraphSelectAllAction("clearSelection", false));
        actionMapUIResource.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMapUIResource.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMapUIResource.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        return actionMapUIResource;
    }

    protected void installComponents() {
        this.rendererPane = this.createCellRendererPane();
        if (this.rendererPane != null) {
            this.graph.add(this.rendererPane);
        }
    }

    protected TransferHandler createTransferHandler() {
        return new GraphTransferHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected GraphSelectionListener createGraphSelectionListener() {
        return new GraphSelectionHandler();
    }

    protected CellEditorListener createCellEditorListener() {
        return new CellEditorHandler();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected Observer createGraphViewObserver() {
        return new GraphViewObserver();
    }

    protected GraphModelListener createGraphModelListener() {
        return new GraphModelHandler();
    }

    public void uninstallUI(JComponent jComponent) {
        this.cancelEditing(this.graph);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    protected void completeUIUninstall() {
        this.graphLayoutCache = null;
        this.rendererPane = null;
        this.componentListener = null;
        this.propertyChangeListener = null;
        this.keyListener = null;
        this.setSelectionModel(null);
        this.graph = null;
        this.graphModel = null;
        this.graphSelectionModel = null;
        this.graphSelectionListener = null;
    }

    protected void uninstallListeners() {
        TransferHandler transferHandler = this.graph.getTransferHandler();
        if (transferHandler == this.defaultTransferHandler) {
            this.graph.setTransferHandler(null);
        }
        if (this.graphViewObserver != null) {
            this.graphLayoutCache.deleteObserver(this.graphViewObserver);
        }
        if (this.graph.getDropTarget() != null && this.defaultDropTargetListener != null) {
            this.graph.getDropTarget().removeDropTargetListener(this.defaultDropTargetListener);
        }
        if (this.componentListener != null) {
            this.graph.removeComponentListener(this.componentListener);
        }
        if (this.propertyChangeListener != null) {
            this.graph.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.mouseListener != null) {
            this.graph.removeMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.graph.removeMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if (this.keyListener != null) {
            this.graph.removeKeyListener(this.keyListener);
        }
        if (this.graphModel != null && this.graphModelListener != null) {
            this.graphModel.removeGraphModelListener(this.graphModelListener);
        }
        if (this.graphSelectionListener != null && this.graphSelectionModel != null) {
            this.graphSelectionModel.removeGraphSelectionListener(this.graphSelectionListener);
        }
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.graph, null);
        SwingUtilities.replaceUIInputMap(this.graph, 1, null);
        SwingUtilities.replaceUIInputMap(this.graph, 0, null);
    }

    protected void uninstallComponents() {
        if (this.rendererPane != null) {
            this.graph.remove(this.rendererPane);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.graph != jComponent) {
            throw new InternalError("BasicGraphUI cannot paint " + jComponent.toString() + "; " + this.graph + " was expected.");
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = new Rectangle(graphics.getClipBounds());
        Rectangle rectangle2 = this.graph.fromScreen(new Rectangle(rectangle));
        this.paintBackground(graphics);
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.graph.isAntiAliased()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        double d = this.graph.getScale();
        graphics2D.scale(d, d);
        CellView[] cellViewArray = this.graphLayoutCache.getRoots();
        int n = 0;
        while (n < cellViewArray.length) {
            Rectangle rectangle3 = cellViewArray[n].getBounds();
            if (rectangle3 != null && rectangle2 != null && rectangle3.intersects(rectangle2)) {
                this.paintCell(graphics, cellViewArray[n], rectangle3, false);
            }
            ++n;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setTransform(affineTransform);
        this.paintForeground(graphics);
        if (this.handle != null) {
            this.handle.paint(graphics);
        }
        graphics.setColor(this.graph.getMarqueeColor());
        graphics.setXORMode(this.graph.getBackground());
        if (this.marquee != null) {
            this.marquee.paint(graphics);
        }
        graphics.setPaintMode();
        if (this.rendererPane != null) {
            this.rendererPane.removeAll();
        }
    }

    public void paintCell(Graphics graphics, CellView cellView, Rectangle rectangle, boolean bl) {
        int n;
        if (cellView != null && rectangle != null) {
            boolean bl2 = cellView == this.focus;
            n = this.graph.isCellSelected(cellView.getCell()) ? 1 : 0;
            Component component = cellView.getRendererComponent(this.graph, n != 0, bl2, bl);
            this.rendererPane.paintComponent(graphics, component, this.graph, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
        if (!cellView.isLeaf()) {
            CellView[] cellViewArray = cellView.getChildViews();
            n = 0;
            while (n < cellViewArray.length) {
                this.paintCell(graphics, cellViewArray[n], cellViewArray[n].getBounds(), bl);
                ++n;
            }
        }
    }

    protected void paintBackground(Graphics graphics) {
        if (this.graph.isGridVisible()) {
            this.paintGrid(this.graph.getGridSize(), graphics, graphics.getClipBounds());
        }
    }

    protected void paintGrid(int n, Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2 = graphics.getClipBounds();
        double d = rectangle2.x;
        double d2 = rectangle2.y;
        double d3 = d + (double)rectangle2.width;
        double d4 = d2 + (double)rectangle2.height;
        double d5 = (double)n * this.graph.getScale();
        while (d5 < 2.0) {
            d5 *= 2.0;
        }
        if (d5 >= 0.0) {
            int n2 = (int)(Math.floor(d / d5) * d5);
            int n3 = (int)(Math.ceil(d3 / d5) * d5);
            int n4 = (int)(Math.floor(d2 / d5) * d5);
            int n5 = (int)(Math.ceil(d4 / d5) * d5);
            graphics.setColor(this.graph.getGridColor());
            switch (this.graph.getGridMode()) {
                case 1: {
                    int n6 = d5 > 16.0 ? 2 : (d5 < 8.0 ? 0 : 1);
                    double d6 = n2;
                    while (d6 <= (double)n3) {
                        double d7 = n4;
                        while (d7 <= (double)n5) {
                            int n7 = (int)Math.round(d6);
                            int n8 = (int)Math.round(d7);
                            graphics.drawLine(n7 - n6, n8, n7 + n6, n8);
                            graphics.drawLine(n7, n8 - n6, n7, n8 + n6);
                            d7 += d5;
                        }
                        d6 += d5;
                    }
                    break;
                }
                case 2: {
                    n3 += (int)Math.ceil(d5);
                    n5 += (int)Math.ceil(d5);
                    double d8 = n2;
                    while (d8 <= (double)n3) {
                        int n9 = (int)Math.round(d8);
                        graphics.drawLine(n9, n4, n9, n5);
                        d8 += d5;
                    }
                    double d9 = n4;
                    while (d9 <= (double)n5) {
                        int n10 = (int)Math.round(d9);
                        graphics.drawLine(n2, n10, n3, n10);
                        d9 += d5;
                    }
                    break;
                }
                default: {
                    double d10 = n2;
                    while (d10 <= (double)n3) {
                        double d11 = n4;
                        while (d11 <= (double)n5) {
                            int n11 = (int)Math.round(d10);
                            int n12 = (int)Math.round(d11);
                            graphics.drawLine(n11, n12, n11, n12);
                            d11 += d5;
                        }
                        d10 += d5;
                    }
                    break block0;
                }
            }
        }
    }

    protected void paintForeground(Graphics graphics) {
        if (this.graph.isPortsVisible()) {
            this.paintPorts(graphics, this.graphLayoutCache.getPorts());
        }
    }

    public void paintPorts(Graphics graphics, CellView[] cellViewArray) {
        if (cellViewArray != null) {
            Rectangle rectangle = graphics.getClipBounds();
            int n = 0;
            while (n < cellViewArray.length) {
                if (cellViewArray[n] != null) {
                    Rectangle rectangle2 = new Rectangle(cellViewArray[n].getBounds());
                    Point point = this.graph.toScreen(new Point((int)rectangle2.getCenterX(), (int)rectangle2.getCenterY()));
                    rectangle2.setLocation(point.x - rectangle2.width / 2, point.y - rectangle2.height / 2);
                    if (rectangle == null || rectangle2.intersects(rectangle)) {
                        this.paintCell(graphics, cellViewArray[n], rectangle2, false);
                    }
                }
                ++n;
            }
        }
    }

    protected void updateHandle() {
        if (this.graphLayoutCache != null) {
            Object[] objectArray = this.graphLayoutCache.order(this.graph.getSelectionCells());
            this.handle = objectArray != null && objectArray.length > 0 ? this.createHandle(this.createContext(this.graph, objectArray)) : null;
        }
    }

    protected GraphContext createContext(JGraph jGraph, Object[] objectArray) {
        return new GraphContext(jGraph, objectArray);
    }

    public CellHandle createHandle(GraphContext graphContext) {
        if (graphContext != null && !graphContext.isEmpty() && this.graph.isEnabled()) {
            return new RootHandle(graphContext);
        }
        return null;
    }

    public void updateSize() {
        this.validCachedPreferredSize = false;
        this.graph.graphDidChange();
        this.updateHandle();
    }

    protected void updateCachedPreferredSize() {
        Rectangle rectangle = AbstractCellView.getBounds(this.graphLayoutCache.getRoots());
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        Point point = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        Dimension dimension = this.graph.getMinimumSize();
        Point point2 = dimension != null ? this.graph.toScreen(new Point(dimension.width, dimension.height)) : new Point(0, 0);
        Point point3 = this.graph.toScreen(point);
        this.preferredSize = new Dimension(Math.max(point2.x, point3.x), Math.max(point2.y, point3.y));
        Insets insets = this.graph.getInsets();
        if (insets != null) {
            this.preferredSize.width += insets.left + insets.right;
            this.preferredSize.height += insets.top + insets.bottom;
        }
        this.validCachedPreferredSize = true;
    }

    public void setPreferredMinSize(Dimension dimension) {
        this.preferredMinSize = dimension;
    }

    public Dimension getPreferredMinSize() {
        if (this.preferredMinSize == null) {
            return null;
        }
        return new Dimension(this.preferredMinSize);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredMinSize();
        if (!this.validCachedPreferredSize) {
            this.updateCachedPreferredSize();
        }
        if (this.graph != null) {
            if (dimension != null) {
                return new Dimension(Math.max(dimension.width, this.preferredSize.width), Math.max(dimension.height, this.preferredSize.height));
            }
            return new Dimension(this.preferredSize.width, this.preferredSize.height);
        }
        if (dimension != null) {
            return dimension;
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (this.graph != null) {
            return this.getPreferredSize(this.graph);
        }
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    protected void completeEditing() {
        if (this.graph.getInvokesStopCellEditing() && this.stopEditingInCompleteEditing && this.editingComponent != null) {
            this.cellEditor.stopCellEditing();
        }
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean bl, boolean bl2, boolean bl3) {
        if (this.stopEditingInCompleteEditing && this.editingComponent != null) {
            Component component = this.editingComponent;
            Object object = this.editingCell;
            GraphCellEditor graphCellEditor = this.cellEditor;
            Object object2 = graphCellEditor.getCellEditorValue();
            boolean bl4 = this.graph != null && (this.graph.hasFocus() || this.editingComponent.hasFocus());
            this.editingCell = null;
            this.editingComponent = null;
            if (bl) {
                graphCellEditor.stopCellEditing();
            } else if (bl2) {
                graphCellEditor.cancelCellEditing();
            }
            this.graph.remove(component);
            if (bl4) {
                this.graph.requestFocus();
            }
            if (bl3) {
                Map map = GraphConstants.createAttributes(object, (Object)"value", object2);
                this.graphLayoutCache.edit(map, null, null, null);
            }
            this.updateSize();
            if (graphCellEditor != null && this.cellEditorListener != null) {
                graphCellEditor.removeCellEditorListener(this.cellEditorListener);
            }
            this.cellEditor = null;
        }
    }

    protected boolean startEditing(Object object, MouseEvent mouseEvent) {
        this.completeEditing();
        if (this.graph.isCellEditable(object)) {
            CellView cellView = this.graphLayoutCache.getMapping(object, false);
            this.cellEditor = cellView.getEditor();
            this.editingComponent = this.cellEditor.getGraphCellEditorComponent(this.graph, object, this.graph.isCellSelected(object));
            if (this.cellEditor.isCellEditable(mouseEvent)) {
                Serializable serializable;
                Serializable serializable2;
                Rectangle rectangle = this.graph.getCellBounds(object);
                this.editingCell = object;
                Dimension dimension = this.editingComponent.getPreferredSize();
                this.graph.add(this.editingComponent);
                Point point = this.graph.toScreen(new Point(rectangle.x, rectangle.y));
                if (this.graphLayoutCache.getMapping(object, false) instanceof EdgeView) {
                    serializable2 = (EdgeView)this.graphLayoutCache.getMapping(object, false);
                    serializable = serializable2.getEdgeRenderer();
                    point = serializable.getLabelPosition((EdgeView)serializable2);
                    point.x -= dimension.width / 2;
                    point.y -= dimension.height / 2;
                    this.graph.toScreen(point);
                }
                this.editingComponent.setBounds(point.x, point.y, dimension.width, dimension.height);
                this.editingCell = object;
                this.editingComponent.validate();
                if (this.cellEditorListener == null) {
                    this.cellEditorListener = this.createCellEditorListener();
                }
                if (this.cellEditor != null && this.cellEditorListener != null) {
                    this.cellEditor.addCellEditorListener(this.cellEditorListener);
                }
                serializable2 = this.graph.getVisibleRect();
                this.graph.paintImmediately(point.x, point.y, ((Rectangle)serializable2).width + ((Rectangle)serializable2).x - rectangle.x, dimension.height);
                if (this.cellEditor.shouldSelectCell(mouseEvent)) {
                    this.stopEditingInCompleteEditing = false;
                    try {
                        this.graph.setSelectionCell(object);
                    }
                    catch (Exception exception) {
                        System.err.println("Editing exception: " + exception);
                    }
                    this.stopEditingInCompleteEditing = true;
                }
                if (mouseEvent instanceof MouseEvent) {
                    serializable = SwingUtilities.convertPoint(this.graph, new Point(mouseEvent.getX(), mouseEvent.getY()), this.editingComponent);
                    Component component = SwingUtilities.getDeepestComponentAt(this.editingComponent, ((Point)serializable).x, ((Point)serializable).y);
                    if (component != null) {
                        new MouseInputHandler(this.graph, component, mouseEvent);
                    }
                }
                return true;
            }
            this.editingComponent = null;
        }
        return false;
    }

    public static void autoscroll(JGraph jGraph, Point point) {
        Rectangle rectangle = jGraph.getBounds();
        if (jGraph.getParent() instanceof JViewport) {
            rectangle = ((JViewport)jGraph.getParent()).getViewRect();
        }
        if (rectangle.contains(point)) {
            Point point2 = new Point(point);
            int n = (int)((float)jGraph.getWidth() * SCROLLSTEP);
            int n2 = (int)((float)jGraph.getHeight() * SCROLLSTEP);
            if (point2.x - rectangle.x < SCROLLBORDER) {
                point2.x -= n;
            }
            if (point2.y - rectangle.y < SCROLLBORDER) {
                point2.y -= n2;
            }
            if (rectangle.x + rectangle.width - point2.x < SCROLLBORDER) {
                point2.x += n;
            }
            if (rectangle.y + rectangle.height - point2.y < SCROLLBORDER) {
                point2.y += n2;
            }
            jGraph.scrollPointToVisible(point2);
        }
    }

    public void insertCells(Object[] objectArray, Map map, ConnectionSet connectionSet, ParentMap parentMap, boolean bl, int n, int n2) {
        if (bl) {
            Map map2 = this.graph.cloneCells(objectArray);
            map = GraphConstants.replaceKeys(map2, map);
            GraphConstants.translate(map.values(), n, n2);
            connectionSet = connectionSet.clone(map2);
            parentMap = parentMap.clone(map2);
            int n3 = 0;
            while (n3 < objectArray.length) {
                objectArray[n3] = map2.get(objectArray[n3]);
                ++n3;
            }
        }
        this.graphLayoutCache.insert(objectArray, map, connectionSet, parentMap, null);
    }

    public boolean isSnapSelectedView() {
        return this.snapSelectedView;
    }

    public void setSnapSelectedView(boolean bl) {
        this.snapSelectedView = bl;
    }

    public class GraphTransferHandler
    extends TransferHandler {
        protected Object out;
        protected Object in;
        protected int inCount = 0;

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return true;
        }

        public Transferable createTransferable() {
            return this.createTransferable(BasicGraphUI.this.graph);
        }

        protected final Transferable createTransferable(JComponent jComponent) {
            JGraph jGraph;
            Object[] objectArray;
            if (jComponent instanceof JGraph && (objectArray = BasicGraphUI.this.graphLayoutCache.order((jGraph = (JGraph)jComponent).getSelectionCells())) != null && objectArray.length > 0) {
                Object[] objectArray2 = BasicGraphUI.this.graphLayoutCache.order(jGraph.getDescendantList(objectArray));
                ParentMap parentMap = ParentMap.create(BasicGraphUI.this.graphModel, objectArray2, false, true);
                ConnectionSet connectionSet = ConnectionSet.create(BasicGraphUI.this.graphModel, objectArray2, false);
                Map map = GraphConstants.createAttributes(objectArray2, BasicGraphUI.this.graphLayoutCache);
                Rectangle rectangle = jGraph.getCellBounds(objectArray);
                this.out = objectArray2;
                return this.create(jGraph, objectArray2, map, rectangle, connectionSet, parentMap);
            }
            return null;
        }

        protected GraphTransferable create(JGraph jGraph, Object[] objectArray, Map map, Rectangle rectangle, ConnectionSet connectionSet, ParentMap parentMap) {
            return new GraphTransferable(objectArray, map, rectangle, connectionSet, parentMap);
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (jComponent instanceof JGraph && transferable instanceof GraphTransferable && n == 2) {
                JGraph jGraph = (JGraph)jComponent;
                Object[] objectArray = ((GraphTransferable)transferable).getCells();
                jGraph.getGraphLayoutCache().remove(objectArray);
            }
            BasicGraphUI.this.updateHandle();
            BasicGraphUI.this.setInsertionLocation(null);
        }

        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            try {
                if (jComponent instanceof JGraph) {
                    JGraph jGraph = (JGraph)jComponent;
                    if (transferable.isDataFlavorSupported(GraphTransferable.dataFlavor)) {
                        Point point = BasicGraphUI.this.getInsertionLocation();
                        Object object = transferable.getTransferData(GraphTransferable.dataFlavor);
                        GraphTransferable graphTransferable = (GraphTransferable)object;
                        Object[] objectArray = graphTransferable.getCells();
                        boolean bl = true;
                        int n = 0;
                        while (n < objectArray.length && bl) {
                            bl = bl && jGraph.getModel().contains(objectArray[n]);
                            ++n;
                        }
                        this.inCount = this.in == objectArray ? ++this.inCount : (bl ? 1 : 0);
                        this.in = objectArray;
                        if (point != null && this.in == this.out && BasicGraphUI.this.handle != null) {
                            int n2 = BasicGraphUI.this.dropAction == 1 ? 2 : 0;
                            BasicGraphUI.this.handle.mouseReleased(new MouseEvent(jComponent, 0, 0L, n2, point.x, point.y, 1, false));
                            return false;
                        }
                        Rectangle rectangle = graphTransferable.getBounds();
                        Map map = graphTransferable.getAttributeMap();
                        ConnectionSet connectionSet = graphTransferable.getConnectionSet();
                        ParentMap parentMap = graphTransferable.getParentMap();
                        if (!bl || point == null || BasicGraphUI.this.dropAction == 1) {
                            Object[] objectArray2;
                            Map map2 = jGraph.cloneCells(objectArray);
                            map = GraphConstants.replaceKeys(map2, map);
                            connectionSet = connectionSet.clone(map2);
                            parentMap = parentMap.clone(map2);
                            int n3 = 0;
                            int n4 = 0;
                            if (point != null) {
                                objectArray2 = jGraph.fromScreen(jGraph.snap(new Point(point)));
                                n3 = objectArray2.x - rectangle.x;
                                n4 = objectArray2.y - rectangle.y;
                            } else {
                                n3 = this.inCount * jGraph.getGridSize();
                                n4 = this.inCount * jGraph.getGridSize();
                            }
                            GraphConstants.translate(map.values(), n3, n4);
                            objectArray2 = new Object[objectArray.length];
                            int n5 = 0;
                            while (n5 < objectArray.length) {
                                objectArray2[n5] = map2.get(objectArray[n5]);
                                ++n5;
                            }
                            jGraph.getGraphLayoutCache().insert(objectArray2, map, connectionSet, parentMap, null);
                            return BasicGraphUI.this.dropAction == 2 && !bl;
                        }
                        if (point != null) {
                            Point point2 = jGraph.fromScreen(jGraph.snap(new Point(point)));
                            int n6 = point2.x - rectangle.x;
                            int n7 = point2.y - rectangle.y;
                            GraphConstants.translate(map.values(), n6, n7);
                            jGraph.getGraphLayoutCache().edit(map, null, null, null);
                        }
                        jGraph.setSelectionCells(objectArray);
                        return false;
                    }
                    return this.importDataImpl(jComponent, transferable);
                }
            }
            catch (Exception exception) {}
            return false;
        }

        protected boolean importDataImpl(JComponent jComponent, Transferable transferable) {
            return false;
        }
    }

    public class GraphDropTargetListener
    extends BasicGraphDropTargetListener
    implements Serializable {
        protected void saveComponentState(JComponent jComponent) {
        }

        protected void restoreComponentState(JComponent jComponent) {
            if (BasicGraphUI.this.handle != null) {
                BasicGraphUI.this.handle.mouseDragged(null);
            }
        }

        protected void updateInsertionLocation(JComponent jComponent, Point point) {
            BasicGraphUI.this.setInsertionLocation(point);
            if (BasicGraphUI.this.handle != null) {
                int n = BasicGraphUI.this.dropAction == 1 ? 2 : 0;
                BasicGraphUI.this.handle.mouseDragged(new MouseEvent(jComponent, 0, 0L, n, point.x, point.y, 1, false));
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            BasicGraphUI.this.dropAction = dropTargetDragEvent.getDropAction();
            super.dragEnter(dropTargetDragEvent);
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            BasicGraphUI.this.dropAction = dropTargetDragEvent.getDropAction();
            super.dropActionChanged(dropTargetDragEvent);
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected Component source;
        protected Component destination;

        public MouseInputHandler(Component component, Component component2, MouseEvent mouseEvent) {
            this.source = component;
            this.destination = component2;
            this.source.addMouseListener(this);
            this.source.addMouseMotionListener(this);
            component2.dispatchEvent(SwingUtilities.convertMouseEvent(component, mouseEvent, component2));
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
            this.removeFromSource();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.removeFromSource();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.removeFromSource();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.removeFromSource();
        }

        protected void removeFromSource() {
            if (this.source != null) {
                this.source.removeMouseListener(this);
                this.source.removeMouseMotionListener(this);
            }
            this.destination = null;
            this.source = null;
        }
    }

    private class GraphSelectAllAction
    extends AbstractAction {
        private boolean selectAll;

        public GraphSelectAllAction(String string, boolean bl) {
            this.selectAll = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicGraphUI.this.graph != null) {
                if (this.selectAll) {
                    Object[] objectArray = new Object[BasicGraphUI.this.graphModel.getRootCount()];
                    int n = 0;
                    while (n < objectArray.length) {
                        objectArray[n] = BasicGraphUI.this.graphModel.getRootAt(n);
                        ++n;
                    }
                    BasicGraphUI.this.graph.addSelectionCells(objectArray);
                } else {
                    BasicGraphUI.this.graph.clearSelection();
                }
            }
        }

        public boolean isEnabled() {
            return BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled();
        }
    }

    private class GraphEditAction
    extends AbstractAction {
        public GraphEditAction(String string) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isEnabled() && BasicGraphUI.this.getFocusedCell() instanceof GraphCell) {
                BasicGraphUI.this.graph.startEditingAtCell(BasicGraphUI.this.getFocusedCell());
            }
        }

        public boolean isEnabled() {
            return BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled();
        }
    }

    private class GraphCancelEditingAction
    extends AbstractAction {
        public GraphCancelEditingAction(String string) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicGraphUI.this.graph != null) {
                BasicGraphUI.this.cancelEditing(BasicGraphUI.this.graph);
            }
        }

        public boolean isEnabled() {
            return BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled();
        }
    }

    public class GraphIncrementAction
    extends AbstractAction {
        protected int direction;

        private GraphIncrementAction(int n, String string) {
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicGraphUI.this.graph != null) {
                int n = 70;
                Rectangle rectangle = BasicGraphUI.this.graph.getVisibleRect();
                if (this.direction == 1) {
                    rectangle.translate(0, -n);
                } else if (this.direction == 2) {
                    rectangle.translate(n, 0);
                } else if (this.direction == 3) {
                    rectangle.translate(0, n);
                } else if (this.direction == 4) {
                    rectangle.translate(-n, 0);
                }
                BasicGraphUI.this.graph.scrollRectToVisible(rectangle);
            }
        }

        public boolean isEnabled() {
            return BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled();
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener,
    Serializable {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == BasicGraphUI.this.graph) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("minimumSize")) {
                    BasicGraphUI.this.updateCachedPreferredSize();
                } else if (string.equals("model")) {
                    BasicGraphUI.this.setModel((GraphModel)propertyChangeEvent.getNewValue());
                } else if (string.equals("view")) {
                    BasicGraphUI.this.setGraphLayoutCache((GraphLayoutCache)propertyChangeEvent.getNewValue());
                    BasicGraphUI.this.graph.repaint();
                } else if (string.equals("marquee")) {
                    BasicGraphUI.this.setMarquee((BasicMarqueeHandler)propertyChangeEvent.getNewValue());
                } else if (string.equals("editable")) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    if (!bl && BasicGraphUI.this.isEditing(BasicGraphUI.this.graph)) {
                        BasicGraphUI.this.cancelEditing(BasicGraphUI.this.graph);
                    }
                } else if (string.equals("selectionModel")) {
                    BasicGraphUI.this.setSelectionModel(BasicGraphUI.this.graph.getSelectionModel());
                } else if (string.equals("gridVisible") || string.equals("gridSize") || string.equals("portsVisible") || string.equals("antiAliased")) {
                    BasicGraphUI.this.graph.repaint();
                } else if (string.equals("scale")) {
                    BasicGraphUI.this.updateSize();
                } else if (string.equals("font")) {
                    BasicGraphUI.this.completeEditing();
                    BasicGraphUI.this.updateSize();
                } else if (string.equals("componentOrientation") && BasicGraphUI.this.graph != null) {
                    BasicGraphUI.this.graph.graphDidChange();
                }
            }
        }
    }

    public class RootHandle
    implements CellHandle,
    Serializable {
        protected transient int _mouseToViewDelta_x = 0;
        protected transient int _mouseToViewDelta_y = 0;
        protected transient Image offscreen;
        protected transient Graphics offgraphics;
        protected transient boolean firstDrag = true;
        protected transient CellView[] views;
        protected transient CellView[] contextViews;
        protected transient CellView[] portViews;
        protected transient Rectangle cachedBounds;
        protected transient CellHandle[] handles;
        protected transient Point start = null;
        protected transient Point last;
        protected transient Point snapStart;
        protected transient Point snapLast;
        protected boolean isMoving = false;
        protected boolean isDragging = false;
        protected transient CellHandle activeHandle = null;
        protected transient GraphContext context;
        protected boolean isContextVisible = true;
        protected boolean blockPaint = false;
        protected transient ConnectionSet disconnect = null;

        public RootHandle(GraphContext graphContext) {
            this.context = graphContext;
            if (!graphContext.isEmpty()) {
                this.views = graphContext.createTemporaryCellViews();
                if (graphContext.getDescendantCount() < MAXCELLS) {
                    this.contextViews = graphContext.createTemporaryContextViews();
                } else {
                    this.cachedBounds = BasicGraphUI.this.graph.toScreen(BasicGraphUI.this.graph.getCellBounds(graphContext.getCells()));
                }
                Object[] objectArray = graphContext.getCells();
                if (objectArray.length < MAXHANDLES) {
                    this.handles = new CellHandle[this.views.length];
                    int n = 0;
                    while (n < this.views.length) {
                        this.handles[n] = this.views[n].getHandle(graphContext);
                        ++n;
                    }
                    this.portViews = graphContext.createTemporaryPortViews();
                }
            }
        }

        public GraphContext getContext() {
            return this.context;
        }

        public void paint(Graphics graphics) {
            if (this.handles != null && this.handles.length < MAXHANDLES) {
                int n = 0;
                while (n < this.handles.length) {
                    if (this.handles[n] != null) {
                        this.handles[n].paint(graphics);
                    }
                    ++n;
                }
            }
            this.blockPaint = true;
        }

        public void overlay(Graphics graphics) {
            if (this.isDragging && !DNDPREVIEW) {
                return;
            }
            if (this.cachedBounds != null) {
                graphics.setColor(Color.black);
                graphics.drawRect(this.cachedBounds.x, this.cachedBounds.y, this.cachedBounds.width - 2, this.cachedBounds.height - 2);
            } else {
                int n;
                Graphics2D graphics2D = (Graphics2D)graphics;
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.scale(BasicGraphUI.this.graph.getScale(), BasicGraphUI.this.graph.getScale());
                if (this.views != null) {
                    n = 0;
                    while (n < this.views.length) {
                        BasicGraphUI.this.paintCell(graphics, this.views[n], this.views[n].getBounds(), true);
                        ++n;
                    }
                }
                if (this.contextViews != null && this.isContextVisible) {
                    n = 0;
                    while (n < this.contextViews.length) {
                        BasicGraphUI.this.paintCell(graphics, this.contextViews[n], this.contextViews[n].getBounds(), true);
                        ++n;
                    }
                }
                graphics2D.setTransform(affineTransform);
                if (this.portViews != null && BasicGraphUI.this.graph.isPortsVisible()) {
                    BasicGraphUI.this.paintPorts(graphics, this.portViews);
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed() && this.handles != null) {
                int n = this.handles.length - 1;
                while (n >= 0 && !mouseEvent.isConsumed()) {
                    if (this.handles[n] != null) {
                        this.handles[n].mouseMoved(mouseEvent);
                    }
                    --n;
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed() && BasicGraphUI.this.graph.isMoveable()) {
                Point point;
                Point point2;
                CellView cellView;
                if (this.handles != null) {
                    int n = this.handles.length - 1;
                    while (n >= 0) {
                        if (this.handles[n] != null) {
                            this.handles[n].mousePressed(mouseEvent);
                            if (mouseEvent.isConsumed()) {
                                this.activeHandle = this.handles[n];
                                return;
                            }
                        }
                        --n;
                    }
                }
                if (this.views != null && (cellView = this.findViewForPoint(point2 = BasicGraphUI.this.graph.fromScreen(new Point(point = mouseEvent.getPoint())))) != null) {
                    if (BasicGraphUI.this.snapSelectedView) {
                        Rectangle rectangle = cellView.getBounds();
                        this.start = BasicGraphUI.this.graph.toScreen(new Point(rectangle.x, rectangle.y));
                        this.snapStart = BasicGraphUI.this.graph.snap(new Point(this.start));
                        this._mouseToViewDelta_x = point.x - this.start.x;
                        this._mouseToViewDelta_y = point.y - this.start.y;
                    } else {
                        this.snapStart = BasicGraphUI.this.graph.snap(new Point(point));
                        this._mouseToViewDelta_x = this.snapStart.x - point.x;
                        this._mouseToViewDelta_y = this.snapStart.y - point.y;
                        this.start = new Point(this.snapStart);
                    }
                    this.last = new Point(this.start);
                    this.snapLast = new Point(this.snapStart);
                    this.isContextVisible = this.contextViews != null && this.contextViews.length < MAXCELLS && (!mouseEvent.isControlDown() || !BasicGraphUI.this.graph.isCloneable());
                    mouseEvent.consume();
                }
            }
        }

        protected CellView findViewForPoint(Point point) {
            int n = BasicGraphUI.this.graph.getTolerance();
            Rectangle rectangle = new Rectangle(point.x - n, point.y - n, 2 * n, 2 * n);
            int n2 = 0;
            while (n2 < this.views.length) {
                if (this.views[n2].intersects(BasicGraphUI.this.graph.getGraphics(), rectangle)) {
                    return this.views[n2];
                }
                ++n2;
            }
            return null;
        }

        protected void startDragging(MouseEvent mouseEvent) {
            block2: {
                this.isDragging = true;
                if (!BasicGraphUI.this.graph.isDragEnabled()) break block2;
                int n = mouseEvent.isControlDown() && BasicGraphUI.this.graph.isCloneable() ? 1 : 2;
                TransferHandler transferHandler = BasicGraphUI.this.graph.getTransferHandler();
                try {
                    transferHandler.exportAsDrag(BasicGraphUI.this.graph, mouseEvent, n);
                }
                catch (Exception exception) {}
            }
        }

        protected void initOffscreen() {
            try {
                Rectangle rectangle = BasicGraphUI.this.graph.getBounds();
                this.offscreen = new BufferedImage(rectangle.width, rectangle.height, 1);
                this.offgraphics = this.offscreen.getGraphics();
                this.offgraphics.setClip(0, 0, (int)rectangle.getWidth(), (int)rectangle.getHeight());
                this.offgraphics.setColor(BasicGraphUI.this.graph.getBackground());
                this.offgraphics.fillRect(0, 0, (int)rectangle.getWidth(), (int)rectangle.getHeight());
                BasicGraphUI.this.graph.getUI().paint(this.offgraphics, BasicGraphUI.this.graph);
            }
            catch (Error error) {
                this.offscreen = null;
                this.offgraphics = null;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            boolean bl = BasicGraphUI.this.isConstrainedMoveEvent(mouseEvent);
            Rectangle rectangle = null;
            if (this.firstDrag && BasicGraphUI.this.graph.isDoubleBuffered() && this.cachedBounds == null) {
                this.initOffscreen();
                this.firstDrag = false;
            }
            if (mouseEvent != null && !mouseEvent.isConsumed()) {
                if (this.activeHandle != null) {
                    this.activeHandle.mouseDragged(mouseEvent);
                } else if (this.start != null) {
                    Point point;
                    Graphics graphics = this.offgraphics != null ? this.offgraphics : BasicGraphUI.this.graph.getGraphics();
                    Point point2 = new Point(mouseEvent.getPoint());
                    point2.translate(-this._mouseToViewDelta_x, -this._mouseToViewDelta_y);
                    Point point3 = point = BasicGraphUI.this.graph.snap(point2);
                    int n = BasicGraphUI.this.graph.getMinimumMove();
                    int n2 = point3.x - this.start.x;
                    int n3 = point3.y - this.start.y;
                    if (this.isMoving || Math.abs(n2) > n || Math.abs(n3) > n) {
                        boolean bl2 = false;
                        this.isMoving = true;
                        if (this.disconnect == null && BasicGraphUI.this.graph.isDisconnectOnMove()) {
                            this.disconnect = this.context.disconnect(BasicGraphUI.this.graphLayoutCache.getAllDescendants(this.views));
                        }
                        if (bl && this.cachedBounds == null) {
                            int n4 = point3.x - this.start.x;
                            int n5 = point3.y - this.start.y;
                            if (Math.abs(n4) < Math.abs(n5)) {
                                n2 = 0;
                                n3 = n5;
                            } else {
                                n2 = n4;
                                n3 = 0;
                            }
                        } else {
                            n2 = point3.x - this.last.x;
                            n3 = point3.y - this.last.y;
                        }
                        double d = BasicGraphUI.this.graph.getScale();
                        n2 = (int)((double)n2 / d);
                        n3 = (int)((double)n3 / d);
                        graphics.setColor(BasicGraphUI.this.graph.getForeground());
                        graphics.setXORMode(BasicGraphUI.this.graph.getBackground().darker());
                        if (BasicGraphUI.this.graph.isDragEnabled() && !this.isDragging) {
                            this.startDragging(mouseEvent);
                        }
                        if (n2 != 0 || n3 != 0) {
                            int n6;
                            Object object;
                            if (!(this.snapLast.equals(this.snapStart) || this.offscreen == null && this.blockPaint)) {
                                this.overlay(graphics);
                                bl2 = true;
                            }
                            this.isContextVisible = (!mouseEvent.isControlDown() || !BasicGraphUI.this.graph.isCloneable()) && this.contextViews != null && this.contextViews.length < MAXCELLS;
                            this.blockPaint = false;
                            if (this.offscreen != null) {
                                rectangle = BasicGraphUI.this.graph.toScreen(AbstractCellView.getBounds(this.views));
                                object = BasicGraphUI.this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                                if (object != null) {
                                    rectangle.add((Rectangle)object);
                                }
                            }
                            if (bl && this.cachedBounds == null) {
                                object = BasicGraphUI.this.graphLayoutCache.getAllDescendants(this.views);
                                n6 = 0;
                                while (n6 < ((CellView[])object).length) {
                                    CellView cellView = BasicGraphUI.this.graphLayoutCache.getMapping(object[n6].getCell(), false);
                                    Map map = cellView.getAllAttributes();
                                    object[n6].setAttributes(GraphConstants.cloneMap(map));
                                    object[n6].refresh(false);
                                    ++n6;
                                }
                            }
                            if (this.cachedBounds != null) {
                                this.cachedBounds.translate((int)((double)n2 * d), (int)((double)n3 * d));
                            } else {
                                GraphLayoutCache.translateViews(this.views, n2, n3);
                                if (this.views != null) {
                                    BasicGraphUI.this.graphLayoutCache.update(this.views);
                                }
                                if (this.contextViews != null) {
                                    BasicGraphUI.this.graphLayoutCache.update(this.contextViews);
                                }
                            }
                            if (!point.equals(this.snapStart)) {
                                this.overlay(graphics);
                                bl2 = true;
                            }
                            if (bl) {
                                this.last = new Point(this.start);
                            }
                            this.last.translate((int)((double)n2 * d), (int)((double)n3 * d));
                            this.snapLast = point;
                            if (bl2 && this.offscreen != null) {
                                rectangle.add(BasicGraphUI.this.graph.toScreen(AbstractCellView.getBounds(this.views)));
                                object = BasicGraphUI.this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                                if (object != null) {
                                    rectangle.add((Rectangle)object);
                                }
                                rectangle.grow(2, 2);
                                n6 = Math.max(0, rectangle.x);
                                int n7 = Math.max(0, rectangle.y);
                                int n8 = n6 + rectangle.width;
                                int n9 = n7 + rectangle.height;
                                if (this.isDragging) {
                                    return;
                                }
                                BasicGraphUI.this.graph.getGraphics().drawImage(this.offscreen, n6, n7, n8, n9, n6, n7, n8, n9, BasicGraphUI.this.graph);
                            }
                        }
                    }
                }
            } else if (mouseEvent == null) {
                BasicGraphUI.this.graph.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent mouseEvent) {
            try {
                if (mouseEvent != null && !mouseEvent.isConsumed()) {
                    if (this.activeHandle != null) {
                        this.activeHandle.mouseReleased(mouseEvent);
                        this.activeHandle = null;
                    } else if (this.isMoving && !mouseEvent.getPoint().equals(this.start)) {
                        Serializable serializable;
                        if (this.cachedBounds != null) {
                            int n = mouseEvent.getX() - this.start.x;
                            int n2 = mouseEvent.getY() - this.start.y;
                            serializable = BasicGraphUI.this.graph.fromScreen(new Point(n, n2));
                            GraphLayoutCache.translateViews(this.views, serializable.x, serializable.y);
                        }
                        Object[] objectArray = BasicGraphUI.this.graphLayoutCache.getAllDescendants(this.views);
                        if (mouseEvent.isControlDown() && BasicGraphUI.this.graph.isCloneable()) {
                            Object[] objectArray2 = this.context.getCells();
                            objectArray2 = BasicGraphUI.this.graphLayoutCache.order(BasicGraphUI.this.graph.getDescendantList(objectArray2));
                            serializable = ConnectionSet.create(BasicGraphUI.this.graphModel, objectArray2, false);
                            ParentMap parentMap = ParentMap.create(BasicGraphUI.this.graphModel, objectArray2, false, true);
                            Map map = GraphConstants.createAttributes(objectArray, null);
                            BasicGraphUI.this.insertCells(objectArray2, map, (ConnectionSet)serializable, parentMap, true, 0, 0);
                        } else if (BasicGraphUI.this.graph.isMoveable()) {
                            Map map = GraphConstants.createAttributes(objectArray, null);
                            BasicGraphUI.this.graph.getGraphLayoutCache().edit(map, this.disconnect, null, null);
                        }
                        mouseEvent.consume();
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.isDragging = false;
                this.disconnect = null;
                this.offscreen = null;
                this.firstDrag = true;
                this.start = null;
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        protected CellView cell;
        protected Object handler;
        protected transient Cursor previousCursor = null;

        public void mousePressed(MouseEvent mouseEvent) {
            this.handler = null;
            if (!mouseEvent.isConsumed() && BasicGraphUI.this.graph.isEnabled()) {
                BasicGraphUI.this.graph.requestFocus();
                int n = BasicGraphUI.this.graph.getTolerance();
                Rectangle rectangle = BasicGraphUI.this.graph.fromScreen(new Rectangle(mouseEvent.getX() - n, mouseEvent.getY() - n, 2 * n, 2 * n));
                Point point = BasicGraphUI.this.graph.fromScreen(new Point(mouseEvent.getPoint()));
                BasicGraphUI.this.focus = BasicGraphUI.this.focus != null && BasicGraphUI.this.focus.intersects(BasicGraphUI.this.graph.getGraphics(), rectangle) ? BasicGraphUI.this.focus : null;
                this.cell = BasicGraphUI.this.graph.getNextViewAt(BasicGraphUI.this.focus, point.x, point.y);
                if (BasicGraphUI.this.focus == null) {
                    BasicGraphUI.this.focus = this.cell;
                }
                BasicGraphUI.this.completeEditing();
                if (!BasicGraphUI.this.isForceMarqueeEvent(mouseEvent)) {
                    if (mouseEvent.getClickCount() == BasicGraphUI.this.graph.getEditClickCount() && BasicGraphUI.this.focus != null && BasicGraphUI.this.focus.isLeaf() && BasicGraphUI.this.focus.getParentView() == null) {
                        this.handleEditTrigger(BasicGraphUI.this.focus.getCell(), mouseEvent);
                        mouseEvent.consume();
                        this.cell = null;
                    } else if (!BasicGraphUI.this.isToggleSelectionEvent(mouseEvent)) {
                        if (BasicGraphUI.this.handle != null) {
                            BasicGraphUI.this.handle.mousePressed(mouseEvent);
                            this.handler = BasicGraphUI.this.handle;
                        }
                        if (!mouseEvent.isConsumed() && this.cell != null && !BasicGraphUI.this.graph.isCellSelected(this.cell)) {
                            BasicGraphUI.this.selectCellForEvent(this.cell.getCell(), mouseEvent);
                            BasicGraphUI.this.focus = this.cell;
                            if (BasicGraphUI.this.handle != null) {
                                BasicGraphUI.this.handle.mousePressed(mouseEvent);
                                this.handler = BasicGraphUI.this.handle;
                            }
                            mouseEvent.consume();
                            this.cell = null;
                        }
                    }
                }
                if (!(mouseEvent.isConsumed() || BasicGraphUI.this.isToggleSelectionEvent(mouseEvent) && BasicGraphUI.this.focus != null || BasicGraphUI.this.marquee == null)) {
                    BasicGraphUI.this.marquee.mousePressed(mouseEvent);
                    this.handler = BasicGraphUI.this.marquee;
                }
            }
        }

        protected void handleEditTrigger(Object object, MouseEvent mouseEvent) {
            BasicGraphUI.this.graph.scrollCellToVisible(object);
            if (object != null) {
                BasicGraphUI.this.startEditing(object, mouseEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDragged(MouseEvent mouseEvent) {
            try {
                BasicGraphUI.autoscroll(BasicGraphUI.this.graph, mouseEvent.getPoint());
                if (this.handler != null && this.handler == BasicGraphUI.this.marquee) {
                    BasicGraphUI.this.marquee.mouseDragged(mouseEvent);
                } else if (this.handler == null && !BasicGraphUI.this.isEditing(BasicGraphUI.this.graph) && BasicGraphUI.this.focus != null) {
                    if (!BasicGraphUI.this.graph.isCellSelected(BasicGraphUI.this.focus.getCell())) {
                        BasicGraphUI.this.selectCellForEvent(BasicGraphUI.this.focus.getCell(), mouseEvent);
                        this.cell = null;
                    }
                    if (BasicGraphUI.this.handle != null) {
                        BasicGraphUI.this.handle.mousePressed(mouseEvent);
                    }
                    this.handler = BasicGraphUI.this.handle;
                }
                if (BasicGraphUI.this.handle != null && this.handler == BasicGraphUI.this.handle) {
                    BasicGraphUI.this.handle.mouseDragged(mouseEvent);
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.previousCursor == null) {
                this.previousCursor = BasicGraphUI.this.graph.getCursor();
            }
            if (BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled()) {
                if (BasicGraphUI.this.marquee != null) {
                    BasicGraphUI.this.marquee.mouseMoved(mouseEvent);
                }
                if (BasicGraphUI.this.handle != null) {
                    BasicGraphUI.this.handle.mouseMoved(mouseEvent);
                }
                if (!mouseEvent.isConsumed() && this.previousCursor != null) {
                    BasicGraphUI.this.graph.setCursor(this.previousCursor);
                    this.previousCursor = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent mouseEvent) {
            try {
                if (mouseEvent != null && !mouseEvent.isConsumed()) {
                    if (this.handler == BasicGraphUI.this.marquee && BasicGraphUI.this.marquee != null) {
                        BasicGraphUI.this.marquee.mouseReleased(mouseEvent);
                    } else if (this.handler == BasicGraphUI.this.handle && BasicGraphUI.this.handle != null) {
                        BasicGraphUI.this.handle.mouseReleased(mouseEvent);
                    }
                    if (this.isDescendant(this.cell, BasicGraphUI.this.focus) && mouseEvent.getModifiers() != 0) {
                        this.cell = BasicGraphUI.this.focus;
                    }
                    if (!mouseEvent.isConsumed() && this.cell != null) {
                        Object object = this.cell.getCell();
                        boolean bl = BasicGraphUI.this.graph.isCellSelected(object);
                        BasicGraphUI.this.selectCellForEvent(object, mouseEvent);
                        BasicGraphUI.this.focus = this.cell;
                        this.postProcessSelection(mouseEvent, object, bl);
                    }
                }
                Object var5_4 = null;
                this.handler = null;
                this.cell = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.handler = null;
                this.cell = null;
                throw throwable;
            }
        }

        protected void postProcessSelection(MouseEvent mouseEvent, Object object, boolean bl) {
            if (bl && BasicGraphUI.this.graph.isCellSelected(object)) {
                Object object2 = object;
                Object object3 = null;
                while ((object3 = BasicGraphUI.this.graphModel.getParent(object2)) != null && BasicGraphUI.this.graphLayoutCache.isVisible(object3)) {
                    object2 = object3;
                }
                BasicGraphUI.this.selectCellForEvent(object2, mouseEvent);
                BasicGraphUI.this.focus = BasicGraphUI.this.graphLayoutCache.getMapping(object2, false);
            }
        }

        protected boolean isDescendant(CellView cellView, CellView cellView2) {
            Object object;
            if (cellView == null || cellView2 == null) {
                return false;
            }
            Object object2 = cellView.getCell();
            Object object3 = object = cellView2.getCell();
            do {
                if (object3 != object2) continue;
                return true;
            } while ((object3 = BasicGraphUI.this.graphModel.getParent(object3)) != null);
            return false;
        }
    }

    public class KeyHandler
    extends KeyAdapter
    implements Serializable {
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        public void keyPressed(KeyEvent keyEvent) {
            if (BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.hasFocus() && BasicGraphUI.this.graph.isEnabled()) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
                if (BasicGraphUI.this.graph.getConditionForKeyStroke(keyStroke) == 0) {
                    ActionListener actionListener = BasicGraphUI.this.graph.getActionForKeyStroke(keyStroke);
                    this.repeatKeyAction = actionListener instanceof Action ? (Action)actionListener : null;
                } else {
                    this.repeatKeyAction = null;
                    if (keyStroke.getKeyCode() == 27) {
                        if (BasicGraphUI.this.marquee != null) {
                            BasicGraphUI.this.marquee.mouseReleased(null);
                        }
                        if (BasicGraphUI.this.mouseListener != null) {
                            BasicGraphUI.this.mouseListener.mouseReleased(null);
                        }
                        BasicGraphUI.this.updateHandle();
                        BasicGraphUI.this.graph.repaint();
                    }
                }
                if (this.isKeyDown && this.repeatKeyAction != null) {
                    this.repeatKeyAction.actionPerformed(new ActionEvent(BasicGraphUI.this.graph, 1001, ""));
                    keyEvent.consume();
                } else {
                    this.isKeyDown = true;
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.isKeyDown = false;
        }
    }

    public class CellEditorHandler
    implements CellEditorListener,
    Serializable {
        public void editingStopped(ChangeEvent changeEvent) {
            BasicGraphUI.this.completeEditing(false, false, true);
        }

        public void editingCanceled(ChangeEvent changeEvent) {
            BasicGraphUI.this.completeEditing(false, false, false);
        }
    }

    public class GraphSelectionHandler
    implements GraphSelectionListener,
    Serializable {
        public void valueChanged(GraphSelectionEvent graphSelectionEvent) {
            BasicGraphUI.this.updateHandle();
            Object[] objectArray = graphSelectionEvent.getCells();
            if (objectArray != null && objectArray.length <= MAXCLIPCELLS) {
                Rectangle rectangle = BasicGraphUI.this.graph.toScreen(BasicGraphUI.this.graph.getCellBounds(objectArray));
                if (rectangle != null) {
                    int n = BasicGraphUI.this.graph.getHandleSize();
                    rectangle.grow(n, n);
                    BasicGraphUI.this.updateHandle();
                    BasicGraphUI.this.graph.repaint(rectangle);
                }
            } else {
                BasicGraphUI.this.graph.repaint();
            }
        }
    }

    public class GraphViewObserver
    implements Observer,
    Serializable {
        public void update(Observable observable, Object object) {
            BasicGraphUI.this.updateSize();
        }
    }

    public class GraphModelHandler
    implements GraphModelListener,
    Serializable {
        public void graphChanged(GraphModelEvent graphModelEvent) {
            if (BasicGraphUI.this.graphLayoutCache != null) {
                BasicGraphUI.this.graphLayoutCache.graphChanged(graphModelEvent.getChange());
            }
            Object[] objectArray = graphModelEvent.getChange().getInserted();
            Object[] objectArray2 = graphModelEvent.getChange().getRemoved();
            if (objectArray != null && objectArray.length > 0) {
                BasicGraphUI.this.focus = BasicGraphUI.this.graphLayoutCache.getMapping(objectArray[0], false);
            }
            if (objectArray2 != null && objectArray2.length > 0) {
                int n = 0;
                while (n < objectArray2.length && BasicGraphUI.this.focus != null) {
                    if (objectArray2[n] == BasicGraphUI.this.focus.getCell()) {
                        BasicGraphUI.this.focus = null;
                    }
                    ++n;
                }
                BasicGraphUI.this.graph.getSelectionModel().removeSelectionCells(objectArray2);
            }
            BasicGraphUI.this.updateSize();
            if (objectArray != null && objectArray.length > 0 && BasicGraphUI.this.graph.isSelectNewCells()) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n = 0;
                while (n < objectArray.length) {
                    if (BasicGraphUI.this.graphModel.getParent(objectArray[n]) == null && BasicGraphUI.this.graphLayoutCache.isVisible(objectArray[n])) {
                        arrayList.add(objectArray[n]);
                    }
                    ++n;
                }
                BasicGraphUI.this.graph.setSelectionCells(arrayList.toArray());
                BasicGraphUI.this.graph.requestFocus();
            }
        }
    }

    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer;
        protected JScrollBar scrollBar;

        public void componentMoved(ComponentEvent componentEvent) {
            if (this.timer == null) {
                JScrollPane jScrollPane = this.getScrollPane();
                if (jScrollPane == null) {
                    BasicGraphUI.this.updateSize();
                } else {
                    this.scrollBar = jScrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = jScrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            BasicGraphUI.this.updateSize();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        protected JScrollPane getScrollPane() {
            Container container = BasicGraphUI.this.graph.getParent();
            while (container != null && !(container instanceof JScrollPane)) {
                container = container.getParent();
            }
            if (container instanceof JScrollPane) {
                return (JScrollPane)container;
            }
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                BasicGraphUI.this.updateSize();
                this.timer = null;
                this.scrollBar = null;
            }
        }
    }
}

