/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.mutation.common;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.graph.OperatorGraph;
import freak.core.population.Individual;
import freak.module.operator.mutation.common.Exchange;
import freak.module.operator.mutation.common.Jump;
import freak.module.operator.mutation.common.PoissonOperation;

public class JumpExchange
extends PoissonOperation {
    private double exchangeProb;
    private Exchange exchange;
    private Jump jump;

    public JumpExchange(OperatorGraph graph) {
        super(graph);
        this.exchange = new Exchange(graph);
        this.jump = new Jump(graph);
        this.exchangeProb = 0.5;
    }

    protected Individual performSingleMutation(Individual ind) {
        RandomElement re = this.graph.getSchedule().getRandomElement();
        if (re.raw() <= this.exchangeProb) {
            return this.exchange.performSingleMutation(ind);
        }
        return this.jump.performSingleMutation(ind);
    }

    public Double getPropertyExchangeProb() {
        return new Double(this.exchangeProb);
    }

    public void setPropertyExchangeProb(Double prob) {
        this.exchangeProb = prob;
    }

    public String getShortDescriptionForExchangeProb() {
        return "Prob of exchange";
    }

    public String getLongDescriptionForExchangeProb() {
        return "Probability to do an exchange and not a jump.";
    }

    public String getDescription() {
        return "With a probability a single random exchange is done. With 1-probability a single random jump is performed.";
    }

    public String getName() {
        return "Jump & Exchange";
    }
}

