/*
 * Decompiled with CFR 0.152.
 */
package freak.core.control;

import freak.core.control.Actions;
import freak.core.control.FreakFile;
import freak.core.control.GenerationIndex;
import freak.core.control.Replay;
import freak.core.control.RequestRecievedException;
import freak.core.control.Schedule;
import freak.core.control.SimulationException;
import freak.core.control.StateListener;
import java.util.LinkedList;

public class RunControl {
    private StateListener stateListener;
    private LinkedList requestQueue = new LinkedList();
    private Schedule activeSchedule;
    private Replay replay;
    private volatile FreakSimulationThread simulationThread;
    private Actions.Action lastProcessed;
    private boolean programTerminationRequest;
    private GenerationIndex runTarget;
    private GenerationIndex seekTarget;
    private boolean inSeekSequence;
    private double speedLimit = Double.POSITIVE_INFINITY;

    public RunControl(StateListener gui) {
        this.simulationThread = new FreakSimulationThread();
        this.stateListener = gui;
        this.simulationThread.start();
    }

    private void mainLoop() {
        this.waitForRequests();
        Thread thisThread = Thread.currentThread();
        while (this.simulationThread == thisThread) {
            this.processRequests();
            if (this.programTerminationRequest) {
                this.simulationThread = null;
                return;
            }
            this.updateTargetStatus();
            if (this.allTargetsReached()) {
                if (!this.inSeekSequence) {
                    this.sendSimulationCompleted();
                }
                this.waitForRequests();
                continue;
            }
            try {
                this.waitForSpeedLimit();
            }
            catch (RequestRecievedException exc) {
                continue;
            }
            try {
                this.step();
            }
            catch (Exception exc) {
                this.sendErrorMessage(exc);
                this.fallback(exc);
            }
        }
    }

    private void processRequests() {
        Actions.Action request = this.readRequest();
        while (request != null) {
            request.process(this);
            if (this.programTerminationRequest) break;
            this.lastProcessed = request;
            request = this.readRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Actions.Action readRequest() {
        LinkedList linkedList = this.requestQueue;
        synchronized (linkedList) {
            if (!this.requestQueue.isEmpty()) {
                return (Actions.Action)this.requestQueue.removeFirst();
            }
            return null;
        }
    }

    private void updateTargetStatus() {
        if (this.seekTarget != null && this.activeSchedule.getNextStepTimeIndex().isAfter(this.seekTarget)) {
            this.seekTarget = null;
        }
        if (this.runTarget != null && this.activeSchedule.getNextStepTimeIndex().isAfter(this.runTarget)) {
            this.runTarget = null;
        }
    }

    private boolean allTargetsReached() {
        return this.seekTarget == null && (this.runTarget == null || this.inSeekSequence);
    }

    private void sendSimulationCompleted() {
        this.stateListener.simulationCompleted(this.lastProcessed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRequests() {
        if (this.activeSchedule != null) {
            this.activeSchedule.timeController.stopCounting();
        }
        LinkedList linkedList = this.requestQueue;
        synchronized (linkedList) {
            while (this.requestQueue.isEmpty()) {
                try {
                    this.requestQueue.wait();
                }
                catch (InterruptedException exc) {
                    throw new RuntimeException(exc);
                }
            }
        }
        if (this.activeSchedule != null) {
            this.activeSchedule.timeController.startCounting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSpeedLimit() throws RequestRecievedException {
        if (this.seekTarget != null) {
            return;
        }
        LinkedList linkedList = this.requestQueue;
        synchronized (linkedList) {
            if (!this.requestQueue.isEmpty()) {
                throw new RequestRecievedException();
            }
            this.activeSchedule.timeController.setSpeedLimit(this.speedLimit);
            this.activeSchedule.timeController.nextGeneration(this.requestQueue);
            if (!this.requestQueue.isEmpty()) {
                throw new RequestRecievedException();
            }
        }
    }

    private void step() throws SimulationException {
        if (this.activeSchedule.getCurrentTimeIndex().isBefore(this.replay.getLastPoint())) {
            if (this.replay.isEditPoint(this.activeSchedule.getNextStepTimeIndex())) {
                this.activeSchedule = this.replay.getCheckPointFor(this.activeSchedule.getNextStepTimeIndex());
                this.activeSchedule.timeController.startCounting();
                try {
                    this.waitForSpeedLimit();
                }
                catch (RequestRecievedException requestRecievedException) {}
            } else {
                this.activeSchedule.step();
            }
        } else {
            this.activeSchedule.step();
            this.replay.addPoint(this.activeSchedule, false);
        }
        this.sendAsynchroneousFeedback();
    }

    void terminate() {
        this.programTerminationRequest = true;
    }

    private void sendAsynchroneousFeedback() {
        this.stateListener.asynchroneousFeedback(this.activeSchedule, this.replay);
    }

    private void sendErrorMessage(Exception exc) {
        this.stateListener.simulationException(exc);
    }

    private void fallback(Exception reason) {
        this.runTarget = null;
        this.seekTarget = null;
        this.replay = null;
        this.activeSchedule = null;
        this.sendAsynchroneousFeedback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(Actions.Action request) {
        LinkedList linkedList = this.requestQueue;
        synchronized (linkedList) {
            this.requestQueue.add(request);
            this.requestQueue.notify();
        }
    }

    void start() {
        this.runTarget = GenerationIndex.LAST;
        this.seekTarget = null;
    }

    void suspend() {
        this.runTarget = null;
        this.seekTarget = null;
    }

    void setSpeedLimitAsynchroneous(double generationsPerSecond) {
        this.speedLimit = generationsPerSecond;
    }

    void startSeekSequence() {
        this.inSeekSequence = true;
    }

    void endSeekSequence() {
        this.inSeekSequence = false;
    }

    void seek(GenerationIndex seekTarget) {
        this.seekTarget = seekTarget;
        this.loadBestSchedule(seekTarget);
    }

    public void seekToStart() {
        this.seek(GenerationIndex.START);
    }

    public void seekToLastBatch() {
        GenerationIndex from;
        GenerationIndex generationIndex = from = this.seekTarget != null ? this.seekTarget : this.activeSchedule.getCurrentTimeIndex();
        if (from.batch <= 1) {
            this.seek(GenerationIndex.START);
        } else {
            this.seek(new GenerationIndex(from.batch - 1, from.run, from.generation));
        }
    }

    public void seekToNextBatch() {
        GenerationIndex from;
        GenerationIndex generationIndex = from = this.seekTarget != null ? this.seekTarget : this.activeSchedule.getCurrentTimeIndex();
        if (from.batch == 0) {
            this.seek(GenerationIndex.FIRST);
        } else if (from.batch < this.activeSchedule.getBatchList().size()) {
            this.seek(new GenerationIndex(from.batch + 1, from.run, from.generation));
        }
    }

    public void seekToLastRun() {
        GenerationIndex from;
        GenerationIndex generationIndex = from = this.seekTarget != null ? this.seekTarget : this.activeSchedule.getCurrentTimeIndex();
        if (from.run > 1) {
            this.seek(new GenerationIndex(from.batch, from.run - 1, from.generation));
        }
    }

    public void seekToNextRun() {
        GenerationIndex from;
        GenerationIndex generationIndex = from = this.seekTarget != null ? this.seekTarget : this.activeSchedule.getCurrentTimeIndex();
        if (from.batch != 0 && from.run < this.activeSchedule.getBatchList().get(from.batch - 1).getRuns()) {
            this.seek(new GenerationIndex(from.batch, from.run + 1, from.generation));
        }
    }

    public void seekToLastGeneration() {
        GenerationIndex from;
        GenerationIndex generationIndex = from = this.seekTarget != null ? this.seekTarget : this.activeSchedule.getCurrentTimeIndex();
        if (from.generation > 1) {
            this.seek(new GenerationIndex(from.batch, from.run, from.generation - 1));
        }
    }

    public void seekToNextGeneration() {
        GenerationIndex from;
        GenerationIndex generationIndex = from = this.seekTarget != null ? this.seekTarget : this.activeSchedule.getCurrentTimeIndex();
        if (from.batch != 0) {
            this.seek(new GenerationIndex(from.batch, from.run, from.generation + 1));
        }
    }

    public void stepBack() {
        GenerationIndex now = this.activeSchedule.getCurrentTimeIndex();
        if (now.equals(GenerationIndex.START)) {
            return;
        }
        if (now.generation != 1) {
            this.seek(new GenerationIndex(now.batch, now.run, 1));
        } else if (now.run > 1) {
            this.seek(new GenerationIndex(now.batch, now.run - 1, 1));
        } else {
            this.seek(this.replay.getLastPointInBatch(now.batch - 1).runStart());
        }
    }

    void stepForward() {
        GenerationIndex target;
        GenerationIndex now = this.activeSchedule.getCurrentTimeIndex();
        if (this.activeSchedule.isLastRunInBatch()) {
            if (this.activeSchedule.isLastBatch()) {
                this.seek(now.nextBatchStart());
                return;
            }
            target = now.nextBatchStart();
        } else {
            target = now.nextRunStart();
        }
        if (this.replay.containsPoint(target)) {
            this.seek(target);
        } else {
            this.activeSchedule.skip();
            this.replay.removeAllSince(this.activeSchedule.getCurrentTimeIndex());
            this.replay.addPoint(this.activeSchedule, true);
            this.seekTarget = target;
            this.sendAsynchroneousFeedback();
        }
    }

    public void seekToReplayEnd() {
        this.seek(this.replay.getLastPoint());
    }

    private void loadBestSchedule(GenerationIndex seekTarget) {
        Schedule stored = this.replay.getCheckPointFor(seekTarget);
        boolean currentAfterTarget = this.activeSchedule.getCurrentTimeIndex().isAfter(seekTarget);
        boolean currentBeforeStored = this.activeSchedule.getCurrentTimeIndex().isBefore(stored.getCurrentTimeIndex());
        if (currentBeforeStored || currentAfterTarget) {
            this.activeSchedule = stored;
            this.sendAsynchroneousFeedback();
        }
    }

    public void setNewSchedule(Schedule newSchedule) {
        this.activeSchedule = newSchedule;
        this.replay = new Replay();
        this.replay.addPoint(this.activeSchedule, true);
        this.sendSynchroneousFeedback();
    }

    public void fromFile(FreakFile file) {
        this.replay = file.replay;
        this.activeSchedule = file.activeSchedule;
        this.sendSynchroneousFeedback();
    }

    public void scheduleEdited(Schedule editedSchedule) {
        this.activeSchedule = editedSchedule;
        this.replay.removeAllSince(this.activeSchedule.getCurrentTimeIndex());
        this.replay.addPoint(this.activeSchedule, true);
        this.sendSynchroneousFeedback();
    }

    public void setSpeedLimit(double speedLimit) {
        this.speedLimit = speedLimit;
        this.sendSynchroneousFeedback();
    }

    public Schedule getSchedule() {
        return this.activeSchedule;
    }

    public FreakFile toFile() {
        return new FreakFile(this.replay, this.activeSchedule);
    }

    private void sendSynchroneousFeedback() {
        this.stateListener.synchroneousFeedback(this.activeSchedule, this.replay);
    }

    private class FreakSimulationThread
    extends Thread {
        public FreakSimulationThread() {
            super("FreakSimulationThread");
            this.setPriority(1);
        }

        public void run() {
            RunControl.this.mainLoop();
            RunControl.this.stateListener.terminated(RunControl.this.lastProcessed);
        }
    }
}

