/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.generalstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;

public class IsingModelTorus
extends AbstractStaticSingleObjectiveFitnessFunction
implements Configurable {
    private int torusHeight = 1;
    private int torusWidth = ((GeneralString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
    private boolean diagonalEdges = false;

    public IsingModelTorus(Schedule schedule) {
        super(schedule);
    }

    public void initialize() {
        super.initialize();
        if (this.torusHeight * this.torusWidth != ((GeneralString)this.getSchedule().getPhenotypeSearchSpace()).getDimension()) {
            this.torusHeight = 1;
            this.torusWidth = ((GeneralString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        }
    }

    protected double evaluate(Genotype genotype) {
        double fitness = 0.0;
        int[] gen = ((GeneralStringGenotype)genotype).getIntArray();
        int y = 0;
        while (y < this.torusHeight) {
            int x = 0;
            while (x < this.torusWidth) {
                if ((this.torusWidth > 2 || x < this.torusWidth - 1) && this.torusValue(gen, x, y) == this.torusValue(gen, (x + 1) % this.torusWidth, y)) {
                    fitness += 1.0;
                }
                if ((this.torusHeight > 2 || y < this.torusHeight - 1) && this.torusValue(gen, x, y) == this.torusValue(gen, x, (y + 1) % this.torusHeight)) {
                    fitness += 1.0;
                }
                if (!(!this.diagonalEdges || this.torusWidth <= 2 && x >= this.torusWidth - 1 || this.torusHeight <= 2 && y >= this.torusHeight - 1)) {
                    if (this.torusValue(gen, x, y) == this.torusValue(gen, (x + 1) % this.torusWidth, (y + 1) % this.torusHeight)) {
                        fitness += 1.0;
                    }
                    if (this.torusHeight > 2 && this.torusValue(gen, x, y) == this.torusValue(gen, (x + (this.torusWidth - 1)) % this.torusWidth, (y + 1) % this.torusHeight)) {
                        fitness += 1.0;
                    }
                }
                ++x;
            }
            ++y;
        }
        return fitness;
    }

    private int torusValue(int[] torusData, int x, int y) {
        return torusData[y * this.torusWidth + x];
    }

    public synchronized int torusValue(Individual individual, int x, int y) {
        return this.torusValue(((GeneralStringGenotype)individual.getPhenotype()).getIntArray(), x, y);
    }

    public String getName() {
        return "Ising Model (Torus)";
    }

    public String getDescription() {
        return "The Ising Model is a model derived from statistical mechanics describing the behavior of atoms with two spins where neighbored atoms tend to orient in the same direction as their neighbors.\nAnother view is an inversion of the colorability problem: an edge contributes a value of 1 to the fitness if and only if its nodes have got the same color. So, all colorings with only one color are optimal.\nHere, the graph is described by a two-dimensional torus, a rectangular grid of nodes with edges between nodes that are horizontally of vertically neighbored in the grid. The leftmost and rightmost node in one row and the upper and lower nodes in one column are neighbored as well. Note that a torus with one row is a ring.";
    }

    public Integer getPropertyTorusHeight() {
        return new Integer(this.torusHeight);
    }

    public Integer getPropertyTorusWidth() {
        return new Integer(this.torusWidth);
    }

    public void setPropertyTorusHeight(Integer height) {
        if (height < 1) {
            return;
        }
        int dim = ((GeneralString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        if (height * (dim / height) == dim) {
            this.torusHeight = height;
            this.torusWidth = dim / height;
        }
    }

    public void setPropertyTorusWidth(Integer width) {
        if (width < 1) {
            return;
        }
        int dim = ((GeneralString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        if (width * (dim / width) == dim) {
            this.torusWidth = width;
            this.torusHeight = dim / width;
        }
    }

    public String getShortDescriptionForTorusWidth() {
        return "Torus Width";
    }

    public String getShortDescriptionForTorusHeight() {
        return "Torus Height";
    }

    public String getLongDescriptionForTorusWidth() {
        return "Sets the number of columns for the torus. The torus width has to be a divisor of the search space's dimension.";
    }

    public String getLongDescriptionForTorusHeight() {
        return "Sets the number of rows for the torus. The torus height has to be a divisor of the search space's dimension.";
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        double result = this.torusWidth * this.torusHeight * 2;
        if (this.torusWidth <= 2) {
            result -= (double)this.torusHeight;
        }
        if (this.torusHeight <= 2) {
            result -= (double)this.torusWidth;
        }
        if (this.diagonalEdges) {
            result += (double)(this.torusWidth * this.torusHeight * 2);
            if (this.torusWidth <= 2) {
                result -= (double)(this.torusHeight * 2);
            }
            if (this.torusHeight == 1) {
                result -= (double)(this.torusWidth * 2);
            }
            if (this.torusHeight == 2) {
                result -= (double)this.torusWidth;
            }
        }
        return result;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    public Boolean getPropertyDiagonalEdges() {
        return new Boolean(this.diagonalEdges);
    }

    public void setPropertyDiagonalEdges(Boolean b) {
        this.diagonalEdges = b;
    }

    public String getShortDescriptionForDiagonalEdges() {
        return "Diagonal Edges";
    }

    public String getLongDescriptionForDiagonalEdges() {
        return "If checked, the torus contains additional edges between diagonally neighbored fields.";
    }
}

