% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webproperties.R
\name{list_webproperties}
\alias{list_webproperties}
\title{Web Properties}
\usage{
list_webproperties(accountId = "~all", start.index = NULL,
  max.results = NULL, token)
}
\arguments{
\item{accountId}{character. Account ID to retrieve web properties for. Can either be a specific account ID or '~all', which refers to all the accounts that user has access to.}

\item{start.index}{integer. An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of web properties to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
The Webproperties collection is a set of Webproperty resources, each of which describes a web property available to an authenticated user.
\item{id}{Web property ID of the form UA-XXXXX-YY.}
\item{kind}{Resource type for Analytics WebProperty.}
\item{accountId}{Account ID to which this web property belongs.}
\item{internalWebPropertyId}{Internal ID for this web property.}
\item{name}{Name of this web property.}
\item{websiteUrl}{Website url for this web property.}
\item{level}{Level for this web property.}
\item{profileCount}{View (Profile) count for this web property.}
\item{industryVertical}{The industry vertical/category selected for this web property.  If this field is set, the correct values are:   UNSPECIFIED   ARTS_AND_ENTERTAINMENT   AUTOMOTIVE   BEAUTY_AND_FITNESS   BOOKS_AND_LITERATURE   BUSINESS_AND_INDUSTRIAL_MARKETS   COMPUTERS_AND_ELECTRONICS   FINANCE   FOOD_AND_DRINK   GAMES   HEALTHCARE   HOBBIES_AND_LEISURE   HOME_AND_GARDEN   INTERNET_AND_TELECOM   JOBS_AND_EDUCATION   LAW_AND_GOVERNMENT   NEWS   ONLINE_COMMUNITIES   OTHER   PEOPLE_AND_SOCIETY   PETS_AND_ANIMALS   REAL_ESTATE   REFERENCE   SCIENCE   SHOPPING   SPORTS   TRAVEL}
\item{defaultProfileId}{Default view (profile) ID.}
\item{permissions}{Permissions the user has for this web property.}
\item{created}{Time this web property was created.}
\item{updated}{Time this web property was last modified.}
\item{permissions}{All the permissions that the user has for this web property. These include any implied permissions (e.g., EDIT implies VIEW) or inherited permissions from the parent account.}
}
\description{
Lists properties to which the user has access.
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/webproperties}{Management API - Web Properties Overview}
}
\seealso{
Other Management API: \code{\link{get_custom_dimension}},
  \code{\link{get_custom_metric}},
  \code{\link{get_experiment}}, \code{\link{get_filter}},
  \code{\link{get_goal}}, \code{\link{get_profile}},
  \code{\link{get_unsampled_report}},
  \code{\link{get_upload}}, \code{\link{get_webproperty}},
  \code{\link{list_accounts}},
  \code{\link{list_custom_data_sources}},
  \code{\link{list_custom_dimensions}},
  \code{\link{list_custom_metrics}},
  \code{\link{list_experiments}},
  \code{\link{list_filters}}, \code{\link{list_goals}},
  \code{\link{list_profiles}}, \code{\link{list_segments}},
  \code{\link{list_unsampled_reports}},
  \code{\link{list_uploads}}
}

