% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs_steps.R
\name{.gibbsStepDT}
\alias{.gibbsStepDT}
\title{Draws from the posterior of the parameters of the damped trend equation, conditional on
the states.}
\usage{
.gibbsStepDT(Y, par, distr, varName)
}
\arguments{
\item{Y}{A \code{Tn x 1} vector.}

\item{par}{A \code{3 x 1} vector with parameters.}

\item{distr}{A \code{4 x 3} matrix with prior parameters and box constraints.}

\item{varName}{A code{3 x 1} vector with parameter names in the correct order, i.e.,
mean reversion, autoregressive parameter, variance.}
}
\description{
Draws from the posterior of the parameters of the damped trend equation, conditional on
the states.
}
\details{
The three parameters are drawn sequentially in a Gibbs procedure. (conditional
  on the two other parameters).

The parameter \eqn{\omega} is drawn from a normal posterior which is obtained
  by conjugancy.

The autoregressive parameter \eqn{\phi} is drawn via a Metropolis-Hastings step.

The innovation variance is drwan from the Inverse-Gamma distribution which
  obtained by conjugacy.
}
\keyword{internal}
