% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.stability.R
\name{print.stability}
\alias{print.stability}
\title{Print a rgcca_stability object.}
\usage{
\method{print}{stability}(x, ...)
}
\arguments{
\item{x}{Object of type "stability" produced by rgcca_stability.}

\item{...}{Arguments for the print.rgcca function.}
}
\value{
none
}
\description{
The fitted RGCCA model returned by rgcca_stability is printed
All arguments are forwarded to the print.rgcca function.
}
\examples{
data(Russett)
blocks <- list(
  agriculture = Russett[, seq(3)],
  industry = Russett[, 4:5],
  politic = Russett[, 6:11]
)
fit.sgcca <- rgcca(blocks, sparsity = c(.8, .9, .6))
res <- rgcca_stability(fit.sgcca, n_boot = 10, verbose = FALSE)
print(res)
}
