% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/senGetPathRow.R
\name{senGetOrbit}
\alias{senGetOrbit}
\title{Return the relative orbit of the Sentinel-2 satellite}
\usage{
senGetOrbit(str)
}
\arguments{
\item{str}{the full path or official image name of the Sentinel image from
which the relative orbit is extracted.}
}
\value{
an string with the relative orbit of the image in "\code{NXXXX_RYYY}"
or "\code{RYYY}" format, depending on the version of name convention.
}
\description{
\code{senGetOrbit} reads the official name of a Sentinel image and returns 
relative orbit. Get relative orbit information 
\href{https://sentinel.esa.int/web/sentinel/missions/sentinel-2/satellite-description/orbit}{here}.
}
\examples{
#example of getting date from Sentinel2 image name
str <- c("S2A_MSIL1C_20170102T111442_N0204_R137_T30TWN_20170102T111441.SAFE",
         "S2A_OPER_PRD_MSIL1C_PDMC_20160308T090616_R094_V20160305T110109_20160305T110109")
pr <- senGetOrbit(str)
print(pr)

}
