% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genCompositions.R
\name{genCompositions}
\alias{genCompositions}
\title{Create image compositions from a time series of satellite images}
\usage{
genCompositions(rstack, by, fun, n, by.days = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{rstack}{a \code{RasterStack}, where layer names contain the capturing
date of an image in "\code{YYYYJJJ}" format.}

\item{by}{character argument. Accepts \code{"month"} or \code{"year"} for creating monthly
or yearly composites. Only required if \code{n} is provided.}

\item{fun}{the function used to create the composite, such as \code{max},
\code{min}, \code{mean}, ...}

\item{n}{number of images combined in the aggregation. Only required if 
\code{by} is not provided.}

\item{by.days}{logical argument. If \code{FALSE}, \code{n} indicates the 
number of consucutive images being aggregated. If \code{TRUE}, the function
aggregates the imagery within every \code{n} days. The aggregation requires
at least one image avaiable.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints
the running steps and warnings.}

\item{...}{arguments for nested functions:
\itemize{
  \item \code{AppRoot} the path where the images will be saved in the
  GTiff format.
}}
}
\value{
a \code{RasterStack} with the time series of the composite images.
}
\description{
\code{genCompositions} combines a series of satellite images to create compositions.
}
\details{
The layer of the composite image takes its name from the first image used in
the composition.

\code{genCompositions} reduces the number of images but improves the total
quality of the time-series by removing cloulds and outliers. One widespread
compositing technique is the maximum value composition (MVC). This technique
allocates in each pixel of the composite the maximum value (fun = max) that
the pixel reaches during a time period (\code{n}, \code{by.days = TRUE}).
}
\examples{
# loading NDVI images of Navarre
data("ex.ndvi.navarre")
# Ploting the images: clouds are found
genPlotGIS(ex.ndvi.navarre)
# the first composite image is made with images 1, 2 and 3, 
# and the second composite image is made with images 4, 5 and 6
composite.NDVI.a <- genCompositions(rstack = ex.ndvi.navarre,
                                    n = 3,
                                    fun = max)
genPlotGIS(composite.NDVI.a)
# when by.days=TRUE, the first composite image is made with images 1, 2 and 3, 
# the second with image 4, and the third with images 5 and 6.
composite.NDVI.3a <- genCompositions(rstack = ex.ndvi.navarre,
                                     n = 3,
                                     by.days = TRUE,
                                     fun = max)
# Check that the clouds were removed
genPlotGIS(composite.NDVI.3a)
}
