% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genSmoothingIMA.R
\name{genSmoothingIMA}
\alias{genSmoothingIMA}
\title{Fill data gaps and smooth outliers in a time series of satellite images}
\usage{
genSmoothingIMA(
  rStack,
  Img2Fill = NULL,
  nDays = 3,
  nYears = 1,
  fact = 5,
  fun = mean,
  r.dates,
  aFilter = c(0.05, 0.95),
  only.na = FALSE,
  factSE = 8,
  predictSE = FALSE,
  snow.mode = FALSE,
  out.name = "outname",
  ...
)
}
\arguments{
\item{rStack}{a \code{RasterStack} class argument containing a time series of
satellite images. Layer names should contain the date of the image in
"\code{YYYYJJJ}" format.}

\item{Img2Fill}{a \code{vector} argument defining the images to be 
filled/smoothed.}

\item{nDays}{a \code{numeric} argument with the number of previous and 
subsequent days that define the temporal neighborhood.}

\item{nYears}{a \code{numeric} argument with the number of previous and 
subsequent years that define the temporal neighborhood.}

\item{fact}{a \code{numeric} argument with an aggregation factor of the 
anomalies before the interpolation.}

\item{fun}{a \code{function} used to aggregate the image of anomalies. Both
\code{mean} (default) or \code{median} are acceptted.}

\item{r.dates}{a \code{vector} argument containing the dates of the layers in rstack}

\item{aFilter}{a \code{vector} with the lower and upper quantiles that define
the outliers of the anomalies. Ex. c(0.05,0.95).}

\item{only.na}{logical argument. If \code{TRUE} only fills the \code{NA} values. 
\code{FALSE}  by default.}

\item{factSE}{the \code{fact} used in the standard error prediction.}

\item{predictSE}{calculate the standard error instead the prediction.}

\item{snow.mode}{logical argument. If \code{TRUE}, the filling process will
be parallelized using the `\code{raster}' package.}

\item{out.name}{the name of the folder containing the smoothed/filled images
when saved in the Hard Disk Device (HDD).}

\item{...}{arguments for nested functions:
\itemize{
  \item \code{AppRoot} the path where the filled/smoothed time series of
  images will be saved in GTiff format.
}}
}
\value{
a \code{RasterStack} with the filled/smoothed images.
}
\description{
\code{genSmoothingIMA} is the implementation of a spatio temporal method 
called image mean anomaly (IMA) for gap filling and smoothing satellite
data \insertCite{militino2019interpolation}{RGISTools}.
}
\details{
This filling/smoothing method was developed by 
\insertCite{militino2019interpolation;textual}{RGISTools}. This technique decomposes
a time series of images into a new series of mean and anomaly images. The
procedure applies the smoothing algorithm over the anomaly images. The 
procedure requires a proper definition of a temporal neighbourhood for the
target image and aggregation factor.
}
\examples{
\dontrun{
# load an example of NDVI time series in Navarre
data(ex.ndvi.navarre)
# the 2 images to be filled and the neighbourhood
genPlotGIS(ex.ndvi.navarre)

# filled images
tiles.mod.ndvi.filled  <- genSmoothingIMA(ex.ndvi.navarre,
                               Img2Fill = c(1),
                               only.na=TRUE)
# show the filled images
genPlotGIS(tiles.mod.ndvi.filled)
# plot comparison of the cloud and the filled images
tiles.mod.ndvi.comp <- stack(ex.ndvi.navarre[[1]], tiles.mod.ndvi.filled[[1]],
                             ex.ndvi.navarre[[2]], tiles.mod.ndvi.filled[[2]])
genPlotGIS(tiles.mod.ndvi.comp, layout=c(2, 2))
}
}
\references{
\insertRef{militino2019interpolation}{RGISTools}
}
