% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic.R
\name{rgs_for_logistic}
\alias{rgs_for_logistic}
\title{Main function for logistic regression analysis}
\usage{
rgs_for_logistic(my_data, u_variables, covariates)
}
\arguments{
\item{my_data}{A dataframe containing the data.}

\item{u_variables}{A character vector specifying the names of the U-shaped variables.}

\item{covariates}{A character vector specifying the names of the covariates.}
}
\value{
A dataframe containing the best combination of cutoffs and associated AIC value.
}
\description{
This function performs logistic regression analysis to identify optimal cutoffs and evaluate the model.
Users are required to create and set the datadist option globally before using this function.
}
\examples{
\donttest{
library(rms)

data_path <- system.file("extdata", "logistic_data.csv", package = "RGS")
my_data <- read.csv(data_path)

# Define variables
u_variables <- c("u1", "u2")
covariates <- c("l1", "c1")

# create and set the datadist option globally
dd <- datadist(my_data)
options(datadist = "dd")

rgs_for_logistic(my_data, u_variables, covariates)
}

}
