/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

public class GenerationStamp
implements WritableComparable<GenerationStamp> {
    public static final long WILDCARD_STAMP = 1L;
    public static final long FIRST_VALID_STAMP = 1000L;
    long genstamp;

    public GenerationStamp() {
        this(1000L);
    }

    GenerationStamp(long stamp) {
        this.genstamp = stamp;
    }

    public long getStamp() {
        return this.genstamp;
    }

    public void setStamp(long stamp) {
        this.genstamp = stamp;
    }

    public synchronized long nextStamp() {
        ++this.genstamp;
        return this.genstamp;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.genstamp);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.genstamp = in.readLong();
        if (this.genstamp < 0L) {
            throw new IOException("Bad Generation Stamp: " + this.genstamp);
        }
    }

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    @Override
    public int compareTo(GenerationStamp that) {
        return GenerationStamp.compare(this.genstamp, that.genstamp);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GenerationStamp)) {
            return false;
        }
        return this.genstamp == ((GenerationStamp)o).genstamp;
    }

    public static boolean equalsWithWildcard(long x, long y) {
        return x == y || x == 1L || y == 1L;
    }

    public int hashCode() {
        return 629 + (int)(this.genstamp ^ this.genstamp >>> 32);
    }

    static {
        WritableFactories.setFactory(GenerationStamp.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new GenerationStamp(0L);
            }
        });
    }
}

