/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.StringUtils;

class QueueManager {
    private static final Log LOG = LogFactory.getLog(QueueManager.class);
    private static final String QUEUE_CONF_PROPERTY_NAME_PREFIX = "mapred.queue.";
    private Set<String> queueNames = new TreeSet<String>();
    private HashMap<String, AccessControlList> aclsMap = new HashMap();
    private HashMap<String, Object> schedulerInfoObjects = new HashMap();
    private boolean aclsEnabled;
    static final String QUEUE_ACLS_FILE_NAME = "mapred-queue-acls.xml";

    public QueueManager(Configuration conf) {
        this.initialize(conf);
    }

    public synchronized Set<String> getQueues() {
        return this.queueNames;
    }

    public synchronized boolean hasAccess(String queueName, QueueACL qACL, UserGroupInformation ugi) {
        AccessControlList acl;
        if (!this.aclsEnabled) {
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("checking access for : " + QueueManager.toFullPropertyName(queueName, qACL.getAclName())));
        }
        if ((acl = this.aclsMap.get(QueueManager.toFullPropertyName(queueName, qACL.getAclName()))) == null) {
            return false;
        }
        return acl.isUserAllowed(ugi);
    }

    public synchronized void setSchedulerInfo(String queueName, Object queueInfo) {
        this.schedulerInfoObjects.put(queueName, queueInfo);
    }

    public synchronized Object getSchedulerInfo(String queueName) {
        return this.schedulerInfoObjects.get(queueName);
    }

    synchronized void refreshAcls(Configuration conf) throws IOException {
        try {
            HashMap<String, AccessControlList> newAclsMap = this.getQueueAcls(conf);
            this.aclsMap = newAclsMap;
        }
        catch (Throwable t) {
            String exceptionString = StringUtils.stringifyException(t);
            LOG.warn((Object)("Queue ACLs could not be refreshed because there was an exception in parsing the configuration: " + exceptionString + ". Existing ACLs are retained."));
            throw new IOException(exceptionString);
        }
    }

    private void checkDeprecation(Configuration conf) {
        for (String queue : this.queueNames) {
            for (QueueACL qACL : QueueACL.values()) {
                String key = QueueManager.toFullPropertyName(queue, qACL.getAclName());
                String aclString = conf.get(key);
                if (aclString == null) continue;
                LOG.warn((Object)"Configuring queue ACLs in mapred-site.xml or hadoop-site.xml is deprecated. Configure queue ACLs in mapred-queue-acls.xml");
                return;
            }
        }
    }

    private HashMap<String, AccessControlList> getQueueAcls(Configuration conf) {
        this.checkDeprecation(conf);
        conf.addResource(QUEUE_ACLS_FILE_NAME);
        HashMap<String, AccessControlList> aclsMap = new HashMap<String, AccessControlList>();
        for (String queue : this.queueNames) {
            for (QueueACL qACL : QueueACL.values()) {
                String key = QueueManager.toFullPropertyName(queue, qACL.getAclName());
                String aclString = conf.get(key, " ");
                aclsMap.put(key, new AccessControlList(aclString));
            }
        }
        return aclsMap;
    }

    private void initialize(Configuration conf) {
        this.aclsEnabled = conf.getBoolean("mapred.acls.enabled", false);
        String[] queues = conf.getStrings("mapred.queue.names", "default");
        QueueManager.addToSet(this.queueNames, queues);
        this.aclsMap = this.getQueueAcls(conf);
    }

    static final String toFullPropertyName(String queue, String property) {
        return QUEUE_CONF_PROPERTY_NAME_PREFIX + queue + "." + property;
    }

    private static final void addToSet(Set<String> set, String[] elems) {
        for (String elem : elems) {
            set.add(elem);
        }
    }

    synchronized JobQueueInfo[] getJobQueueInfos() {
        ArrayList<JobQueueInfo> queueInfoList = new ArrayList<JobQueueInfo>();
        for (String queue : this.queueNames) {
            Object schedulerInfo = this.schedulerInfoObjects.get(queue);
            if (schedulerInfo != null) {
                queueInfoList.add(new JobQueueInfo(queue, schedulerInfo.toString()));
                continue;
            }
            queueInfoList.add(new JobQueueInfo(queue, null));
        }
        return queueInfoList.toArray(new JobQueueInfo[queueInfoList.size()]);
    }

    JobQueueInfo getJobQueueInfo(String queue) {
        Object schedulingInfo = this.schedulerInfoObjects.get(queue);
        if (schedulingInfo != null) {
            return new JobQueueInfo(queue, schedulingInfo.toString());
        }
        return new JobQueueInfo(queue, null);
    }

    synchronized QueueAclsInfo[] getQueueAcls(UserGroupInformation ugi) throws IOException {
        ArrayList<QueueAclsInfo> queueAclsInfolist = new ArrayList<QueueAclsInfo>();
        QueueACL[] acls = QueueACL.values();
        for (String queueName : this.queueNames) {
            QueueAclsInfo queueAclsInfo = null;
            ArrayList<String> operationsAllowed = null;
            for (QueueACL qACL : acls) {
                if (!this.hasAccess(queueName, qACL, ugi)) continue;
                if (operationsAllowed == null) {
                    operationsAllowed = new ArrayList<String>();
                }
                operationsAllowed.add(qACL.getAclName());
            }
            if (operationsAllowed == null) continue;
            queueAclsInfo = new QueueAclsInfo(queueName, operationsAllowed.toArray(new String[operationsAllowed.size()]));
            queueAclsInfolist.add(queueAclsInfo);
        }
        return queueAclsInfolist.toArray(new QueueAclsInfo[queueAclsInfolist.size()]);
    }

    synchronized AccessControlList getQueueACL(String queueName, QueueACL qACL) {
        if (this.aclsEnabled) {
            return this.aclsMap.get(QueueManager.toFullPropertyName(queueName, qACL.getAclName()));
        }
        return new AccessControlList("*");
    }

    static void dumpConfiguration(Writer writer) throws IOException {
        Configuration conf = new Configuration(false);
        conf.addResource(QUEUE_ACLS_FILE_NAME);
        Configuration.dumpConfiguration(conf, writer);
    }

    static enum QueueACL {
        SUBMIT_JOB("acl-submit-job"),
        ADMINISTER_JOBS("acl-administer-jobs");

        private final String aclName;

        private QueueACL(String aclName) {
            this.aclName = aclName;
        }

        final String getAclName() {
            return this.aclName;
        }
    }
}

