/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.macro.MacroConstants;

class Variable
implements MacroConstants,
Cloneable {
    static final int VALUE = 0;
    static final int ARRAY = 1;
    static final int STRING = 2;
    int symTabIndex;
    private double value;
    private String str;
    private Variable[] array;

    Variable() {
    }

    Variable(double value) {
        this.value = value;
    }

    Variable(int symTabIndex, double value, String str) {
        this.symTabIndex = symTabIndex;
        this.value = value;
        this.str = str;
    }

    Variable(int symTabIndex, double value, String str, Variable[] array) {
        this.symTabIndex = symTabIndex;
        this.value = value;
        this.str = str;
        this.array = array;
    }

    Variable(byte[] array) {
        this.array = new Variable[array.length];
        for (int i = 0; i < array.length; ++i) {
            this.array[i] = new Variable(array[i] & 0xFF);
        }
    }

    Variable(int[] array) {
        this.array = new Variable[array.length];
        for (int i = 0; i < array.length; ++i) {
            this.array[i] = new Variable(array[i]);
        }
    }

    Variable(double[] array) {
        this.array = new Variable[array.length];
        for (int i = 0; i < array.length; ++i) {
            this.array[i] = new Variable(array[i]);
        }
    }

    double getValue() {
        if (this.str != null) {
            return this.convertToDouble();
        }
        return this.value;
    }

    double convertToDouble() {
        try {
            Double d = new Double(this.str);
            return d;
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    void setValue(double value) {
        this.value = value;
        this.str = null;
        this.array = null;
    }

    String getString() {
        return this.str;
    }

    void setString(String str) {
        this.str = str;
        this.value = 0.0;
        this.array = null;
    }

    Variable[] getArray() {
        return this.array;
    }

    void setArray(Variable[] array) {
        this.array = array;
        this.value = 0.0;
        this.str = null;
    }

    int getType() {
        if (this.array != null) {
            return 1;
        }
        if (this.str != null) {
            return 2;
        }
        return 0;
    }

    public String toString() {
        String s = "";
        if (this.array != null) {
            s = s + "array[" + this.array.length + "]";
        } else if (this.str != null) {
            s = this.str;
            if (s.length() > 80) {
                s = s.substring(0, 80) + "...";
            }
            s = s.replaceAll("\n", " | ");
            s = "\"" + s + "\"";
        } else {
            s = this.value == (double)((int)this.value) ? s + (int)this.value : s + IJ.d2s(this.value, 4);
        }
        return s;
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

