/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;

public class ScreenGrabber
implements PlugIn {
    public void run(String arg) {
        ImagePlus imp = null;
        imp = arg.equals("image") ? this.captureImage() : this.captureScreen();
        if (imp != null) {
            imp.show();
        }
    }

    public ImagePlus captureScreen() {
        ImagePlus imp = null;
        try {
            Robot robot = new Robot();
            Dimension dimension = IJ.getScreenSize();
            Rectangle r = new Rectangle(dimension);
            BufferedImage img = robot.createScreenCapture(r);
            if (img != null) {
                imp = new ImagePlus("Screen", img);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imp;
    }

    public ImagePlus captureImage() {
        ImagePlus imp = IJ.getImage();
        if (imp == null) {
            IJ.noImage();
            return null;
        }
        ImagePlus imp2 = null;
        try {
            ImageWindow win = imp.getWindow();
            if (win == null) {
                return null;
            }
            win.toFront();
            IJ.wait(500);
            Point loc = win.getLocation();
            ImageCanvas ic = win.getCanvas();
            Rectangle bounds = ic.getBounds();
            loc.x += bounds.x;
            loc.y += bounds.y;
            Rectangle r = new Rectangle(loc.x, loc.y, bounds.width, bounds.height);
            Robot robot = new Robot();
            BufferedImage img = robot.createScreenCapture(r);
            if (img != null) {
                imp2 = new ImagePlus("Grab of " + imp.getTitle(), img);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imp2;
    }
}

