/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.Line;
import ij.gui.NewImage;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Slicer
implements PlugIn,
TextListener,
ItemListener {
    private static final String[] starts = new String[]{"Top", "Left", "Bottom", "Right"};
    private static String startAt = starts[0];
    private static boolean rotate;
    private static boolean flip;
    private static boolean nointerpolate;
    private double inputZSpacing = 1.0;
    private double outputZSpacing = 1.0;
    private int outputSlices = 1;
    private boolean noRoi;
    private boolean rgb;
    private boolean notFloat;
    private Vector fields;
    private Vector checkboxes;
    private Label message;
    private ImagePlus imp;
    private double gx1;
    private double gy1;
    private double gx2;
    private double gy2;
    private double gLength;
    private int n;
    private double[] x;
    private double[] y;
    private int xbase;
    private int ybase;
    private double length;
    private double[] segmentLengths;
    private double[] dx;
    private double[] dy;

    public void run(String string) {
        int n;
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        int n2 = this.imp.getStackSize();
        Roi roi = this.imp.getRoi();
        int n3 = n = roi != null ? roi.getType() : 0;
        if (n2 < 2 && roi != null && n != 0) {
            IJ.error("Reslice...", "Stack required");
            return;
        }
        if (roi != null && n != 0 && n != 5 && n != 6 && n != 7) {
            IJ.error("Reslice...", "Line or rectangular selection required");
            return;
        }
        if (!this.showDialog(this.imp)) {
            return;
        }
        long l = System.currentTimeMillis();
        ImagePlus imagePlus = null;
        this.rgb = this.imp.getType() == 4;
        this.notFloat = !this.rgb && this.imp.getType() != 2;
        imagePlus = this.imp.isHyperStack() ? this.resliceHyperstack(this.imp) : this.reslice(this.imp);
        if (imagePlus == null) {
            return;
        }
        ImageProcessor imageProcessor = this.imp.getProcessor();
        double d = imageProcessor.getMin();
        double d2 = imageProcessor.getMax();
        if (!this.rgb) {
            imagePlus.getProcessor().setMinAndMax(d, d2);
        }
        imagePlus.show();
        if (this.noRoi) {
            this.imp.killRoi();
        } else {
            this.imp.draw();
        }
        IJ.showStatus(IJ.d2s((double)(System.currentTimeMillis() - l) / 1000.0, 2) + " seconds");
    }

    public ImagePlus reslice(ImagePlus imagePlus) {
        Cloneable cloneable;
        ImagePlus imagePlus2;
        Roi roi = imagePlus.getRoi();
        int n = roi != null ? roi.getType() : 0;
        Calibration calibration = imagePlus.getCalibration();
        if (nointerpolate) {
            Calibration calibration2 = calibration.copy();
            calibration2.pixelWidth = 1.0;
            calibration2.pixelHeight = 1.0;
            calibration2.pixelDepth = 1.0;
            imagePlus.setCalibration(calibration2);
            this.outputZSpacing = 1.0;
            this.inputZSpacing = 1.0;
        }
        double d = this.inputZSpacing / imagePlus.getCalibration().pixelWidth;
        if (roi == null || n == 0 || n == 5) {
            imagePlus2 = this.resliceRectOrLine(imagePlus);
        } else {
            String string = imagePlus.getStack().isVirtual() ? "" : null;
            IJ.showStatus("Reslice...");
            ImageProcessor imageProcessor = this.getSlice(imagePlus, 0.0, 0.0, 0.0, 0.0, string);
            imagePlus2 = new ImagePlus("Reslice of " + imagePlus.getShortTitle(), imageProcessor);
        }
        if (nointerpolate) {
            imagePlus.setCalibration(calibration);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (roi == null || n == 0) {
            if (startAt.equals(starts[0]) || startAt.equals(starts[2])) {
                bl = true;
            } else {
                bl2 = true;
            }
        }
        if (roi != null && n == 5) {
            cloneable = (Line)roi;
            bl = ((Line)cloneable).y2 - ((Line)cloneable).y1 == 0;
            boolean bl3 = bl2 = ((Line)cloneable).x2 - ((Line)cloneable).x1 == 0;
        }
        if (imagePlus2 == null) {
            return null;
        }
        imagePlus2.setCalibration(imagePlus.getCalibration());
        cloneable = imagePlus2.getCalibration();
        if (bl) {
            ((Calibration)cloneable).pixelWidth = calibration.pixelWidth;
            ((Calibration)cloneable).pixelHeight = calibration.pixelDepth / d;
            ((Calibration)cloneable).pixelDepth = calibration.pixelHeight * this.outputZSpacing;
        } else if (bl2) {
            ((Calibration)cloneable).pixelWidth = calibration.pixelHeight;
            ((Calibration)cloneable).pixelHeight = calibration.pixelDepth / d;
            ((Calibration)cloneable).pixelDepth = calibration.pixelWidth * this.outputZSpacing;
        } else if (calibration.pixelHeight == calibration.pixelWidth) {
            ((Calibration)cloneable).pixelWidth = ((Calibration)cloneable).pixelHeight = calibration.pixelDepth / d;
            ((Calibration)cloneable).pixelDepth = calibration.pixelWidth * this.outputZSpacing;
        } else {
            ((Calibration)cloneable).pixelDepth = 1.0;
            ((Calibration)cloneable).pixelHeight = 1.0;
            ((Calibration)cloneable).pixelWidth = 1.0;
            ((Calibration)cloneable).setUnit("pixel");
        }
        if (rotate) {
            double d2 = ((Calibration)cloneable).pixelWidth;
            ((Calibration)cloneable).pixelWidth = ((Calibration)cloneable).pixelHeight;
            ((Calibration)cloneable).pixelHeight = d2;
        }
        return imagePlus2;
    }

    ImagePlus resliceHyperstack(ImagePlus imagePlus) {
        int n = imagePlus.getNChannels();
        int n2 = imagePlus.getNSlices();
        int n3 = imagePlus.getNFrames();
        if (n2 == 1) {
            IJ.error("Reslice...", "Cannot reslice z=1 hyperstacks");
            return null;
        }
        int n4 = imagePlus.getChannel();
        int n5 = imagePlus.getSlice();
        int n6 = imagePlus.getFrame();
        int n7 = imagePlus.getWidth();
        int n8 = imagePlus.getHeight();
        ImagePlus imagePlus2 = null;
        ImageStack imageStack = null;
        Roi roi = imagePlus.getRoi();
        for (int i = 1; i <= n3; ++i) {
            for (int j = 1; j <= n; ++j) {
                ImageStack imageStack2 = new ImageStack(n7, n8);
                for (int k = 1; k <= n2; ++k) {
                    imagePlus.setPositionWithoutUpdate(j, k, i);
                    imageStack2.addSlice(null, imagePlus.getProcessor());
                }
                ImagePlus imagePlus3 = new ImagePlus("tmp", imageStack2);
                imagePlus3.setCalibration(imagePlus.getCalibration());
                imagePlus3.setRoi(roi);
                ImagePlus imagePlus4 = this.reslice(imagePlus3);
                int n9 = imagePlus4.getStackSize();
                if (imagePlus2 == null) {
                    imagePlus2 = imagePlus4.createHyperStack("Reslice of " + imagePlus.getTitle(), n, n9, n3, imagePlus4.getBitDepth());
                    imageStack = imagePlus2.getStack();
                }
                ImageStack imageStack3 = imagePlus4.getStack();
                for (int k = 1; k <= n9; ++k) {
                    imagePlus.setPositionWithoutUpdate(j, k, i);
                    int n10 = imagePlus2.getStackIndex(j, k, i);
                    imageStack.setPixels(imageStack3.getPixels(k), n10);
                }
            }
        }
        imagePlus.setPosition(n4, n5, n6);
        if (n > 1 && imagePlus.isComposite()) {
            imagePlus2 = new CompositeImage(imagePlus2, ((CompositeImage)imagePlus).getMode());
            ((CompositeImage)imagePlus2).copyLuts(imagePlus);
        }
        return imagePlus2;
    }

    boolean showDialog(ImagePlus imagePlus) {
        String string;
        boolean bl;
        Calibration calibration = imagePlus.getCalibration();
        if (calibration.pixelDepth < 0.0) {
            calibration.pixelDepth = -calibration.pixelDepth;
        }
        String string2 = calibration.getUnits();
        if (calibration.pixelWidth == 0.0) {
            calibration.pixelWidth = 1.0;
        }
        this.inputZSpacing = calibration.pixelDepth;
        double d = calibration.pixelDepth;
        Roi roi = imagePlus.getRoi();
        boolean bl2 = bl = roi != null && roi.getType() == 5;
        if (bl) {
            this.saveLineInfo(roi);
        }
        if ((string = Macro.getOptions()) != null && string.indexOf("output=") != -1) {
            Macro.setOptions(string.replaceAll("output=", "slice="));
            Macro.setOptions(string.replaceAll("slice=", "slice_count="));
        }
        GenericDialog genericDialog = new GenericDialog("Reslice");
        genericDialog.addNumericField("Slice Spacing (" + string2 + "):", d, 3);
        if (bl) {
            genericDialog.addNumericField("Slice_Count:", this.outputSlices, 0);
        } else {
            genericDialog.addChoice("Start At:", starts, startAt);
        }
        genericDialog.addCheckbox("Flip Vertically", flip);
        genericDialog.addCheckbox("Rotate 90 Degrees", rotate);
        genericDialog.addCheckbox("Avoid Interpolation", nointerpolate);
        genericDialog.setInsets(0, 32, 0);
        genericDialog.addMessage("(use 1.0 for spacings)");
        genericDialog.setInsets(15, 0, 0);
        genericDialog.addMessage("Voxel Size: " + this.d2s(calibration.pixelWidth) + "x" + this.d2s(calibration.pixelHeight) + "x" + this.d2s(calibration.pixelDepth) + " " + calibration.getUnit());
        genericDialog.setInsets(5, 0, 0);
        genericDialog.addMessage("Output Size: " + this.getSize(calibration.pixelDepth, d, this.outputSlices) + "\t\t\t\t");
        this.fields = genericDialog.getNumericFields();
        for (int i = 0; i < this.fields.size(); ++i) {
            ((TextField)this.fields.elementAt(i)).addTextListener(this);
        }
        this.checkboxes = genericDialog.getCheckboxes();
        ((Checkbox)this.checkboxes.elementAt(2)).addItemListener(this);
        this.message = (Label)genericDialog.getMessage();
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        this.outputZSpacing = genericDialog.getNextNumber() / calibration.pixelWidth;
        if (bl) {
            this.outputSlices = (int)genericDialog.getNextNumber();
            imagePlus.setRoi(roi);
        } else {
            startAt = genericDialog.getNextChoice();
        }
        flip = genericDialog.getNextBoolean();
        rotate = genericDialog.getNextBoolean();
        nointerpolate = genericDialog.getNextBoolean();
        return true;
    }

    String d2s(double d) {
        String string = d == (double)((int)d) ? ResultsTable.d2s(d, 0) : ResultsTable.d2s(d, 2);
        if (string.indexOf(".") != -1 && string.endsWith("0")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    void saveLineInfo(Roi roi) {
        Line line = (Line)roi;
        this.gx1 = line.x1;
        this.gy1 = line.y1;
        this.gx2 = line.x2;
        this.gy2 = line.y2;
        this.gLength = line.getRawLength();
    }

    ImagePlus resliceRectOrLine(ImagePlus imagePlus) {
        Cloneable cloneable;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        this.noRoi = false;
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            this.noRoi = true;
            imagePlus.setRoi(0, 0, imagePlus.getWidth(), imagePlus.getHeight());
            roi = imagePlus.getRoi();
        }
        if (roi.getType() == 0) {
            cloneable = roi.getBounds();
            if (startAt.equals(starts[0])) {
                d = cloneable.x;
                d2 = cloneable.y;
                d3 = cloneable.x + cloneable.width;
                d4 = cloneable.y;
                d5 = 0.0;
                d6 = this.outputZSpacing;
                this.outputSlices = (int)((double)cloneable.height / this.outputZSpacing);
            } else if (startAt.equals(starts[1])) {
                d = cloneable.x;
                d2 = cloneable.y;
                d3 = cloneable.x;
                d4 = cloneable.y + cloneable.height;
                d5 = this.outputZSpacing;
                d6 = 0.0;
                this.outputSlices = (int)((double)cloneable.width / this.outputZSpacing);
            } else if (startAt.equals(starts[2])) {
                d = cloneable.x;
                d2 = cloneable.y + cloneable.height - 1;
                d3 = cloneable.x + cloneable.width;
                d4 = cloneable.y + cloneable.height - 1;
                d5 = 0.0;
                d6 = -this.outputZSpacing;
                this.outputSlices = (int)((double)cloneable.height / this.outputZSpacing);
            } else if (startAt.equals(starts[3])) {
                d = cloneable.x + cloneable.width - 1;
                d2 = cloneable.y;
                d3 = cloneable.x + cloneable.width - 1;
                d4 = cloneable.y + cloneable.height;
                d5 = -this.outputZSpacing;
                d6 = 0.0;
                this.outputSlices = (int)((double)cloneable.width / this.outputZSpacing);
            }
        } else if (roi.getType() == 5) {
            cloneable = (Line)roi;
            d = ((Line)cloneable).x1;
            d2 = ((Line)cloneable).y1;
            d3 = ((Line)cloneable).x2;
            d4 = ((Line)cloneable).y2;
            double d7 = d3 - d;
            double d8 = d4 - d2;
            double d9 = Math.sqrt(d7 * d7 + d8 * d8) / this.outputZSpacing;
            d5 = -(d8 / d9);
            d6 = d7 / d9;
        } else {
            return null;
        }
        if (this.outputSlices == 0) {
            IJ.error("Reslicer", "Output Z spacing (" + IJ.d2s(this.outputZSpacing, 0) + " pixels) is too large.\n" + "Is the voxel size in Image>Properties correct?.");
            return null;
        }
        boolean bl = imagePlus.getStack().isVirtual();
        String string = null;
        Object var17_17 = null;
        ImageStack imageStack = null;
        boolean bl2 = imagePlus.getStackSize() > 1;
        IJ.resetEscape();
        for (int i = 0; i < this.outputSlices; ++i) {
            if (bl) {
                string = this.outputSlices > 1 ? i + 1 + "/" + this.outputSlices + ", " : "";
            }
            ImageProcessor imageProcessor = this.getSlice(imagePlus, d, d2, d3, d4, string);
            if (bl2) {
                this.drawLine(d, d2, d3, d4, imagePlus);
            }
            if (imageStack == null && ((imageStack = this.createOutputStack(imagePlus, imageProcessor)) == null || imageStack.getSize() < this.outputSlices)) {
                return null;
            }
            imageStack.setPixels(imageProcessor.getPixels(), i + 1);
            d += d5;
            d3 += d5;
            d2 += d6;
            d4 += d6;
            if (!IJ.escapePressed()) continue;
            IJ.beep();
            imagePlus.draw();
            return null;
        }
        return new ImagePlus("Reslice of " + imagePlus.getShortTitle(), imageStack);
    }

    ImageStack createOutputStack(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        int n;
        int n2;
        int n3;
        int n4 = imagePlus.getBitDepth();
        int n5 = imageProcessor.getWidth();
        ImagePlus imagePlus2 = NewImage.createImage("temp", n5, n3 = imageProcessor.getHeight(), n2 = this.outputSlices, n4, n = 9);
        if (imagePlus2 != null && imagePlus2.getStackSize() == n2) {
            IJ.showStatus("Reslice... (press 'Esc' to abort)");
        }
        if (imagePlus2 == null) {
            return null;
        }
        ImageStack imageStack = imagePlus2.getStack();
        imageStack.setColorModel(imageProcessor.getColorModel());
        return imageStack;
    }

    ImageProcessor getSlice(ImagePlus imagePlus, double d, double d2, double d3, double d4, String string) {
        Roi roi = imagePlus.getRoi();
        int n = roi != null ? roi.getType() : 0;
        ImageStack imageStack = imagePlus.getStack();
        int n2 = imageStack.getSize();
        ImageProcessor imageProcessor = null;
        float[] fArray = null;
        boolean bl = (double)((int)d) == d && (double)((int)d2) == d2 && d == d3 || d2 == d4;
        for (int i = 0; i < n2; ++i) {
            ImageProcessor imageProcessor2 = imageStack.getProcessor(flip ? n2 - i : i + 1);
            fArray = n == 6 || n == 7 ? this.getIrregularProfile(roi, imageProcessor2) : (bl ? this.getOrthoLine(imageProcessor2, (int)d, (int)d2, (int)d3, (int)d4, fArray) : this.getLine(imageProcessor2, d, d2, d3, d4, fArray));
            if (rotate) {
                if (i == 0) {
                    imageProcessor = imageProcessor2.createProcessor(n2, fArray.length);
                }
                this.putColumn(imageProcessor, i, 0, fArray, fArray.length);
            } else {
                if (i == 0) {
                    imageProcessor = imageProcessor2.createProcessor(fArray.length, n2);
                }
                this.putRow(imageProcessor, 0, i, fArray, fArray.length);
            }
            if (string == null) continue;
            IJ.showStatus("Slicing: " + string + i + "/" + n2);
        }
        Calibration calibration = imagePlus.getCalibration();
        double d5 = this.inputZSpacing / calibration.pixelWidth;
        if (d5 != 1.0) {
            imageProcessor.setInterpolate(true);
            imageProcessor = rotate ? imageProcessor.resize((int)((double)n2 * d5), fArray.length) : imageProcessor.resize(fArray.length, (int)((double)n2 * d5));
        }
        return imageProcessor;
    }

    public void putRow(ImageProcessor imageProcessor, int n, int n2, float[] fArray, int n3) {
        if (this.rgb) {
            for (int i = 0; i < n3; ++i) {
                imageProcessor.putPixel(n++, n2, Float.floatToIntBits(fArray[i]));
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                imageProcessor.putPixelValue(n++, n2, fArray[i]);
            }
        }
    }

    public void putColumn(ImageProcessor imageProcessor, int n, int n2, float[] fArray, int n3) {
        if (this.rgb) {
            for (int i = 0; i < n3; ++i) {
                imageProcessor.putPixel(n, n2++, Float.floatToIntBits(fArray[i]));
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                imageProcessor.putPixelValue(n, n2++, fArray[i]);
            }
        }
    }

    float[] getIrregularProfile(Roi roi, ImageProcessor imageProcessor) {
        if (this.x == null) {
            this.doIrregularSetup(roi);
        }
        float[] fArray = new float[(int)this.length];
        double d = 1.0;
        double d2 = 0.0;
        double d3 = this.xbase;
        double d4 = this.ybase;
        for (int i = 0; i < this.n; ++i) {
            double d5 = this.segmentLengths[i];
            if (d5 == 0.0) continue;
            double d6 = this.dx[i] / d5;
            double d7 = this.dy[i] / d5;
            double d8 = 1.0 - d;
            double d9 = (double)this.xbase + this.x[i] + d8 * d6;
            double d10 = (double)this.ybase + this.y[i] + d8 * d7;
            double d11 = d5 - d8;
            int n = (int)d11;
            for (int j = 0; j <= n; ++j) {
                int n2 = (int)d2 + j;
                if (n2 < fArray.length) {
                    if (this.notFloat) {
                        fArray[n2] = (float)imageProcessor.getInterpolatedPixel(d9, d10);
                    } else if (this.rgb) {
                        int n3 = ((ColorProcessor)imageProcessor).getInterpolatedRGBPixel(d9, d10);
                        fArray[n2] = Float.intBitsToFloat(n3 & 0xFFFFFF);
                    } else {
                        fArray[n2] = (float)imageProcessor.getInterpolatedValue(d9, d10);
                    }
                }
                d9 += d6;
                d10 += d7;
            }
            d2 += d5;
            d = d11 - (double)n;
        }
        return fArray;
    }

    void doIrregularSetup(Roi roi) {
        int n;
        this.n = ((PolygonRoi)roi).getNCoordinates();
        int[] nArray = ((PolygonRoi)roi).getXCoordinates();
        int[] nArray2 = ((PolygonRoi)roi).getYCoordinates();
        this.x = new double[this.n];
        this.y = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.x[n] = nArray[n];
            this.y[n] = nArray2[n];
        }
        if (roi.getType() == 7) {
            for (n = 1; n < this.n - 1; ++n) {
                this.x[n] = (this.x[n - 1] + this.x[n] + this.x[n + 1]) / 3.0 + 0.5;
                this.y[n] = (this.y[n - 1] + this.y[n] + this.y[n + 1]) / 3.0 + 0.5;
            }
        }
        Rectangle rectangle = roi.getBounds();
        this.xbase = rectangle.x;
        this.ybase = rectangle.y;
        this.length = 0.0;
        this.segmentLengths = new double[this.n];
        this.dx = new double[this.n];
        this.dy = new double[this.n];
        for (int i = 0; i < this.n - 1; ++i) {
            double d = this.x[i + 1] - this.x[i];
            double d2 = this.y[i + 1] - this.y[i];
            double d3 = Math.sqrt(d * d + d2 * d2);
            this.length += d3;
            this.segmentLengths[i] = d3;
            this.dx[i] = d;
            this.dy[i] = d2;
        }
    }

    private float[] getLine(ImageProcessor imageProcessor, double d, double d2, double d3, double d4, float[] fArray) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        int n = (int)Math.round(Math.sqrt(d5 * d5 + d6 * d6));
        if (fArray == null) {
            fArray = new float[n];
        }
        double d7 = d5 / (double)n;
        double d8 = d6 / (double)n;
        double d9 = d;
        double d10 = d2;
        for (int i = 0; i < n; ++i) {
            if (this.notFloat) {
                fArray[i] = (float)imageProcessor.getInterpolatedPixel(d9, d10);
            } else if (this.rgb) {
                int n2 = ((ColorProcessor)imageProcessor).getInterpolatedRGBPixel(d9, d10);
                fArray[i] = Float.intBitsToFloat(n2 & 0xFFFFFF);
            } else {
                fArray[i] = (float)imageProcessor.getInterpolatedValue(d9, d10);
            }
            d9 += d7;
            d10 += d8;
        }
        return fArray;
    }

    private float[] getOrthoLine(ImageProcessor imageProcessor, int n, int n2, int n3, int n4, float[] fArray) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        int n7 = Math.max(Math.abs(n5), Math.abs(n6));
        if (fArray == null) {
            fArray = new float[n7];
        }
        int n8 = n5 / n7;
        int n9 = n6 / n7;
        int n10 = n;
        int n11 = n2;
        for (int i = 0; i < n7; ++i) {
            if (this.notFloat) {
                fArray[i] = imageProcessor.getPixel(n10, n11);
            } else if (this.rgb) {
                int n12 = ((ColorProcessor)imageProcessor).getPixel(n10, n11);
                fArray[i] = Float.intBitsToFloat(n12 & 0xFFFFFF);
            } else {
                fArray[i] = imageProcessor.getPixelValue(n10, n11);
            }
            n10 += n8;
            n11 += n9;
        }
        return fArray;
    }

    void drawLine(double d, double d2, double d3, double d4, ImagePlus imagePlus) {
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        if (imageCanvas == null) {
            return;
        }
        Graphics graphics = imageCanvas.getGraphics();
        graphics.setColor(new Color(1.0f, 1.0f, 0.0f, 0.4f));
        graphics.drawLine(imageCanvas.screenX((int)(d + 0.5)), imageCanvas.screenY((int)(d2 + 0.5)), imageCanvas.screenX((int)(d3 + 0.5)), imageCanvas.screenY((int)(d4 + 0.5)));
    }

    public void textValueChanged(TextEvent textEvent) {
        this.updateSize();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (IJ.isMacOSX()) {
            IJ.wait(100);
        }
        Checkbox checkbox = (Checkbox)this.checkboxes.elementAt(2);
        nointerpolate = checkbox.getState();
        this.updateSize();
    }

    void updateSize() {
        boolean bl;
        double d = Tools.parseDouble(((TextField)this.fields.elementAt(0)).getText(), 0.0);
        int n = 0;
        boolean bl2 = bl = this.fields.size() == 2;
        if (bl && (n = (int)Tools.parseDouble(((TextField)this.fields.elementAt(1)).getText(), 0.0)) > 0) {
            this.makePolygon(n, d);
        }
        String string = this.getSize(this.inputZSpacing, d, n);
        this.message.setText("Output Size: " + string);
    }

    String getSize(double d, double d2, int n) {
        String string;
        int n2 = this.getOutputStackSize(d, d2, n);
        int n3 = this.getAvailableMemory();
        String string2 = string = n3 != -1 ? " (" + n3 + "MB free)" : "";
        if (this.message != null) {
            this.message.setForeground(n3 != -1 && n2 > n3 ? Color.red : Color.black);
        }
        if (n2 > 0) {
            return n2 + "MB" + string;
        }
        return "<1MB" + string;
    }

    void makePolygon(int n, double d) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        Calibration calibration = this.imp.getCalibration();
        double d2 = calibration.pixelWidth;
        double d3 = calibration.pixelHeight;
        nArray[0] = (int)this.gx1;
        nArray2[0] = (int)this.gy1;
        nArray[1] = (int)this.gx2;
        nArray2[1] = (int)this.gy2;
        double d4 = this.gx2 - this.gx1;
        double d5 = this.gy2 - this.gy1;
        double d6 = Math.sqrt(d4 * d4 + d5 * d5) / d;
        double d7 = -(d5 / (d2 * d6));
        double d8 = d4 / (d3 * d6);
        nArray[2] = nArray[1] + (int)(d7 * (double)n);
        nArray2[2] = nArray2[1] + (int)(d8 * (double)n);
        nArray[3] = nArray[0] + (int)(d7 * (double)n);
        nArray2[3] = nArray2[0] + (int)(d8 * (double)n);
        this.imp.setRoi(new PolygonRoi(nArray, nArray2, 4, 3));
    }

    int getOutputStackSize(double d, double d2, int n) {
        Roi roi = this.imp.getRoi();
        int n2 = this.imp.getWidth();
        int n3 = this.imp.getHeight();
        if (roi != null) {
            Rectangle rectangle = roi.getBounds();
            n2 = rectangle.width;
            n2 = rectangle.height;
        }
        int n4 = roi != null ? roi.getType() : 0;
        int n5 = this.imp.getStackSize();
        double d3 = 0.0;
        if (n4 == 0) {
            d3 = n2 * n3 * n5;
            if (d2 > 0.0 && !nointerpolate) {
                d3 *= d / d2;
            }
        } else {
            d3 = this.gLength * (double)n * (double)n5;
        }
        int n6 = this.imp.getBitDepth();
        switch (n6) {
            case 16: {
                d3 *= 2.0;
                break;
            }
            case 24: 
            case 32: {
                d3 *= 4.0;
            }
        }
        return (int)Math.round(d3 / 1048576.0);
    }

    int getAvailableMemory() {
        long l = IJ.maxMemory();
        if (l == 0L) {
            return -1;
        }
        long l2 = IJ.currentMemory();
        long l3 = l - l2;
        return (int)((l3 + 524288L) / 0x100000L);
    }
}

