/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.measure.Measurements;
import ij.plugin.TextReader;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class Calibrator
implements PlugInFilter,
Measurements,
ActionListener {
    private static final String NONE = "None";
    private static final String INVERTER = "Pixel Inverter";
    private static final String UNCALIBRATED_OD = "Uncalibrated OD";
    private static final String CUSTOM = "Custom";
    private static boolean showSettings;
    private boolean global1;
    private boolean global2;
    private ImagePlus imp;
    private int choiceIndex;
    private String[] functions;
    private int nFits = CurveFitter.fitList.length;
    private int spacerIndex = this.nFits + 1;
    private int inverterIndex = this.nFits + 2;
    private int odIndex = this.nFits + 3;
    private int customIndex = this.nFits + 4;
    private static String xText;
    private static String yText;
    private static boolean importedValues;
    private String unit;
    private double lx = 0.02;
    private double ly = 0.1;
    private int oldFunction;
    private String sumResiduals;
    private String fitGoodness;
    private Button open;
    private Button save;
    private GenericDialog gd;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        IJ.register(Calibrator.class);
        return 143;
    }

    public void run(ImageProcessor imageProcessor) {
        boolean bl = this.global1 = this.imp.getGlobalCalibration() != null;
        if (!this.showDialog(this.imp)) {
            return;
        }
        if (this.choiceIndex == this.customIndex) {
            this.showPlot(null, null, this.imp.getCalibration(), null);
            return;
        }
        if (this.imp.getType() == 2) {
            if (this.choiceIndex == 0) {
                this.imp.getCalibration().setValueUnit(this.unit);
            } else {
                IJ.error("Calibrate", "Function must be \"None\" for 32-bit images,\nbut you can change the Unit.");
            }
        } else {
            this.calibrate(this.imp);
        }
    }

    public boolean showDialog(ImagePlus imagePlus) {
        int n;
        Calibration calibration = imagePlus.getCalibration();
        this.functions = this.getFunctionList(calibration.getFunction() == 22);
        this.oldFunction = n = calibration.getFunction();
        double[] dArray = calibration.getCoefficients();
        this.unit = calibration.getValueUnit();
        String string = n == 20 ? NONE : (n < this.nFits && n == 0 && dArray != null && dArray[0] == 255.0 && dArray[1] == -1.0 ? INVERTER : (n < this.nFits ? CurveFitter.fitList[n] : (n == 21 ? UNCALIBRATED_OD : (n == 22 ? CUSTOM : NONE))));
        String string2 = this.getMeans();
        if (!importedValues && !string2.equals("")) {
            xText = string2;
        }
        this.gd = new GenericDialog("Calibrate...");
        this.gd.addChoice("Function:", this.functions, string);
        this.gd.addStringField("Unit:", this.unit, 16);
        this.gd.addTextAreas(xText, yText, 20, 14);
        this.gd.addPanel(this.makeButtonPanel(this.gd));
        this.gd.addCheckbox("Global calibration", this.global1);
        this.gd.addHelp("http://imagej.nih.gov/ij/docs/menus/analyze.html#cal");
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return false;
        }
        this.choiceIndex = this.gd.getNextChoiceIndex();
        this.unit = this.gd.getNextString();
        xText = this.gd.getNextText();
        yText = this.gd.getNextText();
        this.global2 = this.gd.getNextBoolean();
        return true;
    }

    Panel makeButtonPanel(GenericDialog genericDialog) {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 5, 0));
        this.open = new Button("Open...");
        this.open.addActionListener(this);
        panel.add(this.open);
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        panel.add(this.save);
        return panel;
    }

    public void calibrate(ImagePlus imagePlus) {
        Calibration calibration = imagePlus.getCalibration();
        Calibration calibration2 = calibration.copy();
        int n = 20;
        boolean bl = imagePlus.getType() == 1;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        boolean bl2 = false;
        if (this.choiceIndex <= 0) {
            if (this.oldFunction == 20 && !yText.equals("") && !xText.equals("")) {
                IJ.error("Calibrate", "Please select a function");
            }
            n = 20;
        } else if (this.choiceIndex <= this.nFits) {
            n = this.choiceIndex - 1;
            dArray2 = this.getData(xText);
            dArray3 = this.getData(yText);
            if (!(calibration.calibrated() && dArray3.length == 0 && n == this.oldFunction || (dArray = this.doCurveFitting(dArray2, dArray3, n)) != null)) {
                return;
            }
            if (!bl && n != 0) {
                bl2 = true;
                for (int i = 0; i < dArray3.length; ++i) {
                    if (!(dArray3[i] < 0.0)) continue;
                    bl2 = false;
                }
            }
        } else if (this.choiceIndex == this.inverterIndex) {
            n = 0;
            dArray = new double[]{bl ? 65535.0 : 255.0, -1.0};
            this.unit = "Inverted Gray Value";
        } else if (this.choiceIndex == this.odIndex) {
            if (bl) {
                IJ.error("Calibrate", "Uncalibrated OD is not supported on 16-bit images.");
                return;
            }
            n = 21;
            this.unit = UNCALIBRATED_OD;
        }
        calibration.setFunction(n, dArray, this.unit, bl2);
        if (!calibration.equals(calibration2)) {
            imagePlus.setCalibration(calibration);
        }
        imagePlus.setGlobalCalibration(this.global2 ? calibration : null);
        if (this.global2 || this.global2 != this.global1) {
            WindowManager.repaintImageWindows();
        } else {
            imagePlus.repaintWindow();
        }
        if (this.global2 && this.global2 != this.global1) {
            FileOpener.setShowConflictMessage(true);
        }
        if (n != 20) {
            this.showPlot(dArray2, dArray3, calibration, this.fitGoodness);
        }
    }

    double[] doCurveFitting(double[] dArray, double[] dArray2, int n) {
        if (dArray.length != dArray2.length || dArray2.length == 0) {
            IJ.error("Calibrate", "To create a calibration curve, the left column must\ncontain a list of measured mean pixel values and the\nright column must contain the same number of calibration\nstandard values. Use the Measure command to add mean\npixel value measurements to the left column.\n \n    Left column: " + dArray.length + " values\n" + "    Right column: " + dArray2.length + " values\n");
            return null;
        }
        int n2 = dArray.length;
        double d = 0.0;
        double d2 = this.imp.getType() == 1 ? 65535.0 : 255.0;
        double[] dArray3 = Tools.getMinMax(dArray2);
        double d3 = dArray3[0];
        double d4 = dArray3[1];
        CurveFitter curveFitter = new CurveFitter(dArray, dArray2);
        curveFitter.doFit(n, showSettings);
        int n3 = curveFitter.getNumParams();
        double[] dArray4 = curveFitter.getParams();
        this.fitGoodness = IJ.d2s(curveFitter.getRSquared(), 6);
        double[] dArray5 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray5[i] = dArray4[i];
        }
        return dArray5;
    }

    void showPlot(double[] dArray, double[] dArray2, Calibration calibration, String string) {
        int n;
        int n2;
        boolean bl;
        if (!calibration.calibrated() || IJ.macroRunning() && Macro.getOptions() != null) {
            return;
        }
        float[] fArray = calibration.getCTable();
        if (fArray.length == 256) {
            bl = false;
            n2 = 255;
        } else {
            bl = false;
            n2 = 65535;
        }
        int n3 = 256;
        float[] fArray2 = new float[n3];
        float[] fArray3 = new float[n3];
        for (n = 0; n < n3; ++n) {
            fArray2[n] = (float)((double)n / 255.0 * (double)n2);
        }
        for (n = 0; n < n3; ++n) {
            fArray3[n] = fArray[(int)fArray2[n]];
        }
        double[] dArray3 = Tools.getMinMax(fArray3);
        double d = dArray3[0];
        double d2 = dArray3[1];
        int n4 = calibration.getFunction();
        String string2 = calibration.getValueUnit();
        Plot plot = new Plot("Calibration Function", "pixel value", string2, fArray2, fArray3);
        plot.setLimits((double)bl, n2, d, d2);
        if (dArray != null && dArray2 != null && dArray.length > 0 && dArray2.length > 0) {
            plot.addPoints(dArray, dArray2, 0);
        }
        double[] dArray4 = calibration.getCoefficients();
        if (n4 <= 9) {
            this.drawLabel(plot, CurveFitter.fList[n4]);
            this.ly += 0.04;
        }
        if (dArray4 != null) {
            int n5 = dArray4.length;
            this.drawLabel(plot, "a=" + IJ.d2s(dArray4[0], 6));
            this.drawLabel(plot, "b=" + IJ.d2s(dArray4[1], 6));
            if (n5 >= 3) {
                this.drawLabel(plot, "c=" + IJ.d2s(dArray4[2], 6));
            }
            if (n5 >= 4) {
                this.drawLabel(plot, "d=" + IJ.d2s(dArray4[3], 6));
            }
            if (n5 >= 5) {
                this.drawLabel(plot, "e=" + IJ.d2s(dArray4[4], 6));
            }
            this.ly += 0.04;
        }
        if (string != null) {
            this.drawLabel(plot, "R^2=" + string);
            string = null;
        }
        plot.show();
    }

    void drawLabel(Plot plot, String string) {
        plot.addLabel(this.lx, this.ly, string);
        this.ly += 0.08;
    }

    double sqr(double d) {
        return d * d;
    }

    String[] getFunctionList(boolean bl) {
        int n = this.nFits + 4;
        if (bl) {
            ++n;
        }
        String[] stringArray = new String[n];
        stringArray[0] = NONE;
        for (int i = 0; i < this.nFits; ++i) {
            stringArray[1 + i] = CurveFitter.fitList[i];
        }
        stringArray[this.spacerIndex] = "-";
        stringArray[this.inverterIndex] = INVERTER;
        stringArray[this.odIndex] = UNCALIBRATED_OD;
        if (bl) {
            stringArray[this.customIndex] = CUSTOM;
        }
        return stringArray;
    }

    String getMeans() {
        float[] fArray = Analyzer.getUMeans();
        int n = Analyzer.getCounter();
        if (fArray == null || n == 0) {
            return "";
        }
        if (n > 20) {
            n = 20;
        }
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + IJ.d2s(fArray[i], 2) + "\n";
        }
        importedValues = false;
        return string;
    }

    double[] getData(String string) {
        int n;
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            if ((n < 48 || n > 57) && n != 45 && n != 46 && n != 44 && n != 10 && n != 13) continue;
            stringBuffer.append((char)n);
        }
        string = stringBuffer.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        n = stringTokenizer.countTokens();
        if (n < 1) {
            return new double[0];
        }
        int n3 = n;
        double[] dArray = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray[i] = this.getNum(stringTokenizer);
        }
        return dArray;
    }

    double getNum(StringTokenizer stringTokenizer) {
        Double d;
        String string = stringTokenizer.nextToken();
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    void save() {
        TextArea textArea = this.gd.getTextArea1();
        TextArea textArea2 = this.gd.getTextArea2();
        textArea.selectAll();
        String string = textArea.getText();
        textArea.select(0, 0);
        textArea2.selectAll();
        String string2 = textArea2.getText();
        textArea2.select(0, 0);
        double[] dArray = this.getData(string);
        double[] dArray2 = this.getData(string2);
        SaveDialog saveDialog = new SaveDialog("Save as Text...", "calibration", ".txt");
        String string3 = saveDialog.getFileName();
        if (string3 == null) {
            return;
        }
        String string4 = saveDialog.getDirectory();
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string4 + string3);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            printWriter = new PrintWriter(bufferedOutputStream);
        }
        catch (IOException iOException) {
            IJ.error("" + iOException);
            return;
        }
        IJ.wait(250);
        int n = Math.max(dArray.length, dArray2.length);
        for (int i = 0; i < n; ++i) {
            String string5;
            String string6 = dArray.length == 0 ? "" : (string5 = i < dArray.length ? "" + dArray[i] : "0");
            String string7 = dArray2.length == 0 ? "" : (i < dArray2.length ? "" + dArray2[i] : "0");
            printWriter.println(string5 + "\t" + string7);
        }
        printWriter.close();
    }

    void open() {
        OpenDialog openDialog = new OpenDialog("Open Calibration...", "");
        String string = openDialog.getDirectory();
        String string2 = openDialog.getFileName();
        if (string2 == null) {
            return;
        }
        TextReader textReader = new TextReader();
        String string3 = string + string2;
        ImageProcessor imageProcessor = textReader.open(string3);
        if (imageProcessor == null) {
            return;
        }
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        if (n != 1 && n != 2 || n2 <= 1) {
            IJ.error("Calibrate", "This appears to not be a one or two column text file");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append("" + imageProcessor.getPixelValue(0, i));
            stringBuffer.append("\n");
        }
        String string4 = null;
        String string5 = null;
        if (n == 2) {
            string4 = new String(stringBuffer);
            stringBuffer = new StringBuffer();
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append("" + imageProcessor.getPixelValue(1, i));
                stringBuffer.append("\n");
            }
            string5 = new String(stringBuffer);
        } else {
            string5 = new String(stringBuffer);
        }
        if (string4 != null) {
            TextArea textArea = this.gd.getTextArea1();
            textArea.selectAll();
            textArea.setText(string4);
        }
        TextArea textArea = this.gd.getTextArea2();
        textArea.selectAll();
        textArea.setText(string5);
        importedValues = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.save) {
            this.save();
        } else if (object == this.open) {
            this.open();
        }
    }

    static {
        xText = "";
        yText = "";
    }
}

