/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ColorChooser;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageRoi;
import ij.gui.MessageDialog;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.gui.RoiProperties;
import ij.gui.ShapeRoi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.gui.YesNoCancelDialog;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.RoiDecoder;
import ij.io.RoiEncoder;
import ij.io.SaveDialog;
import ij.macro.Interpreter;
import ij.macro.MacroRunner;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.Colors;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.Filler;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.StringSorter;
import ij.util.Tools;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class RoiManager
extends PlugInFrame
implements ActionListener,
ItemListener,
MouseListener,
MouseWheelListener {
    public static final String LOC_KEY = "manager.loc";
    private static final int BUTTONS = 11;
    private static final int DRAW = 0;
    private static final int FILL = 1;
    private static final int LABEL = 2;
    private static final int SHOW_ALL = 0;
    private static final int SHOW_NONE = 1;
    private static final int LABELS = 2;
    private static final int NO_LABELS = 3;
    private static final int MENU = 0;
    private static final int COMMAND = 1;
    private static int rows = 15;
    private static int lastNonShiftClick = -1;
    private static boolean allowMultipleSelections = true;
    private static String moreButtonLabel = "More \u00bb";
    private Panel panel;
    private static Frame instance;
    private static int colorIndex;
    private List list;
    private Hashtable rois = new Hashtable();
    private Roi roiCopy;
    private boolean canceled;
    private boolean macro;
    private boolean ignoreInterrupts;
    private PopupMenu pm;
    private Button moreButton;
    private Button colorButton;
    private Checkbox showAllCheckbox = new Checkbox("Show All", false);
    private Checkbox labelsCheckbox = new Checkbox("Edit Mode", false);
    private static boolean measureAll;
    private static boolean onePerSlice;
    private static boolean restoreCentered;
    private int prevID;
    private boolean noUpdateMode;
    private int defaultLineWidth = 1;
    private Color defaultColor;
    private boolean firstTime = true;

    public RoiManager() {
        super("ROI Manager");
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = this;
        this.list = new List(rows, allowMultipleSelections);
        this.showWindow();
    }

    public RoiManager(boolean bl) {
        super("ROI Manager");
        this.list = new List(rows, allowMultipleSelections);
    }

    void showWindow() {
        ImageJ imageJ = IJ.getInstance();
        this.addKeyListener(imageJ);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        WindowManager.addWindow(this);
        this.setLayout(new BorderLayout());
        this.list.add("012345678901234");
        this.list.addItemListener(this);
        this.list.addKeyListener(imageJ);
        this.list.addMouseListener(this);
        this.list.addMouseWheelListener(this);
        if (IJ.isLinux()) {
            this.list.setBackground(Color.white);
        }
        this.add("Center", this.list);
        this.panel = new Panel();
        int n = 11;
        this.panel.setLayout(new GridLayout(n, 1, 5, 0));
        this.addButton("Add [t]");
        this.addButton("Update");
        this.addButton("Delete");
        this.addButton("Rename...");
        this.addButton("Measure");
        this.addButton("Deselect");
        this.addButton("Properties...");
        this.addButton("Flatten [F]");
        this.addButton(moreButtonLabel);
        this.showAllCheckbox.addItemListener(this);
        this.panel.add(this.showAllCheckbox);
        this.labelsCheckbox.addItemListener(this);
        this.panel.add(this.labelsCheckbox);
        this.add("East", this.panel);
        this.addPopupMenu();
        this.pack();
        Dimension dimension = this.getSize();
        if (dimension.width > 270) {
            this.setSize(dimension.width - 40, dimension.height);
        }
        this.list.remove(0);
        Point point = Prefs.getLocation(LOC_KEY);
        if (point != null) {
            this.setLocation(point);
        } else {
            GUI.center(this);
        }
        this.show();
        if (IJ.isMacOSX() && IJ.isJava16()) {
            this.list.setMultipleMode(false);
            this.list.setMultipleMode(true);
        }
    }

    void addButton(String string) {
        Button button = new Button(string);
        button.addActionListener(this);
        button.addKeyListener(IJ.getInstance());
        button.addMouseListener(this);
        if (string.equals(moreButtonLabel)) {
            this.moreButton = button;
        }
        this.panel.add(button);
    }

    void addPopupMenu() {
        this.pm = new PopupMenu();
        this.addPopupItem("Open...");
        this.addPopupItem("Save...");
        this.addPopupItem("Fill");
        this.addPopupItem("Draw");
        this.addPopupItem("AND");
        this.addPopupItem("OR (Combine)");
        this.addPopupItem("Split");
        this.addPopupItem("Add Particles");
        this.addPopupItem("Multi Measure");
        this.addPopupItem("Sort");
        this.addPopupItem("Specify...");
        this.addPopupItem("Remove Slice Info");
        this.addPopupItem("Help");
        this.addPopupItem("Options...");
        this.add(this.pm);
    }

    void addPopupItem(String string) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(this);
        this.pm.add(menuItem);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = actionEvent.getModifiers();
        boolean bl = (n & 8) != 0 || IJ.altKeyDown();
        boolean bl2 = (n & 1) != 0 || IJ.shiftKeyDown();
        IJ.setKeyUp(18);
        IJ.setKeyUp(16);
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        String string2 = string;
        if (string2.equals("Add [t]")) {
            this.add(bl2, bl);
        } else if (string2.equals("Update")) {
            this.update(true);
        } else if (string2.equals("Delete")) {
            this.delete(false);
        } else if (string2.equals("Rename...")) {
            this.rename(null);
        } else if (string2.equals("Properties...")) {
            this.setProperties(null, 0, null);
        } else if (string2.equals("Flatten [F]")) {
            this.flatten();
        } else if (string2.equals("Measure")) {
            this.measure(0);
        } else if (string2.equals("Open...")) {
            this.open(null);
        } else if (string2.equals("Save...")) {
            this.save();
        } else if (string2.equals("Fill")) {
            this.drawOrFill(1);
        } else if (string2.equals("Draw")) {
            this.drawOrFill(0);
        } else if (string2.equals("Deselect")) {
            this.select(-1);
        } else if (string2.equals(moreButtonLabel)) {
            Point point = this.panel.getLocation();
            Point point2 = this.moreButton.getLocation();
            this.pm.show(this, point.x, point2.y);
        } else if (string2.equals("OR (Combine)")) {
            this.combine();
        } else if (string2.equals("Split")) {
            this.split();
        } else if (string2.equals("AND")) {
            this.and();
        } else if (string2.equals("Add Particles")) {
            this.addParticles();
        } else if (string2.equals("Multi Measure")) {
            this.multiMeasure();
        } else if (string2.equals("Sort")) {
            this.sort();
        } else if (string2.equals("Specify...")) {
            this.specify();
        } else if (string2.equals("Remove Slice Info")) {
            this.removeSliceInfo();
        } else if (string2.equals("Help")) {
            this.help();
        } else if (string2.equals("Options...")) {
            this.options();
        } else if (string2.equals("\"Show All\" Color...")) {
            this.setShowAllColor();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.showAllCheckbox) {
            if (this.firstTime) {
                this.labelsCheckbox.setState(true);
            }
            this.showAll(this.showAllCheckbox.getState() ? 0 : 1);
            this.firstTime = false;
            return;
        }
        if (object == this.labelsCheckbox) {
            if (this.firstTime) {
                this.showAllCheckbox.setState(true);
            }
            this.showAll(this.labelsCheckbox.getState() ? 2 : 3);
            this.firstTime = false;
            return;
        }
        if (itemEvent.getStateChange() == 1 && !this.ignoreInterrupts) {
            int n = 0;
            try {
                n = Integer.parseInt(itemEvent.getItem().toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n < 0) {
                n = 0;
            }
            if (!IJ.isMacintosh()) {
                if (!IJ.shiftKeyDown()) {
                    lastNonShiftClick = n;
                }
                if (!IJ.shiftKeyDown() && !IJ.controlKeyDown()) {
                    int[] nArray = this.list.getSelectedIndexes();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] == n) continue;
                        this.list.deselect(nArray[i]);
                    }
                } else if (IJ.shiftKeyDown() && lastNonShiftClick >= 0 && lastNonShiftClick < this.list.getItemCount()) {
                    int n2;
                    int n3 = Math.min(n, lastNonShiftClick);
                    int n4 = Math.max(n, lastNonShiftClick);
                    int[] nArray = this.list.getSelectedIndexes();
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        if (nArray[n2] >= n3 && nArray[n2] <= n4) continue;
                        this.list.deselect(nArray[n2]);
                    }
                    for (n2 = n3; n2 <= n4; ++n2) {
                        this.list.select(n2);
                    }
                }
            }
            if (WindowManager.getCurrentImage() != null) {
                this.restore(this.getImage(), n, true);
                if (this.record()) {
                    if (Recorder.scriptMode()) {
                        Recorder.recordCall("rm.select(imp, " + n + ");");
                    } else {
                        Recorder.record("roiManager", "Select", n);
                    }
                }
            }
        }
    }

    void add(boolean bl, boolean bl2) {
        if (bl) {
            this.addAndDraw(bl2);
        } else if (bl2) {
            this.addRoi(true);
        } else {
            this.addRoi(false);
        }
    }

    public void addRoi(Roi roi) {
        this.addRoi(roi, false, null, -1);
    }

    boolean addRoi(boolean bl) {
        return this.addRoi(null, bl, null, -1);
    }

    boolean addRoi(Roi roi, boolean bl, Color color, int n) {
        String string;
        Object object;
        int n2;
        ImagePlus imagePlus;
        ImagePlus imagePlus2 = imagePlus = roi == null ? this.getImage() : WindowManager.getCurrentImage();
        if (roi == null) {
            if (imagePlus == null) {
                return false;
            }
            roi = imagePlus.getRoi();
            if (roi == null) {
                this.error("The active image does not have a selection.");
                return false;
            }
        }
        if (color == null && roi.getStrokeColor() != null) {
            color = roi.getStrokeColor();
        } else if (color == null && this.defaultColor != null) {
            color = this.defaultColor;
        }
        if (n < 0) {
            n2 = (int)roi.getStrokeWidth();
            int n3 = n = n2 > 1 ? n2 : this.defaultLineWidth;
        }
        if (n > 100) {
            n = 1;
        }
        if ((n2 = this.list.getItemCount()) > 0 && !IJ.isMacro() && imagePlus != null && (object = (Roi)this.rois.get(string = this.list.getItem(n2 - 1))) != null) {
            int n4 = this.getSliceNumber(string);
            if (roi.equals(object) && (n4 == -1 || n4 == imagePlus.getCurrentSlice()) && imagePlus.getID() == this.prevID && !Interpreter.isBatchMode()) {
                return false;
            }
        }
        this.prevID = imagePlus != null ? imagePlus.getID() : 0;
        string = roi.getName();
        if (this.isStandardName(string)) {
            string = null;
        }
        object = string != null ? string : this.getLabel(imagePlus, roi, -1);
        object = bl ? this.promptForName((String)object) : this.getUniqueName((String)object);
        if (object == null) {
            return false;
        }
        this.list.add((String)object);
        roi.setName((String)object);
        this.roiCopy = (Roi)roi.clone();
        if (imagePlus != null) {
            Calibration calibration = imagePlus.getCalibration();
            if (calibration.xOrigin != 0.0 || calibration.yOrigin != 0.0) {
                Rectangle rectangle = this.roiCopy.getBounds();
                this.roiCopy.setLocation(rectangle.x - (int)calibration.xOrigin, rectangle.y - (int)calibration.yOrigin);
            }
        }
        this.roiCopy.setStrokeWidth(n);
        if (color != null) {
            this.roiCopy.setStrokeColor(color);
        }
        this.rois.put(object, this.roiCopy);
        this.updateShowAll();
        if (this.record()) {
            this.recordAdd(this.defaultColor, this.defaultLineWidth);
        }
        return true;
    }

    void recordAdd(Color color, int n) {
        if (Recorder.scriptMode()) {
            Recorder.recordCall("rm.addRoi(imp.getRoi());");
        } else if (color != null && n == 1) {
            Recorder.recordString("roiManager(\"Add\", \"" + this.getHex(color) + "\");\n");
        } else if (n > 1) {
            Recorder.recordString("roiManager(\"Add\", \"" + this.getHex(color) + "\", " + n + ");\n");
        } else {
            Recorder.record("roiManager", "Add");
        }
    }

    String getHex(Color color) {
        String string;
        if (color == null) {
            color = ImageCanvas.getShowAllColor();
        }
        if ((string = Integer.toHexString(color.getRGB())).length() == 8) {
            string = string.substring(2);
        }
        return string;
    }

    public void add(ImagePlus imagePlus, Roi roi, int n) {
        if (roi == null) {
            return;
        }
        String string = this.getLabel(imagePlus, roi, n);
        if (string == null) {
            return;
        }
        this.list.add(string);
        roi.setName(string);
        this.roiCopy = (Roi)roi.clone();
        Calibration calibration = imagePlus.getCalibration();
        if (calibration.xOrigin != 0.0 || calibration.yOrigin != 0.0) {
            Rectangle rectangle = this.roiCopy.getBounds();
            this.roiCopy.setLocation(rectangle.x - (int)calibration.xOrigin, rectangle.y - (int)calibration.yOrigin);
        }
        this.rois.put(string, this.roiCopy);
    }

    boolean isStandardName(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        int n = string.length();
        if (n >= 14 && string.charAt(4) == '-' && string.charAt(9) == '-') {
            bl = true;
        } else if (n >= 17 && string.charAt(5) == '-' && string.charAt(11) == '-') {
            bl = true;
        } else if (n >= 9 && string.charAt(4) == '-') {
            bl = true;
        } else if (n >= 11 && string.charAt(5) == '-') {
            bl = true;
        }
        return bl;
    }

    String getLabel(ImagePlus imagePlus, Roi roi, int n) {
        String string;
        Rectangle rectangle = roi.getBounds();
        int n2 = rectangle.x + rectangle.width / 2;
        int n3 = rectangle.y + rectangle.height / 2;
        if (n >= 0) {
            n2 = n3;
            n3 = n;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        int n4 = 4;
        String string2 = "" + n2;
        if (string2.length() > n4) {
            n4 = string2.length();
        }
        if ((string = "" + n3).length() > n4) {
            n4 = string.length();
        }
        if (n4 == 4 && imagePlus != null && imagePlus.getStackSize() >= 10000) {
            n4 = 5;
        }
        string2 = "000000" + n2;
        string = "000000" + n3;
        String string3 = string.substring(string.length() - n4) + "-" + string2.substring(string2.length() - n4);
        if (imagePlus != null && imagePlus.getStackSize() > 1) {
            String string4 = "000000" + imagePlus.getCurrentSlice();
            string3 = string4.substring(string4.length() - n4) + "-" + string3;
        }
        return string3;
    }

    void addAndDraw(boolean bl) {
        if (bl ? !this.addRoi(true) : !this.addRoi(false)) {
            return;
        }
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            Undo.setup(4, imagePlus);
            IJ.run(imagePlus, "Draw", "slice");
            Undo.setup(5, imagePlus);
        }
        if (this.record()) {
            Recorder.record("roiManager", "Add & Draw");
        }
    }

    boolean delete(boolean bl) {
        int n = this.list.getItemCount();
        if (n == 0) {
            return this.error("The list is empty.");
        }
        int[] nArray = this.list.getSelectedIndexes();
        if (nArray.length == 0 || bl && n > 1) {
            String string = "Delete all items on the list?";
            if (bl) {
                string = "Replace items on the list?";
            }
            this.canceled = false;
            if (!IJ.isMacro() && !this.macro) {
                YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)this, "ROI Manager", string);
                if (yesNoCancelDialog.cancelPressed()) {
                    this.canceled = true;
                    return false;
                }
                if (!yesNoCancelDialog.yesPressed()) {
                    return false;
                }
            }
            nArray = this.getAllIndexes();
        }
        for (int i = n - 1; i >= 0; --i) {
            boolean bl2 = false;
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] != i) continue;
                bl2 = true;
            }
            if (!bl2) continue;
            this.rois.remove(this.list.getItem(i));
            this.list.remove(i);
        }
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (n > 1 && nArray.length == 1 && imagePlus != null) {
            imagePlus.killRoi();
        }
        this.updateShowAll();
        if (this.record()) {
            Recorder.record("roiManager", "Delete");
        }
        return true;
    }

    boolean update(boolean bl) {
        ImagePlus imagePlus = this.getImage();
        if (imagePlus == null) {
            return false;
        }
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        boolean bl2 = imageCanvas != null && imageCanvas.getShowAllROIs();
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            this.error("The active image does not have a selection.");
            return false;
        }
        int n = this.list.getSelectedIndex();
        if (n < 0 && !bl2) {
            return this.error("Exactly one item in the list must be selected.");
        }
        if (n >= 0) {
            String string = this.list.getItem(n);
            this.rois.remove(string);
            if (bl) {
                this.rois.put(string, (Roi)roi.clone());
            } else {
                this.rois.put(string, roi);
            }
        }
        if (this.record()) {
            Recorder.record("roiManager", "Update");
        }
        if (bl2) {
            imagePlus.draw();
        }
        return true;
    }

    boolean rename(String string) {
        int n = this.list.getSelectedIndex();
        if (n < 0) {
            return this.error("Exactly one item in the list must be selected.");
        }
        String string2 = this.list.getItem(n);
        if (string == null) {
            string = this.promptForName(string2);
        }
        if (string == null) {
            return false;
        }
        Roi roi = (Roi)this.rois.get(string2);
        this.rois.remove(string2);
        roi.setName(string);
        this.rois.put(string, roi);
        this.list.replaceItem(string, n);
        this.list.select(n);
        if (this.record()) {
            Recorder.record("roiManager", "Rename", string);
        }
        return true;
    }

    String promptForName(String string) {
        GenericDialog genericDialog = new GenericDialog("ROI Manager");
        genericDialog.addStringField("Rename As:", string, 20);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return null;
        }
        String string2 = genericDialog.getNextString();
        string2 = this.getUniqueName(string2);
        return string2;
    }

    boolean restore(ImagePlus imagePlus, int n, boolean bl) {
        ImageCanvas imageCanvas;
        int n2;
        String string = this.list.getItem(n);
        Roi roi = (Roi)this.rois.get(string);
        if (imagePlus == null || roi == null) {
            return false;
        }
        if (bl && (n2 = this.getSliceNumber(string)) >= 1 && n2 <= imagePlus.getStackSize()) {
            if (imagePlus.isHyperStack() || imagePlus.isComposite()) {
                imagePlus.setPosition(n2);
            } else {
                imagePlus.setSlice(n2);
            }
        }
        Roi roi2 = (Roi)roi.clone();
        Calibration calibration = imagePlus.getCalibration();
        Rectangle rectangle = roi2.getBounds();
        if (calibration.xOrigin != 0.0 || calibration.yOrigin != 0.0) {
            roi2.setLocation(rectangle.x + (int)calibration.xOrigin, rectangle.y + (int)calibration.yOrigin);
        }
        int n3 = imagePlus.getWidth();
        int n4 = imagePlus.getHeight();
        if (restoreCentered && (imageCanvas = imagePlus.getCanvas()) != null) {
            Rectangle rectangle2 = imageCanvas.getSrcRect();
            Rectangle rectangle3 = roi2.getBounds();
            roi2.setLocation(rectangle2.x + rectangle2.width / 2 - rectangle3.width / 2, rectangle2.y + rectangle2.height / 2 - rectangle3.height / 2);
        }
        if (rectangle.x >= n3 || rectangle.y >= n4 || rectangle.x + rectangle.width <= 0 || rectangle.y + rectangle.height <= 0) {
            roi2.setLocation((n3 - rectangle.width) / 2, (n4 - rectangle.height) / 2);
        }
        if (this.noUpdateMode) {
            imagePlus.setRoi(roi2, false);
            this.noUpdateMode = false;
        } else {
            imagePlus.setRoi(roi2, true);
        }
        return true;
    }

    boolean restoreWithoutUpdate(int n) {
        this.noUpdateMode = true;
        return this.restore(this.getImage(), n, false);
    }

    public int getSliceNumber(String string) {
        int n = -1;
        if (string.length() >= 14 && string.charAt(4) == '-' && string.charAt(9) == '-') {
            n = (int)Tools.parseDouble(string.substring(0, 4), -1.0);
        } else if (string.length() >= 17 && string.charAt(5) == '-' && string.charAt(11) == '-') {
            n = (int)Tools.parseDouble(string.substring(0, 5), -1.0);
        } else if (string.length() >= 20 && string.charAt(6) == '-' && string.charAt(13) == '-') {
            n = (int)Tools.parseDouble(string.substring(0, 6), -1.0);
        }
        return n;
    }

    void open(String string) {
        Object object;
        Object object2;
        Macro.setOptions(null);
        String string2 = null;
        if (string == null || string.equals("")) {
            object2 = new OpenDialog("Open Selection(s)...", "");
            object = ((OpenDialog)object2).getDirectory();
            string2 = ((OpenDialog)object2).getFileName();
            if (string2 == null) {
                return;
            }
            string = (String)object + string2;
        }
        if (this.record()) {
            Recorder.record("roiManager", "Open", string);
        }
        if (string.endsWith(".zip")) {
            this.openZip(string);
            return;
        }
        object2 = new Opener();
        if (string2 == null) {
            string2 = ((Opener)object2).getName(string);
        }
        if ((object = ((Opener)object2).openRoi(string)) != null) {
            if (string2.endsWith(".roi")) {
                string2 = string2.substring(0, string2.length() - 4);
            }
            string2 = this.getUniqueName(string2);
            this.list.add(string2);
            this.rois.put(string2, object);
        }
        this.updateShowAll();
    }

    void openZip(String string) {
        ZipInputStream zipInputStream = null;
        int n = 0;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(string));
            byte[] byArray = new byte[1024];
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String string2 = zipEntry.getName();
                if (string2.endsWith(".roi")) {
                    int n2;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    while ((n2 = zipInputStream.read(byArray)) > 0) {
                        byteArrayOutputStream.write(byArray, 0, n2);
                    }
                    byteArrayOutputStream.close();
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                    RoiDecoder roiDecoder = new RoiDecoder(byArray2, string2);
                    Roi roi = roiDecoder.getRoi();
                    if (roi != null) {
                        string2 = string2.substring(0, string2.length() - 4);
                        string2 = this.getUniqueName(string2);
                        this.list.add(string2);
                        this.rois.put(string2, roi);
                        ++n;
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
        }
        catch (IOException iOException) {
            this.error(iOException.toString());
        }
        if (n == 0) {
            this.error("This ZIP archive does not appear to contain \".roi\" files");
        }
        this.updateShowAll();
    }

    String getUniqueName(String string) {
        String string2 = string;
        int n = 1;
        Roi roi = (Roi)this.rois.get(string2);
        while (roi != null) {
            roi = (Roi)this.rois.get(string2);
            if (roi != null) {
                int n2 = string2.lastIndexOf("-");
                if (n2 != -1 && string2.length() - n2 < 5) {
                    string2 = string2.substring(0, n2);
                }
                string2 = string2 + "-" + n;
                ++n;
            }
            roi = (Roi)this.rois.get(string2);
        }
        return string2;
    }

    boolean save() {
        if (this.list.getItemCount() == 0) {
            return this.error("The selection list is empty.");
        }
        int[] nArray = this.list.getSelectedIndexes();
        if (nArray.length == 0) {
            nArray = this.getAllIndexes();
        }
        if (nArray.length > 1) {
            return this.saveMultiple(nArray, null);
        }
        String string = this.list.getItem(nArray[0]);
        Macro.setOptions(null);
        SaveDialog saveDialog = new SaveDialog("Save Selection...", string, ".roi");
        String string2 = saveDialog.getFileName();
        if (string2 == null) {
            return false;
        }
        String string3 = saveDialog.getDirectory();
        Roi roi = (Roi)this.rois.get(string);
        this.rois.remove(string);
        if (!string2.endsWith(".roi")) {
            string2 = string2 + ".roi";
        }
        String string4 = string2.substring(0, string2.length() - 4);
        this.rois.put(string4, roi);
        roi.setName(string4);
        this.list.replaceItem(string4, nArray[0]);
        RoiEncoder roiEncoder = new RoiEncoder(string3 + string2);
        try {
            roiEncoder.write(roi);
        }
        catch (IOException iOException) {
            IJ.error("ROI Manager", iOException.getMessage());
        }
        return true;
    }

    boolean saveMultiple(int[] nArray, String string) {
        Object object;
        Object object2;
        Object object3;
        Macro.setOptions(null);
        if (string == null) {
            object3 = new SaveDialog("Save ROIs...", "RoiSet", ".zip");
            object2 = ((SaveDialog)object3).getFileName();
            if (object2 == null) {
                return false;
            }
            if (!((String)object2).endsWith(".zip") && !((String)object2).endsWith(".ZIP")) {
                object2 = (String)object2 + ".zip";
            }
            object = ((SaveDialog)object3).getDirectory();
            string = (String)object + (String)object2;
        }
        try {
            object3 = new ZipOutputStream(new FileOutputStream(string));
            object2 = new DataOutputStream(new BufferedOutputStream((OutputStream)object3));
            object = new RoiEncoder((OutputStream)object2);
            for (int i = 0; i < nArray.length; ++i) {
                String string2 = this.list.getItem(nArray[i]);
                Roi roi = (Roi)this.rois.get(string2);
                if (!string2.endsWith(".roi")) {
                    string2 = string2 + ".roi";
                }
                ((ZipOutputStream)object3).putNextEntry(new ZipEntry(string2));
                ((RoiEncoder)object).write(roi);
                ((DataOutputStream)object2).flush();
            }
            ((FilterOutputStream)object2).close();
        }
        catch (IOException iOException) {
            this.error("" + iOException);
            return false;
        }
        if (this.record()) {
            Recorder.record("roiManager", "Save", string);
        }
        return true;
    }

    boolean measure(int n) {
        int n2;
        ImagePlus imagePlus = this.getImage();
        if (imagePlus == null) {
            return false;
        }
        int[] nArray = this.list.getSelectedIndexes();
        if (nArray.length == 0) {
            nArray = this.getAllIndexes();
        }
        if (nArray.length == 0) {
            return false;
        }
        boolean bl = true;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            String string = this.list.getItem(nArray[n2]);
            if (this.getSliceNumber(string) > 1) {
                bl = false;
            }
            Roi roi = (Roi)this.rois.get(string);
        }
        n2 = Analyzer.getMeasurements();
        if (imagePlus.getStackSize() > 1) {
            Analyzer.setMeasurements(n2 | 0x100000);
        }
        int n3 = imagePlus.getCurrentSlice();
        for (int i = 0; i < nArray.length && this.restore(this.getImage(), nArray[i], !bl); ++i) {
            IJ.run("Measure");
        }
        imagePlus.setSlice(n3);
        Analyzer.setMeasurements(n2);
        if (nArray.length > 1) {
            IJ.run("Select None");
        }
        if (this.record()) {
            Recorder.record("roiManager", "Measure");
        }
        return true;
    }

    boolean multiMeasure() {
        Object object;
        int n;
        ImagePlus imagePlus = this.getImage();
        if (imagePlus == null) {
            return false;
        }
        int[] nArray = this.list.getSelectedIndexes();
        if (nArray.length == 0) {
            nArray = this.getAllIndexes();
        }
        if (nArray.length == 0) {
            return false;
        }
        int n2 = Analyzer.getMeasurements();
        int n3 = imagePlus.getStackSize();
        if (IJ.isMacro()) {
            if (n3 > 1) {
                measureAll = true;
            }
            onePerSlice = true;
        } else {
            GenericDialog genericDialog = new GenericDialog("Multi Measure");
            if (n3 > 1) {
                genericDialog.addCheckbox("Measure All " + n3 + " Slices", measureAll);
            }
            genericDialog.addCheckbox("One Row Per Slice", onePerSlice);
            n = this.getColumnCount(imagePlus, n2) * nArray.length;
            object = n3 == 1 ? "this option" : "both options";
            genericDialog.setInsets(10, 25, 0);
            genericDialog.addMessage("Enabling " + (String)object + " will result\n" + "in a table with " + n + " columns.");
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                return false;
            }
            if (n3 > 1) {
                measureAll = genericDialog.getNextBoolean();
            }
            onePerSlice = genericDialog.getNextBoolean();
        }
        if (!measureAll) {
            n3 = 1;
        }
        int n4 = imagePlus.getCurrentSlice();
        if (!onePerSlice) {
            n = n3 > 1 ? n2 | 0x100000 : n2;
            object = new ResultsTable();
            Analyzer analyzer = new Analyzer(imagePlus, n, (ResultsTable)object);
            for (int i = 1; i <= n3; ++i) {
                if (n3 > 1) {
                    imagePlus.setSliceWithoutUpdate(i);
                }
                for (int j = 0; j < nArray.length && this.restoreWithoutUpdate(nArray[j]); ++j) {
                    analyzer.measure();
                }
            }
            ((ResultsTable)object).show("Results");
            if (n3 > 1) {
                imagePlus.setSlice(n4);
            }
            return true;
        }
        Analyzer analyzer = new Analyzer(imagePlus);
        object = Analyzer.getResultsTable();
        ResultsTable resultsTable = new ResultsTable();
        Analyzer analyzer2 = new Analyzer(imagePlus, n2, resultsTable);
        for (int i = 1; i <= n3; ++i) {
            int n5 = i;
            if (n3 == 1) {
                n5 = n4;
            }
            imagePlus.setSliceWithoutUpdate(n5);
            resultsTable.incrementCounter();
            int n6 = 0;
            for (int j = 0; j < nArray.length && this.restoreWithoutUpdate(nArray[j]); ++j) {
                ++n6;
                analyzer.measure();
                for (int k = 0; k <= ((ResultsTable)object).getLastColumn(); ++k) {
                    String string;
                    float[] fArray = ((ResultsTable)object).getColumn(k);
                    String string2 = ((ResultsTable)object).getColumnHeading(k);
                    String string3 = "" + n6;
                    Roi roi = imagePlus.getRoi();
                    if (!(roi == null || (string = roi.getName()) == null || string.length() <= 0 || string.length() >= 9 && Character.isDigit(string.charAt(0)))) {
                        string3 = "(" + string + ")";
                    }
                    if (string2 == null || fArray == null || string2.equals("Slice")) continue;
                    resultsTable.addValue(string2 + string3, (double)((ResultsTable)object).getValue(k, ((ResultsTable)object).getCounter() - 1));
                }
            }
        }
        resultsTable.show("Results");
        imagePlus.setSlice(n4);
        if (nArray.length > 1) {
            IJ.run("Select None");
        }
        if (this.record()) {
            Recorder.record("roiManager", "Multi Measure");
        }
        return true;
    }

    int getColumnCount(ImagePlus imagePlus, int n) {
        ImageStatistics imageStatistics = imagePlus.getStatistics(n);
        ResultsTable resultsTable = new ResultsTable();
        Analyzer analyzer = new Analyzer(imagePlus, n, resultsTable);
        analyzer.saveResults(imageStatistics, null);
        int n2 = 0;
        for (int i = 0; i <= resultsTable.getLastColumn(); ++i) {
            float[] fArray = resultsTable.getColumn(i);
            String string = resultsTable.getColumnHeading(i);
            if (string == null || fArray == null) continue;
            ++n2;
        }
        return n2;
    }

    boolean drawOrFill(int n) {
        int[] nArray = this.list.getSelectedIndexes();
        if (nArray.length == 0) {
            nArray = this.getAllIndexes();
        }
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        imagePlus.killRoi();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        imageProcessor.setColor(Toolbar.getForegroundColor());
        imageProcessor.snapshot();
        Undo.setup(1, imagePlus);
        Filler filler = n == 2 ? new Filler() : null;
        int n2 = imagePlus.getCurrentSlice();
        block5: for (int i = 0; i < nArray.length; ++i) {
            int n3;
            String string = this.list.getItem(nArray[i]);
            Roi roi = (Roi)this.rois.get(string);
            int n4 = roi.getType();
            if (roi == null) continue;
            if (n == 1 && (n4 == 6 || n4 == 7 || n4 == 8)) {
                n = 0;
            }
            if ((n3 = this.getSliceNumber(string)) >= 1 && n3 <= imagePlus.getStackSize()) {
                imagePlus.setSlice(n3);
                imageProcessor = imagePlus.getProcessor();
                imageProcessor.setColor(Toolbar.getForegroundColor());
                if (n3 != n2) {
                    Undo.reset();
                }
            }
            switch (n) {
                case 0: {
                    roi.drawPixels(imageProcessor);
                    continue block5;
                }
                case 1: {
                    imageProcessor.fillPolygon(roi.getPolygon());
                    continue block5;
                }
                case 2: {
                    roi.drawPixels(imageProcessor);
                    filler.drawLabel(imagePlus, imageProcessor, i + 1, roi.getBounds());
                }
            }
        }
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        if (imageCanvas != null) {
            imageCanvas.setShowAllROIs(false);
        }
        imagePlus.updateAndDraw();
        return true;
    }

    void setProperties(Color color, int n, Color color2) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        int n2;
        int[] nArray = this.list.getSelectedIndexes();
        if (nArray.length == 0) {
            nArray = this.getAllIndexes();
        }
        if ((n2 = nArray.length) == 0) {
            return;
        }
        Roi roi = null;
        String string = null;
        Font font = null;
        double d = -1.0;
        if (color == null && n == 0 && color2 == null) {
            object3 = this.list.getItem(nArray[0]);
            roi = (Roi)this.rois.get(object3);
            if (n2 == 1) {
                color2 = roi.getFillColor();
                string = roi.getName();
            }
            if (roi.getStrokeColor() == null) {
                roi.setStrokeColor(ImageCanvas.getShowAllColor());
            }
            roi = (Roi)roi.clone();
            if (n2 > 1) {
                roi.setName("range: " + (nArray[0] + 1) + "-" + (nArray[n2 - 1] + 1));
            }
            roi.setFillColor(color2);
            object2 = new RoiProperties("Properties", roi);
            if (!((RoiProperties)object2).showDialog()) {
                return;
            }
            this.defaultLineWidth = n = (int)roi.getStrokeWidth();
            color = roi.getStrokeColor();
            color2 = roi.getFillColor();
            this.defaultColor = color;
            if (roi instanceof TextRoi) {
                font = ((TextRoi)roi).getCurrentFont();
            }
            if (roi instanceof ImageRoi) {
                d = ((ImageRoi)roi).getOpacity();
            }
        }
        object3 = WindowManager.getCurrentImage();
        if (n2 == this.list.getItemCount() && !IJ.isMacro()) {
            object2 = new GenericDialog("ROI Manager");
            ((GenericDialog)object2).addMessage("Apply changes to all " + n2 + " selections?");
            ((GenericDialog)object2).showDialog();
            if (((GenericDialog)object2).wasCanceled()) {
                return;
            }
        }
        for (int i = 0; i < n2; ++i) {
            object = this.list.getItem(nArray[i]);
            Roi roi2 = (Roi)this.rois.get(object);
            if (color != null) {
                roi2.setStrokeColor(color);
            }
            if (n > 0) {
                roi2.setStrokeWidth(n);
            }
            roi2.setFillColor(color2);
            if (roi2 != null && roi2 instanceof TextRoi) {
                roi2.setImage((ImagePlus)object3);
                if (font != null) {
                    ((TextRoi)roi2).setCurrentFont(font);
                }
                roi2.setImage(null);
            }
            if (roi2 == null || !(roi2 instanceof ImageRoi) || d == -1.0) continue;
            ((ImageRoi)roi2).setOpacity(d);
        }
        if (roi != null && string != null && !roi.getName().equals(string)) {
            this.rename(roi.getName());
        }
        ImageCanvas imageCanvas = object3 != null ? ((ImagePlus)object3).getCanvas() : null;
        object = object3 != null ? ((ImagePlus)object3).getRoi() : null;
        boolean bl2 = bl = imageCanvas != null && imageCanvas.getShowAllROIs();
        if (!(object == null || n2 != 1 && bl)) {
            if (n != 0) {
                ((Roi)object).setStrokeWidth(n);
            }
            if (color != null) {
                ((Roi)object).setStrokeColor(color);
            }
            if (color2 != null) {
                ((Roi)object).setFillColor(color2);
            }
            if (object != null && object instanceof TextRoi) {
                ((TextRoi)object).setCurrentFont(font);
            }
            if (object != null && object instanceof ImageRoi && d != -1.0) {
                ((ImageRoi)object).setOpacity(d);
            }
        }
        if (n > 1 && !bl && object == null) {
            this.showAll(0);
            bl = true;
        }
        if (object3 != null) {
            ((ImagePlus)object3).draw();
        }
        if (this.record()) {
            if (color2 != null) {
                Recorder.record("roiManager", "Set Fill Color", Colors.colorToString(color2));
            } else {
                Recorder.record("roiManager", "Set Color", Colors.colorToString(color != null ? color : Color.red));
                Recorder.record("roiManager", "Set Line Width", n);
            }
        }
    }

    void flatten() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        if (!imageCanvas.getShowAllROIs() && imageCanvas.getDisplayList() == null && imagePlus.getRoi() == null) {
            this.error("Image does not have an overlay or ROI");
        } else {
            IJ.doCommand("Flatten");
        }
    }

    public boolean getDrawLabels() {
        return this.labelsCheckbox.getState();
    }

    void combine() {
        Roi roi;
        ImagePlus imagePlus = this.getImage();
        if (imagePlus == null) {
            return;
        }
        int[] nArray = this.list.getSelectedIndexes();
        if (nArray.length == 1) {
            this.error("More than one item must be selected, or none");
            return;
        }
        if (nArray.length == 0) {
            nArray = this.getAllIndexes();
        }
        int n = 0;
        for (int i = 0; i < nArray.length && (roi = (Roi)this.rois.get(this.list.getItem(nArray[i]))).getType() == 10; ++i) {
            ++n;
        }
        if (n == nArray.length) {
            this.combinePoints(imagePlus, nArray);
        } else {
            this.combineRois(imagePlus, nArray);
        }
        if (this.record()) {
            Recorder.record("roiManager", "Combine");
        }
    }

    void combineRois(ImagePlus imagePlus, int[] nArray) {
        ShapeRoi shapeRoi = null;
        ShapeRoi shapeRoi2 = null;
        for (int i = 0; i < nArray.length; ++i) {
            Roi roi = (Roi)this.rois.get(this.list.getItem(nArray[i]));
            if (roi.isLine() || roi.getType() == 10) continue;
            Calibration calibration = imagePlus.getCalibration();
            if (calibration.xOrigin != 0.0 || calibration.yOrigin != 0.0) {
                roi = (Roi)roi.clone();
                Rectangle rectangle = roi.getBounds();
                roi.setLocation(rectangle.x + (int)calibration.xOrigin, rectangle.y + (int)calibration.yOrigin);
            }
            if (shapeRoi == null) {
                shapeRoi = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
                if (shapeRoi != null) continue;
                return;
            }
            shapeRoi2 = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
            if (shapeRoi2 == null || !roi.isArea()) continue;
            shapeRoi.or(shapeRoi2);
        }
        if (shapeRoi != null) {
            imagePlus.setRoi(shapeRoi);
        }
    }

    void combinePoints(ImagePlus imagePlus, int[] nArray) {
        Object object;
        int n = nArray.length;
        Polygon[] polygonArray = new Polygon[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            object = (Roi)this.rois.get(this.list.getItem(nArray[i]));
            polygonArray[i] = ((Roi)object).getPolygon();
            n2 += polygonArray[i].npoints;
        }
        if (n2 == 0) {
            return;
        }
        int[] nArray2 = new int[n2];
        object = new int[n2];
        int n3 = 0;
        for (int i = 0; i < polygonArray.length; ++i) {
            for (int j = 0; j < polygonArray[i].npoints; ++j) {
                nArray2[n3] = polygonArray[i].xpoints[j];
                object[n3] = polygonArray[i].ypoints[j];
                ++n3;
            }
        }
        imagePlus.setRoi(new PointRoi(nArray2, (int[])object, nArray2.length));
    }

    void and() {
        ImagePlus imagePlus = this.getImage();
        if (imagePlus == null) {
            return;
        }
        int[] nArray = this.list.getSelectedIndexes();
        if (nArray.length == 1) {
            this.error("More than one item must be selected, or none");
            return;
        }
        if (nArray.length == 0) {
            nArray = this.getAllIndexes();
        }
        ShapeRoi shapeRoi = null;
        ShapeRoi shapeRoi2 = null;
        for (int i = 0; i < nArray.length; ++i) {
            Roi roi = (Roi)this.rois.get(this.list.getItem(nArray[i]));
            if (!roi.isArea()) continue;
            if (shapeRoi == null) {
                shapeRoi = roi instanceof ShapeRoi ? (ShapeRoi)roi.clone() : new ShapeRoi(roi);
                if (shapeRoi != null) continue;
                return;
            }
            shapeRoi2 = roi instanceof ShapeRoi ? (ShapeRoi)roi.clone() : new ShapeRoi(roi);
            if (shapeRoi2 == null) continue;
            shapeRoi.and(shapeRoi2);
        }
        if (shapeRoi != null) {
            imagePlus.setRoi(shapeRoi);
        }
        if (this.record()) {
            Recorder.record("roiManager", "AND");
        }
    }

    void addParticles() {
        String string = IJ.runMacroFile("ij.jar:AddParticles", null);
        if (string != null && string.length() > 0) {
            this.error(string);
        }
    }

    void sort() {
        int n = this.rois.size();
        if (n == 0) {
            return;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        Enumeration enumeration = this.rois.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n2++] = (String)enumeration.nextElement();
        }
        this.list.removeAll();
        StringSorter.sort(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            this.list.add(stringArray[i]);
        }
        if (this.record()) {
            Recorder.record("roiManager", "Sort");
        }
    }

    void specify() {
        try {
            IJ.run("Specify...");
        }
        catch (Exception exception) {
            return;
        }
        this.runCommand("add");
    }

    void removeSliceInfo() {
        int[] nArray = this.list.getSelectedIndexes();
        if (nArray.length == 0) {
            nArray = this.getAllIndexes();
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            String string = this.list.getItem(n);
            int n2 = this.getSliceNumber(string);
            if (n2 == -1) continue;
            String string2 = string.substring(5, string.length());
            string2 = this.getUniqueName(string2);
            Roi roi = (Roi)this.rois.get(string);
            this.rois.remove(string);
            roi.setName(string2);
            this.rois.put(string2, roi);
            this.list.replaceItem(string2, n);
        }
    }

    void help() {
        String string = "run('URL...', 'url=http://imagej.nih.gov/ij/docs/menus/analyze.html#manager');";
        new MacroRunner(string);
    }

    void options() {
        Color color = ImageCanvas.getShowAllColor();
        GenericDialog genericDialog = new GenericDialog("Options");
        genericDialog.addPanel(this.makeButtonPanel(genericDialog), 10, new Insets(5, 0, 0, 0));
        genericDialog.addCheckbox("Associate \"Show All\" ROIs with Slices", Prefs.showAllSliceOnly);
        genericDialog.addCheckbox("Restore ROIs Centered", restoreCentered);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            if (color != ImageCanvas.getShowAllColor()) {
                ImageCanvas.setShowAllColor(color);
            }
            return;
        }
        Prefs.showAllSliceOnly = genericDialog.getNextBoolean();
        restoreCentered = genericDialog.getNextBoolean();
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            imagePlus.draw();
        }
        if (this.record()) {
            Recorder.record("roiManager", "Associate", Prefs.showAllSliceOnly ? "true" : "false");
            Recorder.record("roiManager", "Centered", restoreCentered ? "true" : "false");
        }
    }

    Panel makeButtonPanel(GenericDialog genericDialog) {
        Panel panel = new Panel();
        this.colorButton = new Button("\"Show All\" Color...");
        this.colorButton.addActionListener(this);
        panel.add(this.colorButton);
        return panel;
    }

    void setShowAllColor() {
        ColorChooser colorChooser = new ColorChooser("\"Show All\" Color", ImageCanvas.getShowAllColor(), false);
        ImageCanvas.setShowAllColor(colorChooser.getColor());
    }

    void split() {
        ImagePlus imagePlus = this.getImage();
        if (imagePlus == null) {
            return;
        }
        Roi roi = imagePlus.getRoi();
        if (roi == null || roi.getType() != 9) {
            this.error("Image with composite selection required");
            return;
        }
        boolean bl = Recorder.record;
        Recorder.record = false;
        Roi[] roiArray = ((ShapeRoi)roi).getRois();
        for (int i = 0; i < roiArray.length; ++i) {
            imagePlus.setRoi(roiArray[i]);
            this.addRoi(false);
        }
        Recorder.record = bl;
        if (this.record()) {
            Recorder.record("roiManager", "Split");
        }
    }

    void showAll(int n) {
        boolean bl;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            this.error("There are no images open.");
            return;
        }
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        if (imageCanvas == null) {
            return;
        }
        boolean bl2 = bl = n == 0;
        if (n == 2) {
            bl = true;
            if (this.record()) {
                Recorder.record("roiManager", "Show All with labels");
            }
        } else if (n == 3) {
            bl = true;
            if (this.record()) {
                Recorder.record("roiManager", "Show All without labels");
            }
        }
        if (bl) {
            imagePlus.killRoi();
        }
        imageCanvas.setShowAllROIs(bl);
        if (this.record()) {
            Recorder.record("roiManager", bl ? "Show All" : "Show None");
        }
        imagePlus.draw();
    }

    void updateShowAll() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            return;
        }
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        if (imageCanvas != null && imageCanvas.getShowAllROIs()) {
            imagePlus.draw();
        }
    }

    int[] getAllIndexes() {
        int n = this.list.getItemCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    ImagePlus getImage() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            this.error("There are no images open.");
            return null;
        }
        return imagePlus;
    }

    boolean error(String string) {
        new MessageDialog((Frame)this, "ROI Manager", string);
        Macro.abort();
        return false;
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            instance = null;
        }
        if (!IJ.isMacro()) {
            this.ignoreInterrupts = false;
        }
    }

    public static RoiManager getInstance() {
        return (RoiManager)instance;
    }

    public Hashtable getROIs() {
        return this.rois;
    }

    public List getList() {
        return this.list;
    }

    public int getCount() {
        return this.list.getItemCount();
    }

    public Roi[] getRoisAsArray() {
        int n = this.list.getItemCount();
        Roi[] roiArray = new Roi[n];
        for (int i = 0; i < n; ++i) {
            String string = this.list.getItem(i);
            roiArray[i] = (Roi)this.rois.get(string);
        }
        return roiArray;
    }

    public Roi[] getSelectedRoisAsArray() {
        int[] nArray = this.list.getSelectedIndexes();
        if (nArray.length == 0) {
            nArray = this.getAllIndexes();
        }
        int n = nArray.length;
        Roi[] roiArray = new Roi[n];
        for (int i = 0; i < n; ++i) {
            String string = this.list.getItem(nArray[i]);
            roiArray[i] = (Roi)this.rois.get(string);
        }
        return roiArray;
    }

    public static String getName(String string) {
        int n = (int)Tools.parseDouble(string, -1.0);
        RoiManager roiManager = RoiManager.getInstance();
        if (roiManager != null && n >= 0 && n < roiManager.list.getItemCount()) {
            return roiManager.list.getItem(n);
        }
        return "null";
    }

    public boolean runCommand(String string) {
        string = string.toLowerCase();
        this.macro = true;
        boolean bl = true;
        if (string.equals("add")) {
            boolean bl2 = IJ.shiftKeyDown();
            boolean bl3 = IJ.altKeyDown();
            if (Interpreter.isBatchMode()) {
                bl2 = false;
                bl3 = false;
            }
            this.add(bl2, bl3);
        } else if (string.equals("add & draw")) {
            this.addAndDraw(false);
        } else if (string.equals("update")) {
            this.update(true);
        } else if (string.equals("update2")) {
            this.update(false);
        } else if (string.equals("delete")) {
            this.delete(false);
        } else if (string.equals("measure")) {
            this.measure(1);
        } else if (string.equals("draw")) {
            this.drawOrFill(0);
        } else if (string.equals("fill")) {
            this.drawOrFill(1);
        } else if (string.equals("label")) {
            this.drawOrFill(2);
        } else if (string.equals("and")) {
            this.and();
        } else if (string.equals("or") || string.equals("combine")) {
            this.combine();
        } else if (string.equals("split")) {
            this.split();
        } else if (string.equals("sort")) {
            this.sort();
        } else if (string.startsWith("multi")) {
            this.multiMeasure();
        } else if (string.startsWith("show all")) {
            if (WindowManager.getCurrentImage() != null) {
                this.showAll(0);
                this.showAllCheckbox.setState(true);
            }
        } else if (string.startsWith("show none")) {
            if (WindowManager.getCurrentImage() != null) {
                this.showAll(1);
                this.showAllCheckbox.setState(false);
            }
        } else if (string.equals("show all with labels")) {
            this.labelsCheckbox.setState(true);
            this.showAll(2);
            if (Interpreter.isBatchMode()) {
                IJ.wait(250);
            }
        } else if (string.equals("show all without labels")) {
            this.labelsCheckbox.setState(false);
            this.showAll(3);
            if (Interpreter.isBatchMode()) {
                IJ.wait(250);
            }
        } else if (string.equals("deselect") || string.indexOf("all") != -1) {
            if (IJ.isMacOSX()) {
                this.ignoreInterrupts = true;
            }
            this.select(-1);
            IJ.wait(50);
        } else if (string.equals("reset")) {
            if (IJ.isMacOSX() && IJ.isMacro()) {
                this.ignoreInterrupts = true;
            }
            this.list.removeAll();
            this.rois.clear();
        } else if (!string.equals("debug")) {
            bl = false;
        }
        this.macro = false;
        return bl;
    }

    public boolean runCommand(String string, String string2) {
        string = string.toLowerCase();
        this.macro = true;
        if (string.equals("open")) {
            this.open(string2);
            this.macro = false;
            return true;
        }
        if (string.equals("save")) {
            if (!string2.endsWith(".zip") && !string2.equals("")) {
                return this.error("Name must end with '.zip'");
            }
            if (this.list.getItemCount() == 0) {
                return this.error("The selection list is empty.");
            }
            int[] nArray = this.getAllIndexes();
            boolean bl = false;
            bl = string2.equals("") ? this.saveMultiple(nArray, null) : this.saveMultiple(nArray, string2);
            this.macro = false;
            return bl;
        }
        if (string.equals("rename")) {
            this.rename(string2);
            this.macro = false;
            return true;
        }
        if (string.equals("set color")) {
            Color color = Colors.decode(string2, Color.cyan);
            this.setProperties(color, 0, null);
            this.macro = false;
            return true;
        }
        if (string.equals("set fill color")) {
            Color color = Colors.decode(string2, Color.cyan);
            this.setProperties(null, 0, color);
            this.macro = false;
            return true;
        }
        if (string.equals("set line width")) {
            int n = (int)Tools.parseDouble(string2, 0.0);
            if (n != 0) {
                this.setProperties(null, n, null);
            }
            this.macro = false;
            return true;
        }
        if (string.equals("associate")) {
            Prefs.showAllSliceOnly = string2.equals("true");
            this.macro = false;
            return true;
        }
        if (string.equals("centered")) {
            restoreCentered = string2.equals("true");
            this.macro = false;
            return true;
        }
        return false;
    }

    public boolean runCommand(String string, String string2, double d) {
        if (string2 == null && d == 1.0 && IJ.altKeyDown() && !Interpreter.isBatchMode()) {
            this.addRoi(true);
        } else {
            Color color = string2 != null ? Colors.decode(string2, Color.cyan) : null;
            this.addRoi(null, false, color, (int)Math.round(d));
        }
        return true;
    }

    public void select(int n) {
        this.select(null, n);
    }

    public void select(ImagePlus imagePlus, int n) {
        int n2 = this.list.getItemCount();
        if (n < 0) {
            for (int i = 0; i < n2; ++i) {
                if (!this.list.isSelected(i)) continue;
                this.list.deselect(i);
            }
            if (this.record()) {
                Recorder.record("roiManager", "Deselect");
            }
            return;
        }
        if (n >= n2) {
            return;
        }
        boolean bl = this.list.isMultipleMode();
        if (bl) {
            this.list.setMultipleMode(false);
        }
        int n3 = 1;
        long l = System.currentTimeMillis();
        while (true) {
            this.list.select(n);
            if (n3 > 1) {
                IJ.wait(n3);
            }
            if (this.list.isIndexSelected(n)) break;
            for (int i = 0; i < n2; ++i) {
                if (!this.list.isSelected(i)) continue;
                this.list.deselect(i);
            }
            IJ.wait(n3);
            if ((n3 *= 2) > 32) {
                n3 = 32;
            }
            if (System.currentTimeMillis() - l <= 1000L) continue;
            this.error("Failed to select ROI " + n);
        }
        if (imagePlus == null) {
            imagePlus = this.getImage();
        }
        this.restore(imagePlus, n, true);
        if (bl) {
            this.list.setMultipleMode(true);
        }
    }

    public void select(int n, boolean bl, boolean bl2) {
        ImagePlus imagePlus;
        if (!bl && !bl2) {
            this.select(n);
        }
        if ((imagePlus = IJ.getImage()) == null) {
            return;
        }
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            this.select(n);
            return;
        }
        Roi.previousRoi = (Roi)roi.clone();
        String string = this.list.getItem(n);
        Roi roi2 = (Roi)this.rois.get(string);
        if (roi2 != null) {
            roi2.setImage(imagePlus);
            roi2.update(bl, bl2);
        }
    }

    public void setEditMode(ImagePlus imagePlus, boolean bl) {
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        boolean bl2 = false;
        if (imageCanvas != null) {
            bl2 = imageCanvas.getShowAllROIs() | bl;
            imageCanvas.setShowAllROIs(bl2);
            imagePlus.draw();
        }
        this.showAllCheckbox.setState(bl2);
        this.labelsCheckbox.setState(bl);
    }

    public void close() {
        super.close();
        instance = null;
        Prefs.saveLocation(LOC_KEY, this.getLocation());
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (mouseEvent.isPopupTrigger() && mouseEvent.getButton() != 0 || mouseEvent.isMetaDown()) {
            this.pm.show(mouseEvent.getComponent(), n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        RoiManager roiManager = this;
        synchronized (roiManager) {
            int n = this.list.getSelectedIndex();
            int n2 = mouseWheelEvent.getWheelRotation();
            if (n2 < -1) {
                n2 = -1;
            }
            if (n2 > 1) {
                n2 = 1;
            }
            if ((n += n2) < 0) {
                n = 0;
            }
            if (n >= this.list.getItemCount()) {
                n = this.list.getItemCount();
            }
            this.select(n);
            if (IJ.isWindows()) {
                this.list.requestFocusInWindow();
            }
        }
    }

    private boolean record() {
        return Recorder.record && !IJ.isMacro();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    static {
        colorIndex = 4;
        measureAll = true;
        onePerSlice = true;
    }
}

