/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.simplets;

import ec.benchmarking.simplets.TsCholette;
import ec.benchmarking.ssf.multivariate.Constraint;
import ec.benchmarking.ssf.multivariate.ContemporaneousSsfCholette;
import ec.benchmarking.ssf.multivariate.ContemporaneousSsfDenton;
import ec.benchmarking.ssf.multivariate.MultivariateSsfCholette;
import ec.benchmarking.ssf.multivariate.MultivariateSsfDenton;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.ssf.DiffuseFilteringResults;
import ec.tstoolkit.ssf.DiffuseSquareRootInitializer;
import ec.tstoolkit.ssf.DisturbanceSmoother;
import ec.tstoolkit.ssf.Filter;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.SmoothingResults;
import ec.tstoolkit.ssf.multivariate.AbstractMultivariateSsf;
import ec.tstoolkit.ssf.multivariate.FullM2uMap;
import ec.tstoolkit.ssf.multivariate.M2uData;
import ec.tstoolkit.ssf.multivariate.M2uSsfAdapter;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataBlock;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.utilities.Comparator;
import ec.tstoolkit.utilities.Jdk6;
import ec.tstoolkit.utilities.WeightedItem;
import ec.tstoolkit.utilities.WildCards;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class TsMultiBenchmarking {
    private double rho_ = 0.0;
    private double lambda_ = 0.0;
    private final LinkedHashMap<String, String> tConstraints = new LinkedHashMap();
    private final ArrayList<ContemporaneousConstraintDescriptor> cConstraints = new ArrayList();
    private final LinkedHashMap<String, TsData> inputs = new LinkedHashMap();
    private final ArrayList<String> lcnt = new ArrayList();
    private final ArrayList<String> rcnt = new ArrayList();
    private double[][] lcntData;
    private double[][] rcntData;
    private double[][] weights;
    private final HashMap<String, TsData> tcntData = new HashMap();
    private final ArrayList<Constraint> cs = new ArrayList();
    private TsDomain idomain_;
    private TsFrequency tfreq_ = TsFrequency.Undefined;
    private final HashMap<String, TsData> bench_ = new HashMap();

    public boolean addInput(String name, TsData s) {
        if (this.inputs.containsKey(name)) {
            return false;
        }
        this.inputs.put(name, s);
        return true;
    }

    public boolean addContemporaneousConstraint(ContemporaneousConstraintDescriptor cnt) {
        if (!Jdk6.isNullOrEmpty(cnt.constraint) && !this.contains(cnt.constraint)) {
            return false;
        }
        if (cnt.hasWildCards()) {
            cnt = cnt.expand(this.inputs.keySet());
        }
        for (WeightedItem<String> ws : cnt.components) {
            if (this.contains((String)ws.item)) continue;
            return false;
        }
        this.cConstraints.add(cnt);
        this.clear();
        return true;
    }

    @Deprecated
    public boolean addTemporalConstraint(String agg, String detail) {
        return this.addTemporalConstraint(new TemporalConstraintDescriptor(agg, detail));
    }

    public boolean addTemporalConstraint(TemporalConstraintDescriptor cnt) {
        TsData sagg = this.inputs.get(cnt.aggregate);
        TsData sdetail = this.inputs.get(cnt.detail);
        if (sagg != null && sdetail != null) {
            this.tConstraints.put(cnt.detail, cnt.aggregate);
            if (sagg.getFrequency() != sdetail.getFrequency()) {
                if (this.tfreq_ == TsFrequency.Undefined) {
                    this.tfreq_ = sagg.getFrequency();
                } else if (this.tfreq_ != sagg.getFrequency()) {
                    return false;
                }
            }
            this.clear();
            return true;
        }
        return false;
    }

    public double getRho() {
        return this.rho_;
    }

    public void setRho(double value) {
        this.rho_ = value;
    }

    public double getLambda() {
        return this.lambda_;
    }

    public void setLambda(double lambda) {
        this.lambda_ = lambda;
    }

    public boolean contains(String s) {
        return this.inputs.containsKey(s);
    }

    public List<String> endogenous() {
        ArrayList<String> list = new ArrayList<String>();
        Set<String> bk = this.bench_.keySet();
        for (String s : this.inputs.keySet()) {
            if (!bk.contains(s)) continue;
            list.add(s);
        }
        return list;
    }

    public Set<String> input() {
        return this.inputs.keySet();
    }

    public TsData getInput(String s) {
        return this.inputs.get(s);
    }

    public TsData getResult(String s) {
        return this.bench_.get(s);
    }

    public boolean process() {
        if (this.cConstraints.isEmpty() && this.tConstraints.isEmpty()) {
            return false;
        }
        TsData[] bench = this.cConstraints.isEmpty() ? this.computeUnivariate() : (this.tConstraints.isEmpty() ? this.computeMultivariate() : this.compute());
        if (bench == null) {
            return false;
        }
        for (int i = 0; i < bench.length; ++i) {
            this.bench_.put(this.rcnt.get(i), bench[i]);
        }
        return true;
    }

    private TsData[] compute() {
        SmoothingResults states;
        int i;
        AbstractMultivariateSsf ssf;
        AbstractMultivariateSsf cssf;
        if (!this.buildMaps()) {
            return null;
        }
        this.benchmarkIndependentConstraints();
        if (!this.buildDomain()) {
            return null;
        }
        this.buildEndogeneousData();
        this.buildWeights();
        this.buildConstraints();
        int hfreq = this.idomain_.getFrequency().intValue();
        int lfreq = this.tfreq_.intValue();
        int c = hfreq / lfreq;
        if (this.rho_ < 1.0) {
            cssf = new MultivariateSsfCholette(c, this.rho_, this.weights);
            ((MultivariateSsfCholette)cssf).setConstraints(this.cs);
            ssf = cssf;
        } else {
            cssf = new MultivariateSsfDenton(c, this.weights);
            ((MultivariateSsfDenton)cssf).setConstraints(this.cs);
            ssf = cssf;
        }
        FullM2uMap map = new FullM2uMap(this.rcnt.size() + this.cs.size());
        M2uSsfAdapter adapter = new M2uSsfAdapter(ssf, map);
        int len = this.idomain_.getLength();
        int nvars = this.rcnt.size();
        int ncnts = this.cs.size();
        Matrix M = new Matrix(nvars + ncnts, len);
        M.set(Double.NaN);
        for (i = 0; i < nvars; ++i) {
            if (!this.tConstraints.containsKey(this.rcnt.get(i))) continue;
            TsData a = this.tcntData.get(this.rcnt.get(i));
            DataBlock b = M.row(i).extract(c - 1, a.getLength(), c);
            b.copy(a);
        }
        for (i = 0; i < ncnts; ++i) {
            DataBlock row = M.row(i + nvars);
            row.copyFrom(this.lcntData[i], 0);
        }
        DisturbanceSmoother dsmoother = new DisturbanceSmoother();
        dsmoother.setSsf(adapter);
        M2uData data = new M2uData(M, null);
        if (adapter.isDiffuse()) {
            Filter<ISsf> filter = new Filter<ISsf>();
            filter.setInitializer(new DiffuseSquareRootInitializer());
            filter.setSsf(adapter);
            DiffuseFilteringResults frslts = new DiffuseFilteringResults(true);
            frslts.getFilteredData().setSavingA(data.hasData());
            frslts.getVarianceFilter().setSavingP(false);
            filter.process(data, frslts);
            dsmoother.process(data, frslts);
            states = dsmoother.calcSmoothedStates();
        } else {
            dsmoother.process(data);
            states = dsmoother.calcSmoothedStates();
        }
        int neq = nvars + ncnts;
        TsData[] y = new TsData[this.rcnt.size()];
        for (int i2 = 0; i2 < y.length; ++i2) {
            TsData s = this.getInput(this.rcnt.get(i2));
            TsDataBlock sc = TsDataBlock.select(s, this.idomain_);
            y[i2] = new TsData(this.idomain_);
            double[] t = states.component(2 * i2 + 1);
            for (int j = 0; j < s.getLength(); ++j) {
                y[i2].set(j, sc.data.get(j) + t[j * neq] * this.weights[i2][j]);
            }
        }
        return y;
    }

    private void clear() {
        if (this.bench_.isEmpty()) {
            return;
        }
        this.lcnt.clear();
        this.rcnt.clear();
        this.lcntData = null;
        this.rcntData = null;
        this.weights = null;
        this.tcntData.clear();
        this.cs.clear();
        this.idomain_ = null;
        this.tfreq_ = TsFrequency.Undefined;
        this.bench_.clear();
    }

    private boolean hasTemporalConstraint(ContemporaneousConstraintDescriptor cnt) {
        for (WeightedItem<String> ws : cnt.components) {
            if (this.tConstraints.containsKey(ws.item)) continue;
            return false;
        }
        return true;
    }

    private TsData[] computeUnivariate() {
        ArrayList<TsData> bench = new ArrayList<TsData>();
        TsCholette cholette = new TsCholette();
        cholette.setRho(this.rho_);
        cholette.setLambda(this.lambda_);
        for (Map.Entry<String, String> cur : this.tConstraints.entrySet()) {
            TsData b;
            TsData q = this.getInput(cur.getKey());
            TsData a = this.getInput(cur.getValue());
            if (a == null || q == null) continue;
            if (a.getFrequency() == q.getFrequency()) {
                a = a.changeFrequency(TsFrequency.Yearly, TsAggregationType.Sum, true);
            }
            if ((b = cholette.process(q, a)) == null) continue;
            bench.add(b);
            this.rcnt.add(cur.getKey());
        }
        TsData[] r = new TsData[bench.size()];
        bench.toArray(r);
        return r;
    }

    private boolean buildMaps() {
        ContemporaneousConstraintDescriptor desc;
        int i;
        for (i = 0; i < this.cConstraints.size(); ++i) {
            desc = this.cConstraints.get(i);
            if (!Jdk6.isNullOrEmpty(desc.constraint)) {
                if (this.rcnt.contains(desc.constraint)) {
                    return false;
                }
                if (!this.lcnt.contains(desc.constraint)) {
                    this.lcnt.add(desc.constraint);
                }
            }
            for (WeightedItem<String> weightedItem : desc.components) {
                if (this.lcnt.contains(weightedItem.item)) {
                    return false;
                }
                if (this.rcnt.contains(weightedItem.item)) continue;
                this.rcnt.add((String)weightedItem.item);
            }
        }
        for (i = 0; i < this.cConstraints.size(); ++i) {
            desc = this.cConstraints.get(i);
            HashMap<Integer, Double> constraint = new HashMap<Integer, Double>();
            for (WeightedItem<String> weightedItem : desc.components) {
                constraint.put(this.rcnt.indexOf(weightedItem.item), weightedItem.weight);
            }
            Constraint constraint2 = new Constraint(constraint);
            this.cs.add(constraint2);
        }
        this.lcntData = new double[this.cConstraints.size()][];
        for (i = 0; i < this.cConstraints.size(); ++i) {
            desc = this.cConstraints.get(i);
            if (!Jdk6.isNullOrEmpty(desc.constraint)) {
                TsData s = this.getInput(desc.constraint);
                this.lcntData[i] = (double[])s.internalStorage().clone();
                continue;
            }
            this.lcntData[i] = new double[]{desc.constant};
        }
        return true;
    }

    private void benchmarkIndependentConstraints() {
        if (this.tfreq_ == TsFrequency.Undefined) {
            this.tfreq_ = TsFrequency.Yearly;
        }
        TsCholette cholette = new TsCholette();
        cholette.setRho(this.rho_);
        cholette.setLambda(this.lambda_);
        for (String s : this.tConstraints.keySet()) {
            TsData b;
            if (this.rcnt.contains(s)) continue;
            TsData q = this.getInput(s);
            TsData a = this.getInput(this.tConstraints.get(s));
            if (a == null || q == null) continue;
            if (a.getFrequency() == q.getFrequency()) {
                a = a.changeFrequency(this.tfreq_, TsAggregationType.Sum, true);
            }
            if ((b = cholette.process(q, a)) == null) continue;
            this.bench_.put(s, b);
        }
    }

    private boolean buildDomain() {
        for (String cur : this.rcnt) {
            TsDomain d = this.getInput(cur).getDomain();
            if (this.idomain_ == null) {
                this.idomain_ = d;
                continue;
            }
            if (this.idomain_.getFrequency() != d.getFrequency()) {
                return false;
            }
            this.idomain_ = this.idomain_.intersection(d);
        }
        return !this.idomain_.isEmpty();
    }

    private void buildEndogeneousData() {
        this.rcntData = new double[this.rcnt.size()][];
        for (int i = 0; i < this.rcnt.size(); ++i) {
            TsData s = this.getInput(this.rcnt.get(i)).fittoDomain(this.idomain_);
            this.rcntData[i] = s.internalStorage();
        }
    }

    private void buildWeights() {
        this.weights = new double[this.rcntData.length][];
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = this.calcWeights(this.rcntData[i]);
        }
    }

    private void buildConstraints() {
        this.buildContemporaneousConstraints();
        this.buildTemporalConstraints();
    }

    private void buildContemporaneousConstraints() {
        for (int i = 0; i < this.cs.size(); ++i) {
            DataBlock z;
            Constraint cur = this.cs.get(i);
            if (this.lcntData[i].length == 1) {
                z = new DataBlock(this.idomain_.getLength());
                z.set(this.lcntData[i][0]);
                this.lcntData[i] = z.getData();
            } else {
                z = new DataBlock(this.lcntData[i]);
            }
            for (int j = 0; j < cur.index.length; ++j) {
                z.addAY(-cur.weights[j], new DataBlock(this.rcntData[cur.index[j]]));
            }
        }
    }

    private void buildTemporalConstraints() {
        TsDomain tdom = this.idomain_.changeFrequency(this.tfreq_, true);
        for (int i = 0; i < this.rcnt.size(); ++i) {
            String n = this.rcnt.get(i);
            if (!this.tConstraints.containsKey(n)) continue;
            TsData orig = this.getInput(this.rcnt.get(i));
            TsData cur = this.getInput(this.tConstraints.get(this.rcnt.get(i)));
            if (cur.getFrequency() == orig.getFrequency()) {
                cur = cur.changeFrequency(this.tfreq_, TsAggregationType.Sum, true);
            }
            TsData a = orig.changeFrequency(TsFrequency.Yearly, TsAggregationType.Sum, true);
            a = cur.minus(a);
            a = a.fittoDomain(tdom);
            this.tcntData.put(n, a);
        }
    }

    private TsData[] computeMultivariate() {
        SmoothingResults states;
        AbstractMultivariateSsf ssf;
        AbstractMultivariateSsf cssf;
        if (!this.buildMaps()) {
            return null;
        }
        if (!this.buildDomain()) {
            return null;
        }
        this.buildEndogeneousData();
        this.buildWeights();
        this.buildContemporaneousConstraints();
        if (this.rho_ < 1.0) {
            cssf = new ContemporaneousSsfCholette(this.rho_, this.weights);
            ((ContemporaneousSsfCholette)cssf).setConstraints(this.cs);
            ssf = cssf;
        } else {
            cssf = new ContemporaneousSsfDenton(this.weights);
            ((ContemporaneousSsfDenton)cssf).setConstraints(this.cs);
            ssf = cssf;
        }
        FullM2uMap map = new FullM2uMap(this.cs.size());
        M2uSsfAdapter adapter = new M2uSsfAdapter(ssf, map);
        M2uData data = new M2uData(this.lcntData, null);
        DisturbanceSmoother dsmoother = new DisturbanceSmoother();
        dsmoother.setSsf(adapter);
        if (adapter.isDiffuse()) {
            Filter<ISsf> filter = new Filter<ISsf>();
            filter.setInitializer(new DiffuseSquareRootInitializer());
            filter.setSsf(adapter);
            DiffuseFilteringResults frslts = new DiffuseFilteringResults(true);
            frslts.getFilteredData().setSavingA(data.hasData());
            frslts.getVarianceFilter().setSavingP(false);
            filter.process(data, frslts);
            dsmoother.process(data, frslts);
            states = dsmoother.calcSmoothedStates();
        } else {
            dsmoother.process(data);
            states = dsmoother.calcSmoothedStates();
        }
        int neq = this.cs.size();
        TsData[] y = new TsData[this.rcnt.size()];
        for (int i = 0; i < y.length; ++i) {
            TsData s = this.getInput(this.rcnt.get(i));
            y[i] = new TsData(s.getDomain());
            double[] t = states.component(i);
            for (int j = 0; j < s.getLength(); ++j) {
                y[i].set(j, t[j * neq] * this.weights[i][j]);
            }
            y[i] = TsData.add(y[i], s);
        }
        return y;
    }

    private double[] calcWeights(double[] x) {
        if (this.lambda_ == 1.0) {
            return x;
        }
        double[] w = new double[x.length];
        if (this.lambda_ == 0.0) {
            for (int i = 0; i < w.length; ++i) {
                w[i] = 1.0;
            }
        } else if (this.lambda_ == 0.5) {
            for (int i = 0; i < w.length; ++i) {
                w[i] = Math.sqrt(Math.abs(x[i]));
            }
        } else {
            for (int i = 0; i < w.length; ++i) {
                w[i] = Math.pow(Math.abs(x[i]), this.lambda_);
            }
        }
        return w;
    }

    public static final class TemporalConstraintDescriptor {
        public final String aggregate;
        public final String detail;

        public TemporalConstraintDescriptor(String constraint, String component) {
            this.aggregate = constraint;
            this.detail = component;
        }

        public static TemporalConstraintDescriptor parse(String s) {
            try {
                String n;
                Scanner scanner = new Scanner(s).useDelimiter("\\s*=\\s*");
                String cnt = n = scanner.next();
                n = scanner.next();
                String[] fn = TemporalConstraintDescriptor.function(n);
                if (fn == null) {
                    return null;
                }
                if (!fn[0].equalsIgnoreCase("sum")) {
                    return null;
                }
                String cmp = fn[1];
                return new TemporalConstraintDescriptor(cnt, cmp);
            }
            catch (Exception err) {
                return null;
            }
        }

        public static String[] function(String str) {
            try {
                String s = str.trim();
                int a0 = s.indexOf(40, 0);
                if (a0 <= 0) {
                    return null;
                }
                int a1 = s.indexOf(40, a0 + 1);
                if (a1 >= 0) {
                    return null;
                }
                a1 = s.indexOf(41, a0 + 1);
                if (a1 != s.length() - 1) {
                    return null;
                }
                return new String[]{s.substring(0, a0), s.substring(a0 + 1, a1)};
            }
            catch (Exception err) {
                return null;
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.aggregate).append("=sum(").append(this.detail).append(')');
            return builder.toString();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof TemporalConstraintDescriptor && this.equals((TemporalConstraintDescriptor)obj);
        }

        public int hashCode() {
            int hash = 5;
            hash = 67 * hash + this.aggregate.hashCode();
            hash = 67 * hash + this.detail.hashCode();
            return hash;
        }

        public boolean equals(TemporalConstraintDescriptor c) {
            return this.aggregate.equals(c.aggregate) && this.detail.equals(c.detail);
        }
    }

    public static final class ContemporaneousConstraintDescriptor {
        public final double constant;
        public final String constraint;
        public final List<WeightedItem<String>> components = new ArrayList<WeightedItem<String>>();

        public ContemporaneousConstraintDescriptor(double cnt) {
            this.constant = cnt;
            this.constraint = null;
        }

        public ContemporaneousConstraintDescriptor(String cnt) {
            this.constant = 0.0;
            this.constraint = cnt;
        }

        private ContemporaneousConstraintDescriptor(double d, String s) {
            this.constant = d;
            this.constraint = s;
        }

        public void add(String cmp, double w) {
            this.components.add(new WeightedItem<String>(cmp, w));
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof ContemporaneousConstraintDescriptor && this.equals((ContemporaneousConstraintDescriptor)obj);
        }

        public int hashCode() {
            int hash = 5;
            hash = 23 * hash + (int)(Double.doubleToLongBits(this.constant) ^ Double.doubleToLongBits(this.constant) >>> 32);
            hash = 23 * hash + (this.constraint != null ? this.constraint.hashCode() : 0);
            return hash;
        }

        public boolean equals(ContemporaneousConstraintDescriptor c) {
            if (!this.constraint.equals(c.constraint)) {
                return false;
            }
            if (this.constant != c.constant) {
                return false;
            }
            return Comparator.equals(this.components, c.components);
        }

        public boolean hasWildCards() {
            for (WeightedItem<String> ws : this.components) {
                if (!((String)ws.item).contains("?") && !((String)ws.item).contains("*")) continue;
                return true;
            }
            return false;
        }

        public ContemporaneousConstraintDescriptor expand(Collection<String> input) {
            ContemporaneousConstraintDescriptor ndesc = new ContemporaneousConstraintDescriptor(this.constant, this.constraint);
            for (WeightedItem<String> ws : this.components) {
                double w = ws.weight;
                if (((String)ws.item).contains("*") || ((String)ws.item).contains("?")) {
                    WildCards wc = new WildCards((String)ws.item);
                    for (String i : input) {
                        if (i.equals(this.constraint) || !wc.match(i)) continue;
                        ndesc.components.add(new WeightedItem<String>(i, w));
                    }
                    continue;
                }
                ndesc.components.add(ws);
            }
            return ndesc;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.constraint != null) {
                builder.append(this.constraint);
            } else {
                builder.append(this.constant);
            }
            builder.append('=');
            boolean first = true;
            for (WeightedItem<String> ws : this.components) {
                double w = ws.weight;
                if (w == 0.0) continue;
                double aw = Math.abs(w);
                if (w < 0.0) {
                    builder.append('-');
                } else if (!first) {
                    builder.append('+');
                }
                if (aw != 1.0) {
                    builder.append(aw).append('*');
                }
                builder.append((String)ws.item);
                first = false;
            }
            return builder.toString();
        }

        public static ContemporaneousConstraintDescriptor parse(String s) {
            try {
                Scanner scanner = new Scanner(s).useDelimiter("\\s*=\\s*");
                String n = scanner.next();
                double dcnt = 0.0;
                String scnt = null;
                try {
                    dcnt = Double.parseDouble(n);
                }
                catch (NumberFormatException err) {
                    scnt = n;
                }
                n = scanner.next();
                ContemporaneousConstraintDescriptor desc = new ContemporaneousConstraintDescriptor(dcnt, scnt);
                if (!ContemporaneousConstraintDescriptor.parseComponents(n, desc.components)) {
                    return null;
                }
                return desc;
            }
            catch (Exception err) {
                return null;
            }
        }

        private static boolean parseComponents(String str, List<WeightedItem<String>> cmps) {
            int pos = 0;
            int ppos = 0;
            int mpos = 0;
            while (pos < str.length()) {
                String cmp;
                String cur;
                int wpos;
                char c;
                boolean plus;
                int npos;
                if (Character.isWhitespace(str.charAt(pos))) {
                    ++pos;
                    continue;
                }
                if (ppos >= 0) {
                    ppos = str.indexOf(43, pos + 1);
                }
                if (mpos >= 0) {
                    mpos = str.indexOf(45, pos + 1);
                }
                if ((npos = ppos < 0 ? mpos : (mpos < 0 ? ppos : Math.min(ppos, mpos))) < 0) {
                    npos = str.length();
                }
                boolean bl = plus = (c = str.charAt(pos)) != '-';
                if (c == '-' || c == '+') {
                    ++pos;
                }
                if ((wpos = (cur = str.substring(pos, npos)).indexOf(42)) < 0) {
                    cmp = cur.trim();
                    cmps.add(new WeightedItem<String>(cmp, plus ? 1.0 : -1.0));
                } else {
                    cmp = cur.substring(wpos + 1).trim();
                    try {
                        double w = Double.parseDouble(cur.substring(0, wpos));
                        cmps.add(new WeightedItem<String>(cmp, plus ? w : -w));
                    }
                    catch (NumberFormatException err) {
                        return false;
                    }
                }
                pos = npos;
            }
            return true;
        }
    }
}

