/*
 * Decompiled with CFR 0.152.
 */
package demetra.workspace.io;

import demetra.workspace.io.IO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class Xml {
    private Xml() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class WrappedException
    extends IOException {
        public WrappedException(Exception ex) {
            super(ex);
        }
    }

    public static interface Parser<T> {
        @Nonnull
        default public T parseChars(@Nonnull CharSequence source) throws IOException {
            return this.parseReader(() -> new StringReader(source.toString()));
        }

        @Nonnull
        default public T parseFile(@Nonnull File source) throws IOException {
            return this.parseStream(() -> new FileInputStream(source));
        }

        @Nonnull
        default public T parsePath(@Nonnull Path source) throws IOException {
            Optional<File> file = IO.getFile(source);
            return file.isPresent() ? this.parseFile(file.get()) : this.parseReader(() -> Files.newBufferedReader(source));
        }

        @Nonnull
        default public T parseReader(@Nonnull IO.Supplier<? extends Reader> source) throws IOException {
            try (Reader resource = source.getWithIO();){
                T t = this.parseReader(resource);
                return t;
            }
        }

        @Nonnull
        default public T parseStream(@Nonnull IO.Supplier<? extends InputStream> source) throws IOException {
            try (InputStream resource = source.getWithIO();){
                T t = this.parseStream(resource);
                return t;
            }
        }

        @Nonnull
        public T parseReader(@Nonnull Reader var1) throws IOException;

        @Nonnull
        public T parseStream(@Nonnull InputStream var1) throws IOException;
    }
}

