/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.DiffuseFilteringResults;
import ec.tstoolkit.ssf.DiffuseSquareRootInitializer;
import ec.tstoolkit.ssf.DiffuseVarianceFilter;
import ec.tstoolkit.ssf.Filter;
import ec.tstoolkit.ssf.FilteredData;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.ssf.arima.SsfArima;
import java.util.List;

public class Forecasts {
    double[] ef_;
    double[] f_;
    int nf_ = 0;

    public int getForecastsCount() {
        return this.nf_;
    }

    public double[] getForecasts() {
        return this.f_;
    }

    public double forecast(int idx) {
        return this.f_[idx];
    }

    public double forecastStdev(int idx) {
        return this.ef_[idx];
    }

    public double[] getForecastStdevs() {
        return this.ef_;
    }

    Forecasts(int nf) {
        this.nf_ = nf;
        this.f_ = new double[nf];
        this.ef_ = new double[nf];
    }

    public Forecasts() {
    }

    public <M extends IArimaModel> void calcForecast(RegArimaEstimation<M> gls, List<DataBlock> x, int fHorizon, int nhp) {
        int i;
        int i2;
        int nx;
        DataBlock y = gls.model.getY();
        Object arima = gls.model.getArima();
        int nd = arima.getNonStationaryARCount();
        int[] missings = gls.model.getMissings();
        if (!this.checkMissings(missings, nd)) {
            this.calcForecast2(gls, x, fHorizon, nhp);
            return;
        }
        int n = nx = x == null ? 0 : x.size();
        if (gls.model.isMeanCorrection()) {
            ++nx;
        }
        this.nf_ = fHorizon;
        if (this.nf_ <= 0) {
            this.ef_ = new double[0];
            this.f_ = new double[0];
            return;
        }
        this.ef_ = new double[this.nf_];
        this.f_ = new double[this.nf_];
        int n2 = gls.model.getObsCount();
        SsfArima ssf = new SsfArima((IArimaModel)arima);
        Filter<SsfArima> filter = new Filter<SsfArima>();
        SsfArima.Initializer initializer = new SsfArima.Initializer();
        DiffuseFilteringResults frslts = new DiffuseFilteringResults(true);
        filter.setSsf(ssf);
        filter.setInitializer(initializer);
        frslts.getFilteredData().setSavingA(true);
        double[] yc = new double[n2 + this.nf_];
        y.copyTo(yc, 0);
        for (i2 = n2; i2 < yc.length; ++i2) {
            yc[i2] = Double.NaN;
        }
        if (missings != null) {
            for (i2 = 0; i2 < gls.model.getMissingsCount(); ++i2) {
                yc[missings[i2]] = Double.NaN;
            }
        }
        SsfData ssfy = new SsfData(yc, null);
        filter.process(ssfy, frslts);
        DiffuseVarianceFilter vfilter = frslts.getVarianceFilter();
        FilteredData fdata = frslts.getFilteredData();
        double mvar = gls.likelihood.getSsqErr() / (double)gls.likelihood.getDegreesOfFreedom(true, nhp);
        for (i = 0; i < this.nf_; ++i) {
            this.f_[i] = fdata.A(n2 + i).get(0);
            this.ef_[i] = vfilter.F(n2 + i) * mvar;
        }
        if (nx > 0) {
            int pos = ssf.getNonStationaryDim();
            double[] a0 = new double[ssf.getStateDim()];
            int icur = 0;
            int mcur = 0;
            int[] idx = new int[nx];
            if (gls.model.isMeanCorrection()) {
                idx[icur++] = mcur++;
            }
            mcur += gls.model.getMissingsCount();
            for (int i3 = 0; i3 < gls.model.getXCount(); ++i3) {
                idx[icur++] = mcur++;
            }
            double[] c = new double[nx];
            Matrix v = new Matrix(nx, nx);
            double[] b = gls.likelihood.getB();
            Matrix V = gls.likelihood.getBVar(true, nhp);
            for (int i4 = 0; i4 < nx; ++i4) {
                c[i4] = b[idx[i4]];
                for (int j = 0; j < nx; ++j) {
                    v.set(i4, j, V.get(idx[i4], idx[j]));
                }
            }
            Matrix xe = new Matrix(this.nf_, nx);
            int ix = 0;
            for (int i5 = 0; i5 < nx; ++i5) {
                double[] xcur;
                if (i5 == 0 && gls.model.isMeanCorrection()) {
                    xcur = gls.model.calcMeanReg(n2 + this.nf_);
                } else {
                    gls.model.X(ix).copyTo(yc, 0);
                    x.get(ix++).copyTo(yc, n2);
                    xcur = yc;
                }
                SsfData ssfx = new SsfData(xcur, null);
                initializer.calcInitialState(ssf, new DataBlock(a0), ssfx);
                vfilter.process(fdata, pos, xcur, a0);
                for (int j = 0; j < this.nf_; ++j) {
                    xe.set(j, i5, fdata.E(n2 + j));
                }
            }
            DataBlock C = new DataBlock(c);
            DataBlockIterator xrows = xe.rows();
            DataBlock xrow = xrows.getData();
            do {
                int n3 = xrows.getPosition();
                this.f_[n3] = this.f_[n3] + xrow.dot(C);
                int n4 = xrows.getPosition();
                this.ef_[n4] = this.ef_[n4] + SymmetricMatrix.quadraticForm(v, xrow);
            } while (xrows.next());
        }
        for (i = 0; i < this.ef_.length; ++i) {
            this.ef_[i] = Math.sqrt(this.ef_[i]);
        }
    }

    public <M extends IArimaModel> void calcForecast2(RegArimaEstimation<M> gls, List<DataBlock> x, int fHorizon, int nhp) {
        int i;
        int nx;
        DataBlock y = gls.model.getY();
        Object arima = gls.model.getArima();
        int n = nx = x == null ? 0 : x.size();
        if (gls.model.isMeanCorrection()) {
            ++nx;
        }
        this.nf_ = fHorizon;
        if (this.nf_ <= 0) {
            this.ef_ = new double[0];
            this.f_ = new double[0];
            return;
        }
        this.ef_ = new double[this.nf_];
        this.f_ = new double[this.nf_];
        int n2 = gls.model.getObsCount();
        SsfArima ssf = new SsfArima((IArimaModel)arima);
        Filter<ISsf> filter = new Filter<ISsf>();
        filter.setSsf(ssf);
        DiffuseSquareRootInitializer initializer = new DiffuseSquareRootInitializer();
        filter.setInitializer(initializer);
        DiffuseFilteringResults frslts = new DiffuseFilteringResults(true);
        frslts.getFilteredData().setSavingA(true);
        double[] yc = new double[n2 + this.nf_];
        y.copyTo(yc, 0);
        for (int i2 = n2; i2 < yc.length; ++i2) {
            yc[i2] = Double.NaN;
        }
        int[] missings = gls.model.getMissings();
        if (missings != null) {
            for (int i3 = 0; i3 < gls.model.getMissingsCount(); ++i3) {
                yc[missings[i3]] = Double.NaN;
            }
        }
        SsfData ssfy = new SsfData(yc, null);
        filter.process(ssfy, frslts);
        DiffuseVarianceFilter vfilter = frslts.getVarianceFilter();
        FilteredData fdata = frslts.getFilteredData();
        double mvar = gls.likelihood.getSsqErr() / (double)gls.likelihood.getDegreesOfFreedom(true, nhp);
        for (i = 0; i < this.nf_; ++i) {
            this.f_[i] = fdata.A(n2 + i).get(0);
            this.ef_[i] = vfilter.F(n2 + i) * mvar;
        }
        if (nx > 0) {
            int pos = ssf.getNonStationaryDim();
            double[] a0 = new double[ssf.getStateDim()];
            int icur = 0;
            int mcur = 0;
            int[] idx = new int[nx];
            if (gls.model.isMeanCorrection()) {
                idx[icur++] = mcur++;
            }
            mcur += gls.model.getMissingsCount();
            for (int i4 = 0; i4 < gls.model.getXCount(); ++i4) {
                idx[icur++] = mcur++;
            }
            double[] c = new double[nx];
            Matrix v = new Matrix(nx, nx);
            double[] b = gls.likelihood.getB();
            Matrix V = gls.likelihood.getBVar(true, nhp);
            for (int i5 = 0; i5 < nx; ++i5) {
                c[i5] = b[idx[i5]];
                for (int j = 0; j < nx; ++j) {
                    v.set(i5, j, V.get(idx[i5], idx[j]));
                }
            }
            Matrix xe = new Matrix(this.nf_, nx);
            int ix = 0;
            for (int i6 = 0; i6 < nx; ++i6) {
                double[] xcur;
                if (i6 == 0 && gls.model.isMeanCorrection()) {
                    xcur = gls.model.calcMeanReg(n2 + this.nf_);
                } else {
                    gls.model.X(ix).copyTo(yc, 0);
                    x.get(ix++).copyTo(yc, n2);
                    xcur = yc;
                }
                vfilter.process(fdata, 0, xcur, a0);
                for (int j = 0; j < this.nf_; ++j) {
                    xe.set(j, i6, fdata.E(n2 + j));
                }
            }
            DataBlock C = new DataBlock(c);
            DataBlockIterator xrows = xe.rows();
            DataBlock xrow = xrows.getData();
            do {
                int n3 = xrows.getPosition();
                this.f_[n3] = this.f_[n3] + xrow.dot(C);
                int n4 = xrows.getPosition();
                this.ef_[n4] = this.ef_[n4] + SymmetricMatrix.quadraticForm(v, xrow);
            } while (xrows.next());
        }
        for (i = 0; i < this.ef_.length; ++i) {
            this.ef_[i] = Math.sqrt(this.ef_[i]);
        }
    }

    private boolean checkMissings(int[] missings, int nd) {
        if (missings == null) {
            return true;
        }
        for (int i = 0; i < missings.length; ++i) {
            if (missings[i] >= nd) continue;
            return false;
        }
        return true;
    }
}

