/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.IPeriod;
import ec.tstoolkit.timeseries.Month;
import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;

public class TsPeriod
implements Serializable,
Cloneable,
IPeriod,
Comparable<TsPeriod> {
    private static final long serialVersionUID = 7847770315060071968L;
    private static final String[] g_sm = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private final TsFrequency m_freq;
    private int m_id;

    public static String formatPeriod(TsFrequency freq, int pos) {
        if (freq == TsFrequency.Monthly) {
            return Month.valueOf(pos).toString();
        }
        if (freq == TsFrequency.Yearly || freq == TsFrequency.Undefined) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        switch (freq) {
            case Quarterly: {
                builder.append('Q');
                break;
            }
            case HalfYearly: {
                builder.append('H');
                break;
            }
            default: {
                builder.append('P');
            }
        }
        builder.append(pos + 1);
        return builder.toString();
    }

    public static String formatShortPeriod(TsFrequency freq, int pos) {
        if (freq == TsFrequency.Monthly) {
            return g_sm[pos];
        }
        return TsPeriod.formatPeriod(freq, pos);
    }

    public TsPeriod(TsFrequency frequency) {
        this.m_freq = frequency;
    }

    public TsPeriod(TsFrequency frequency, Date date) {
        this.m_freq = frequency;
        this.set(date);
    }

    public TsPeriod(TsFrequency frequency, Day day) {
        this.m_freq = frequency;
        this.set(day);
    }

    public static TsPeriod year(int y) {
        return new TsPeriod(TsFrequency.Yearly, y, 0);
    }

    TsPeriod(TsFrequency frequency, int id) {
        this.m_freq = frequency;
        this.m_id = id;
    }

    public TsPeriod(TsFrequency frequency, int year, int position) {
        this.m_freq = frequency;
        this.set(year, position);
    }

    public TsPeriod(TsFrequency frequency, TsPeriod p) {
        int freq = frequency.intValue();
        int pfreq = p.m_freq.intValue();
        if (pfreq % freq != 0) {
            throw new TsException("Incompatible frequencies");
        }
        this.m_freq = frequency;
        int q = p.m_id * freq;
        this.m_id = q / pfreq;
        if (q < 0 && q % pfreq != 0) {
            --this.m_id;
        }
    }

    public TsPeriod clone() {
        try {
            TsPeriod period = (TsPeriod)super.clone();
            return period;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    @Override
    public int compareTo(TsPeriod other) {
        if (other.m_freq == this.m_freq) {
            if (this.m_id == other.m_id) {
                return 0;
            }
            if (this.m_id < other.m_id) {
                return -1;
            }
            return 1;
        }
        throw new TsException("Incompatible frequencies");
    }

    private boolean contains(long timeInMillis) {
        return CalendarUtil.getInstance().calcTsPeriodId(this.m_freq, timeInMillis) == this.m_id;
    }

    @Override
    public boolean contains(Date dt) {
        return this.contains(dt.getTime());
    }

    public boolean contains(Day day) {
        return this.contains(day.getTimeInMillis());
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TsPeriod && this.equals((TsPeriod)obj);
    }

    public boolean equals(TsPeriod other) {
        return this.m_freq == other.m_freq && this.m_id == other.m_id;
    }

    @Override
    public Day firstday() {
        int ifreq = this.m_freq.intValue();
        int c = 12 / ifreq;
        return new Day(this.getYear(), Month.valueOf(this.getPosition() * c), 0);
    }

    public TsFrequency getFrequency() {
        return this.m_freq;
    }

    public TsPeriod lastPeriod(TsFrequency freq) {
        if (freq == this.m_freq) {
            return this;
        }
        int c = freq.ratio(this.m_freq);
        return new TsPeriod(freq, this.m_id * c + c - 1);
    }

    public TsPeriod firstPeriod(TsFrequency freq) {
        if (freq == this.m_freq) {
            return this;
        }
        int c = freq.ratio(this.m_freq);
        return new TsPeriod(freq, this.m_id * c);
    }

    public String getPeriodString() {
        return TsPeriod.formatPeriod(this.m_freq, this.getPosition());
    }

    public int getPosition() {
        int ifreq = this.m_freq.intValue();
        if (this.m_id >= 0) {
            return this.m_id % ifreq;
        }
        return ifreq - 1 + (1 + this.m_id) % ifreq;
    }

    public int getYear() {
        if (this.m_id >= 0) {
            return 1970 + this.m_id / this.m_freq.intValue();
        }
        return 1969 + (1 + this.m_id) / this.m_freq.intValue();
    }

    public int hashCode() {
        return this.m_id;
    }

    public int id() {
        return this.m_id;
    }

    static int calcId(int freq, int year, int placeinyear) {
        return (year - 1970) * freq + placeinyear;
    }

    public boolean isAfter(Date date) {
        return this.isAfter(new Day(date));
    }

    public boolean isAfter(Day day) {
        return this.firstday().compareTo(day) > 0;
    }

    public boolean isAfter(TsPeriod rp) {
        return this.compareTo(rp) > 0;
    }

    public boolean isBefore(Date date) {
        return this.isBefore(new Day(date));
    }

    public boolean isBefore(Day day) {
        return this.lastday().compareTo(day) < 0;
    }

    public boolean isBefore(TsPeriod rp) {
        return this.compareTo(rp) < 0;
    }

    public boolean isInside(TsPeriod p) {
        int ifreq = this.m_freq.intValue();
        int pfreq = p.m_freq.intValue();
        if (pfreq > ifreq) {
            return false;
        }
        if (ifreq == pfreq) {
            return this.m_id == p.m_id;
        }
        int id0 = this.m_id * 12 / ifreq;
        int id1 = p.m_id * 12 / pfreq;
        if (id0 < id1) {
            return false;
        }
        return id0 + 12 / ifreq <= id1 + 12 / pfreq;
    }

    public boolean isNotAfter(TsPeriod rp) {
        return this.compareTo(rp) <= 0;
    }

    public boolean isNotBefore(TsPeriod rp) {
        return this.compareTo(rp) >= 0;
    }

    @Override
    public Day lastday() {
        int ifreq = this.m_freq.intValue();
        int c = 12 / ifreq;
        int y = this.getYear();
        int month = this.getPosition() * c + c - 1;
        return new Day(y, Month.valueOf(month), Day.getNumberOfDaysByMonth(y, month) - 1);
    }

    public Date middle() {
        int ifreq = this.m_freq.intValue();
        int c = 12 / ifreq;
        int y = this.getYear();
        int p = this.getPosition();
        return new Date(CalendarUtil.getInstance().calcMiddleInMillis(c, y, p));
    }

    public TsPeriod minus(int nperiods) {
        return new TsPeriod(this.m_freq, this.m_id - nperiods);
    }

    public int minus(TsPeriod p) {
        if (this.m_freq != p.m_freq) {
            throw new TsException("Incompatible frequencies");
        }
        return this.m_id - p.m_id;
    }

    public void move(int nperiods) {
        this.m_id += nperiods;
    }

    public TsPeriod plus(int nperiods) {
        return new TsPeriod(this.m_freq, this.m_id + nperiods);
    }

    private void set(long timeInMillis) {
        this.m_id = CalendarUtil.getInstance().calcTsPeriodId(this.m_freq, timeInMillis);
    }

    public final void set(Date date) {
        this.set(date.getTime());
    }

    public final void set(Day day) {
        this.set(day.getTimeInMillis());
    }

    public final void set(int year, int position) {
        int ifreq = this.m_freq.intValue();
        if (position < 0 || position >= ifreq) {
            throw new TsException("Invalid period");
        }
        this.m_id = TsPeriod.calcId(ifreq, year, position);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(32);
        int p = this.getPosition();
        int y = this.getYear();
        int ifreq = this.m_freq.intValue();
        switch (ifreq) {
            case 2: 
            case 3: 
            case 4: {
                switch (p) {
                    case 0: {
                        buffer.append('I');
                        break;
                    }
                    case 1: {
                        buffer.append("II");
                        break;
                    }
                    case 2: {
                        buffer.append("III");
                        break;
                    }
                    case 3: {
                        buffer.append("IV");
                    }
                }
                buffer.append('-');
                break;
            }
            case 6: 
            case 12: {
                buffer.append(1 + p).append('-');
            }
        }
        buffer.append(y);
        return buffer.toString();
    }

    static final class CalendarUtil {
        private static final ThreadLocal<CalendarUtil> THREAD_LOCAL = ThreadLocal.withInitial(CalendarUtil::new);
        private final GregorianCalendar cal = new GregorianCalendar();

        CalendarUtil() {
        }

        public static CalendarUtil getInstance() {
            return THREAD_LOCAL.get();
        }

        private void set(int year, int month, int day) {
            this.cal.set(1, year);
            this.cal.set(2, month);
            this.cal.set(5, day);
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 0);
            this.cal.set(14, 0);
        }

        public int calcTsPeriodId(TsFrequency freq, long timeInMillis) {
            int ifreq = freq.intValue();
            this.cal.setTimeInMillis(timeInMillis);
            return TsPeriod.calcId(ifreq, this.cal.get(1), this.cal.get(2) / (12 / ifreq));
        }

        public long calcMiddleInMillis(int c, int year, int position) {
            int month = position * c;
            int day = (int)Math.ceil((double)Day.getNumberOfDaysByMonth(year, month) / 2.0);
            this.set(year, month, day);
            return this.cal.getTimeInMillis();
        }
    }
}

