/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.matrices.EigenRoutines;
import ec.tstoolkit.maths.matrices.EigenSystem;
import ec.tstoolkit.maths.matrices.IEigenSystem;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;

class SymmetricEigenSystem
implements IEigenSystem {
    private Matrix m_sm;
    private double[] m_ev;
    private Matrix m_eivec;
    private boolean m_bCalc;
    private double m_zero = 1.0E-6;
    private int m_maxiter = 30;
    private boolean m_bVec;

    public SymmetricEigenSystem() {
    }

    public SymmetricEigenSystem(Matrix m) {
        this.m_sm = m.clone();
    }

    @Override
    public void compute() {
        this.m_bCalc = false;
        this.calc();
    }

    void calc() {
        if (this.m_bCalc) {
            return;
        }
        EigenRoutines.setMaxIter(this.m_maxiter);
        double[] data = EigenSystem.convertToArray(this.m_sm);
        this.m_ev = EigenRoutines.householder(data, this.m_sm.getRowsCount(), this.m_bVec);
        EigenRoutines.triQL(this.m_ev, this.m_sm.getRowsCount(), data, this.m_bVec);
        this.m_eivec = new Matrix(data, this.m_sm.getRowsCount(), this.m_sm.getColumnsCount());
        this.m_bCalc = true;
    }

    @Override
    public Complex[] getEigenValues() {
        this.calc();
        int n = this.m_sm.getRowsCount();
        Complex[] rout = new Complex[n];
        for (int i = 0; i < rout.length; ++i) {
            rout[i] = Complex.cart(this.m_ev[n + i], 0.0);
        }
        return rout;
    }

    @Override
    public Complex[] getEigenValues(int m) {
        this.calc();
        int n = this.m_sm.getRowsCount();
        int mel = Math.min(n, m);
        Complex[] rout = new Complex[mel];
        for (int i = 0; i < mel; ++i) {
            rout[i] = Complex.cart(this.m_ev[n + i], 0.0);
        }
        return rout;
    }

    @Override
    public double[] getEigenVector(int idx) {
        if (!this.m_bVec) {
            throw new MatrixException("eig_init");
        }
        this.calc();
        int n = this.m_eivec.getRowsCount();
        double[] dout = new double[n];
        double[] data = EigenSystem.convertToArray(this.m_eivec);
        System.arraycopy(data, idx * n, dout, 0, n);
        return dout;
    }

    @Override
    public Matrix getEigenVectors() {
        if (!this.m_bVec) {
            throw new MatrixException("eig_init");
        }
        this.calc();
        Matrix iout = this.m_eivec.clone();
        return iout;
    }

    @Override
    public Matrix getEigenVectors(int m) {
        if (!this.m_bVec) {
            throw new MatrixException("eig_init");
        }
        this.calc();
        int n = this.m_eivec.getRowsCount();
        int mel = Math.min(m, this.m_eivec.getColumnsCount());
        Matrix sm = new Matrix(n, mel);
        for (int i = 0; i < sm.getRowsCount(); ++i) {
            for (int j = 0; j < mel; ++j) {
                sm.set(i, j, this.m_eivec.get(i, j));
            }
        }
        return sm;
    }

    @Override
    public double getZero() {
        return this.m_zero;
    }

    @Override
    public void setZero(double value) {
        this.m_zero = value;
    }

    public int getMaxIter() {
        return this.m_maxiter;
    }

    public void setMaxIter(int value) {
        this.m_maxiter = value;
    }

    @Override
    public boolean isComputingEigenVectors() {
        return this.m_bVec;
    }

    @Override
    public void setComputingEigenVectors(boolean value) {
        this.m_bVec = value;
        this.m_bCalc = false;
    }
}

