/*
 * Decompiled with CFR 0.152.
 */
package jdr.spec.x13;

import ec.tstoolkit.modelling.RegressionTestSpec;
import ec.tstoolkit.modelling.TradingDaysSpecType;
import ec.tstoolkit.modelling.arima.x13.RegArimaSpecification;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import jdr.spec.x13.BaseRegArimaSpec;

public class TradingDaysSpec
extends BaseRegArimaSpec {
    private ec.tstoolkit.modelling.arima.x13.TradingDaysSpec inner() {
        return this.core.getRegression().getTradingDays();
    }

    public TradingDaysSpec(RegArimaSpecification spec) {
        super(spec);
    }

    public String getOption() {
        if (this.inner().isStockTradingDays()) {
            return TradingDaysSpecType.Stock.name();
        }
        if (this.inner().getHolidays() != null) {
            return TradingDaysSpecType.Holidays.name();
        }
        if (this.inner().getUserVariables() != null) {
            return TradingDaysSpecType.UserDefined.name();
        }
        if (this.inner().getTradingDaysType() != TradingDaysType.None) {
            return TradingDaysSpecType.Default.name();
        }
        return TradingDaysSpecType.None.name();
    }

    public void setOption(String option) {
        TradingDaysSpecType value = TradingDaysSpecType.valueOf((String)option);
        switch (value) {
            case None: {
                this.inner().disable();
                break;
            }
            case Default: {
                this.inner().setTradingDaysType(TradingDaysType.TradingDays);
                this.inner().setLengthOfPeriod(LengthOfPeriodType.LeapYear);
                this.inner().setTest(RegressionTestSpec.Remove);
                this.inner().setAutoAdjust(true);
                this.inner().setHolidays(null);
                break;
            }
            case Holidays: {
                this.inner().setTradingDaysType(TradingDaysType.TradingDays);
                this.inner().setLengthOfPeriod(LengthOfPeriodType.LeapYear);
                this.inner().setTest(RegressionTestSpec.Remove);
                this.inner().setAutoAdjust(true);
                this.inner().setHolidays("Default");
                break;
            }
            case UserDefined: {
                this.inner().setUserVariables(new String[0]);
                this.inner().setTest(RegressionTestSpec.Remove);
                break;
            }
            case Stock: {
                this.inner().disable();
                this.inner().setStockTradingDays(31);
                this.inner().setTest(RegressionTestSpec.Remove);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
    }

    public String getTest() {
        return this.inner().getTest().name();
    }

    public void setTest(String value) {
        this.inner().setTest(RegressionTestSpec.valueOf((String)value));
    }

    public boolean isAutoAdjust() {
        return this.inner().isAutoAdjust();
    }

    public void setAutoAdjust(boolean value) {
        this.inner().setAutoAdjust(value);
    }

    public String getTradingDays() {
        return this.inner().getTradingDaysType().name();
    }

    public void setTradingDays(String value) {
        this.inner().setTradingDaysType(TradingDaysType.valueOf((String)value));
    }

    public String getLengthOfPeriod() {
        return this.inner().getLengthOfPeriod().name();
    }

    public void setLengthOfPeriod(String value) {
        this.inner().setLengthOfPeriod(LengthOfPeriodType.valueOf((String)value));
    }

    public String[] getUserVariables() {
        return this.inner().getUserVariables();
    }

    public void setUserVariables(String[] vars) {
        this.inner().setUserVariables(vars);
    }

    public int getW() {
        return this.inner().getStockTradingDays();
    }

    public void setW(int w) {
        this.inner().setStockTradingDays(w);
    }
}

