/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.arima.estimation.Forecasts;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.arima.IPreprocessor;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.ITsDataTransformation;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.List;

public class CheckLast {
    private final IPreprocessor preprocessor_;
    private PreprocessingModel model_;
    private InformationSet info_;
    private Forecasts forecasts_;
    private TsData y_;
    private TsData fy_;
    private TsData ofcasts_;
    private int nback_ = 1;
    public static final int MAX_REPEAT_COUNT = 80;
    public static final int MAX_MISSING_COUNT = 33;

    public CheckLast(IPreprocessor preprocessor) {
        this.preprocessor_ = preprocessor;
    }

    public boolean check(TsData data) {
        this.clear();
        if (!this.testSeries(data)) {
            return false;
        }
        ModellingContext context = new ModellingContext();
        this.model_ = this.preprocessor_.process(data.drop(0, this.nback_), context);
        if (this.model_ == null) {
            return false;
        }
        this.info_ = context.information;
        TsVariableList vars = this.model_.description.buildRegressionVariables();
        TsDomain fdomain = new TsDomain(this.model_.description.getSeriesDomain().getEnd(), this.nback_);
        List<DataBlock> x = vars.all().data(fdomain);
        this.forecasts_ = new Forecasts();
        RegArimaEstimation<SarimaModel> estimation = new RegArimaEstimation<SarimaModel>(this.model_.estimation.getRegArima(), this.model_.estimation.getLikelihood());
        try {
            this.forecasts_.calcForecast(estimation, x, this.nback_, this.model_.description.getArimaComponent().getFreeParametersCount());
        }
        catch (RuntimeException err) {
            return false;
        }
        this.y_ = data.fittoDomain(fdomain);
        this.fy_ = this.y_.clone();
        this.ofcasts_ = new TsData(fdomain);
        for (int i = 0; i < this.ofcasts_.getLength(); ++i) {
            this.ofcasts_.set(i, this.forecasts_.forecast(i));
        }
        this.model_.backTransform(this.ofcasts_, true, true);
        List<ITsDataTransformation> transformations = this.model_.description.transformations();
        for (ITsDataTransformation tr : transformations) {
            tr.transform(this.fy_, null);
        }
        return true;
    }

    public Forecasts getForecast() {
        return this.forecasts_;
    }

    public double[] getValues() {
        return this.fy_.internalStorage();
    }

    public double[] getActualValues() {
        return this.y_.internalStorage();
    }

    public double[] getAbsoluteErrors() {
        double[] e = (double[])this.y_.internalStorage().clone();
        double[] f = this.ofcasts_.internalStorage();
        for (int i = 0; i < e.length; ++i) {
            int n = i;
            e[n] = e[n] - f[i];
        }
        return e;
    }

    public double getAbsoluteError(int i) {
        return this.y_.get(i) - this.ofcasts_.get(i);
    }

    public double[] getForecastsValues() {
        return this.ofcasts_.internalStorage();
    }

    public double[] getScores() {
        if (this.forecasts_ == null || this.fy_ == null) {
            return null;
        }
        double[] s = new double[this.nback_];
        for (int i = 0; i < s.length; ++i) {
            s[i] = (this.fy_.get(i) - this.forecasts_.forecast(i)) / this.forecasts_.forecastStdev(i);
        }
        return s;
    }

    public double[] getRelativeErrors() {
        return this.getScores();
    }

    public double getScore(int i) {
        if (this.forecasts_ == null || this.fy_ == null) {
            return Double.NaN;
        }
        return (this.fy_.get(i) - this.forecasts_.forecast(i)) / this.forecasts_.forecastStdev(i);
    }

    public double getRelativeError(int i) {
        return this.getScore(i);
    }

    public InformationSet getInformation() {
        return this.info_;
    }

    public int getBackCount() {
        return this.nback_;
    }

    public void setBackCount(int n) {
        if (n != this.nback_) {
            this.nback_ = n;
            this.clear();
        }
    }

    public PreprocessingModel getEstimatedModel() {
        return this.model_;
    }

    public boolean testSeries(TsData y) {
        int ifreq;
        if (y == null) {
            return false;
        }
        int nz = y.getObsCount();
        if (nz < Math.max(8, 3 * (ifreq = y.getFrequency().intValue()))) {
            return false;
        }
        int nrepeat = y.getRepeatCount();
        if (nrepeat > 80 * nz / 100) {
            return false;
        }
        int nm = y.getMissingValuesCount();
        return nm <= 33 * nz / 100;
    }

    private void clear() {
        this.model_ = null;
        this.info_ = null;
        this.forecasts_ = null;
        this.fy_ = null;
    }
}

