/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.ssf.nonlinear;

import ec.benchmarking.Cumulator;
import ec.benchmarking.ssf.nonlinear.AbstractLinearizedDisaggregationSmoother;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.extended.LinearizedLogSsf;
import ec.tstoolkit.ssf.extended.WeightedLogSsf;

public class ProportionalBenchmarking<S extends ISsf>
extends AbstractLinearizedDisaggregationSmoother<WeightedLogSsf<S>, LinearizedLogSsf<S>> {
    private double[] m_data;

    public ProportionalBenchmarking(DataBlock y, double[] data, int conv, S s) {
        super(y, conv, new WeightedLogSsf<S>(s, data));
        this.m_data = data;
    }

    @Override
    protected boolean calcInitialApproximation() {
        int n;
        double[] e = new double[this.m_y.length];
        for (n = this.conversion - 1; n < e.length; n += this.conversion) {
            double s = 0.0;
            for (int i = 0; i < this.conversion; ++i) {
                s += this.m_data[n - i];
            }
            double w = this.m_y[n] / s;
            for (int i = 0; i < this.conversion; ++i) {
                e[n - i] = w;
            }
            if (n + this.conversion >= e.length) break;
        }
        while (n < e.length) {
            e[n++] = 1.0;
        }
        double[] tmp = new double[e.length];
        this.m_lssf = ((WeightedLogSsf)this.getNonLinearSsf()).linearApproximation(new DataBlock(tmp), new DataBlock(this.m_data));
        Cumulator cumul = new Cumulator(this.conversion);
        cumul.transform(tmp);
        this.m_yc = (double[])this.m_y.clone();
        for (int i = 0; i < tmp.length; ++i) {
            if (!Double.isFinite(this.m_yc[i])) continue;
            int n2 = i;
            this.m_yc[n2] = this.m_yc[n2] + tmp[i];
        }
        return true;
    }

    @Override
    protected boolean calcNextApproximation() {
        double[] e = new double[this.m_y.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = ((WeightedLogSsf)this.getNonLinearSsf()).Z(i, this.m_states.block(i).drop(1, 0));
        }
        double[] tmp = new double[this.m_y.length];
        this.m_lssf = ((WeightedLogSsf)this.getNonLinearSsf()).linearApproximation(new DataBlock(tmp), new DataBlock(e));
        Cumulator cumul = new Cumulator(this.conversion);
        cumul.transform(tmp);
        this.m_yc = (double[])this.m_y.clone();
        for (int i = 0; i < tmp.length; ++i) {
            if (!Double.isFinite(this.m_yc[i])) continue;
            int n = i;
            this.m_yc[n] = this.m_yc[n] + tmp[i];
        }
        return true;
    }

    public DataBlock getBenchmarkedData() {
        if (this.m_lssf == null && !this.calc()) {
            return null;
        }
        return ((LinearizedLogSsf)this.m_lssf).getE();
    }
}

