/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.polynomials;

import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.ComplexBuilder;
import ec.tstoolkit.maths.ComplexMath;
import ec.tstoolkit.maths.Simplifying;
import ec.tstoolkit.maths.polynomials.IRootsSolver;
import ec.tstoolkit.maths.polynomials.LeastSquaresDivision;
import ec.tstoolkit.maths.polynomials.MullerNewtonSolver;
import ec.tstoolkit.maths.polynomials.PolynomialException;
import ec.tstoolkit.maths.polynomials.UnitRoots;
import ec.tstoolkit.utilities.Arrays2;
import java.util.Arrays;
import java.util.Formatter;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntToDoubleFunction;

public final class Polynomial
implements IReadDataBlock {
    public static final Polynomial ZERO = new Polynomial(Doubles.zero(), 0);
    public static final Polynomial ONE = new Polynomial(Doubles.one(), 0);
    private final double[] m_c;
    private final int degree;
    private final AtomicReference<Complex[]> defRoots = new AtomicReference();
    private static double EPSILON = 1.0E-9;
    private static final AtomicReference<IRootsSolver> defSolver = new AtomicReference<MullerNewtonSolver>(new MullerNewtonSolver());

    public static Division divide(Polynomial num, Polynomial denom) {
        int n = num.getDegree();
        int nv = denom.getDegree();
        if (nv > n) {
            return new Division(num, ZERO);
        }
        double[] r = new double[n + 1];
        double[] q = new double[n + 1];
        for (int j = 0; j <= n; ++j) {
            r[j] = num.get(j);
            q[j] = 0.0;
        }
        for (int k = n - nv; k >= 0; --k) {
            q[k] = r[nv + k] / denom.get(nv);
            for (int j = nv + k - 1; j >= k; --j) {
                int n2 = j;
                r[n2] = r[n2] - q[k] * denom.get(j - k);
            }
        }
        Polynomial m_q = Polynomial.of(Arrays.copyOf(q, n - nv + 1));
        Polynomial m_r = nv > 0 ? Polynomial.of(Arrays.copyOf(r, nv)).adjustDegree() : ZERO;
        return new Division(m_r, m_q);
    }

    static double[] divide(double[] num, int numdegree, double[] denom, int denumdegree) {
        int n;
        int nv = denumdegree;
        for (n = numdegree; n >= 0 && !(Math.abs(num[n]) > EPSILON); --n) {
        }
        if (n < 0) {
            return Doubles.zero();
        }
        while (nv >= 0 && !(Math.abs(denom[nv]) > EPSILON)) {
            --nv;
        }
        if (nv < 0) {
            if (num[n] > 0.0) {
                return Doubles.positiveInfinity();
            }
            if (num[n] < 0.0) {
                return Doubles.negativeInfinity();
            }
            return Doubles.nan();
        }
        if (nv > n) {
            return Doubles.zero();
        }
        double[] r = (double[])num.clone();
        double[] q = new double[n + 1];
        for (int k = n - nv; k >= 0; --k) {
            q[k] = r[nv + k] / denom[nv];
            for (int j = nv + k - 1; j >= k; --j) {
                int n2 = j;
                r[n2] = r[n2] - q[k] * denom[j - k];
            }
        }
        return Arrays.copyOf(q, n - nv + 1);
    }

    @Override
    public void copyTo(double[] buffer, int start) {
        System.arraycopy(this.m_c, 0, buffer, start, this.degree + 1);
    }

    @Override
    public int getLength() {
        return this.degree + 1;
    }

    @Override
    public IReadDataBlock rextract(int start, int length) {
        return new ReadDataBlock(this.m_c, start, length);
    }

    boolean isSymmetric() {
        if (this.degree % 2 != 0) {
            return false;
        }
        for (int i = 0; i < this.degree / 2; ++i) {
            if (!(Math.abs(this.m_c[i] - this.m_c[this.degree - i]) > EPSILON)) continue;
            return false;
        }
        return true;
    }

    public static Complex[] checkRoots(Complex[] roots) throws PolynomialException {
        int i;
        int nroots = roots.length;
        Complex[] rootsc = new Complex[nroots];
        boolean[] used = new boolean[nroots];
        for (i = 0; i < nroots; ++i) {
            roots[i] = Polynomial.smooth(roots[i]);
        }
        int j = 0;
        for (i = 0; i < nroots; ++i) {
            int k;
            if (used[i]) continue;
            Complex c = roots[i];
            if (c.getIm() == 0.0) {
                rootsc[j++] = c;
                used[i] = true;
                continue;
            }
            if (!(c.getIm() > 0.0)) continue;
            used[i] = true;
            Complex conj = c.conj();
            for (k = 0; k < nroots; ++k) {
                if (used[k] || !(roots[k].getIm() < 0.0) || !roots[k].equals(conj, EPSILON)) continue;
                used[k] = true;
                c = Complex.cart((c.getRe() + roots[k].getRe()) / 2.0, (c.getIm() - roots[k].getIm()) / 2.0);
                conj = c.conj();
                break;
            }
            if (k == nroots) {
                throw new PolynomialException("p_err_conj");
            }
            rootsc[j++] = c;
            rootsc[j++] = conj;
        }
        return rootsc;
    }

    public static double getEpsilon() {
        return EPSILON;
    }

    public static Polynomial of(double[] coefficients) {
        if (Arrays2.isNullOrEmpty(coefficients)) {
            throw new IllegalArgumentException("Coefficients cannot be null or empty");
        }
        int usedDegree = Doubles.getUsedDegree(coefficients);
        Polynomial result = Cache.find(coefficients, usedDegree);
        return result != null ? result : new Polynomial(coefficients, usedDegree);
    }

    public static Polynomial copyOf(double[] coefficients) {
        if (Arrays2.isNullOrEmpty(coefficients)) {
            throw new IllegalArgumentException("Coefficients cannot be null or empty");
        }
        int usedDegree = Doubles.getUsedDegree(coefficients);
        Polynomial result = Cache.find(coefficients, usedDegree);
        return result != null ? result : new Polynomial(Arrays.copyOf(coefficients, usedDegree + 1), usedDegree);
    }

    public static Polynomial copyOf(double[] coefficients, int start, int end) {
        if (Arrays2.isNullOrEmpty(coefficients) || coefficients.length < end) {
            throw new IllegalArgumentException("Coefficients cannot be null or empty");
        }
        double[] copy = Arrays.copyOfRange(coefficients, start, end);
        return Polynomial.of(copy);
    }

    public static Polynomial valueOf(double firstCoefficient, double ... nextCoefficients) {
        if (Arrays2.isNullOrEmpty(nextCoefficients)) {
            if (firstCoefficient == 0.0) {
                return ZERO;
            }
            if (firstCoefficient == 1.0) {
                return ONE;
            }
            return new Polynomial(new double[]{firstCoefficient}, 0);
        }
        double[] result = Doubles.fromDegree(nextCoefficients.length);
        result[0] = firstCoefficient;
        System.arraycopy(nextCoefficients, 0, result, 1, nextCoefficients.length);
        return new Polynomial(result, Doubles.getUsedDegree(result));
    }

    public static Polynomial fromComplexRoots(Complex[] roots) {
        return Polynomial.fromComplexRoots(roots, 1.0);
    }

    public static Polynomial fromComplexRoots(Complex[] roots, double c) {
        int i;
        if (Arrays2.isNullOrEmpty(roots)) {
            return new Polynomial(new double[]{c}, 0);
        }
        double[] m_c = new double[roots.length + 1];
        Complex[] p = new Complex[roots.length + 1];
        p[0] = Complex.cart(c, 0.0);
        for (i = 0; i < roots.length; ++i) {
            p[i + 1] = p[i];
            for (int j = i; j >= 1; --j) {
                p[j] = p[j - 1].minus(p[j].times(roots[i]));
            }
            p[0] = p[0].times(roots[i].negate());
        }
        for (i = 0; i < p.length; ++i) {
            m_c[i] = p[i].getRe();
        }
        Polynomial pol = new Polynomial(m_c, Doubles.getUsedDegree(m_c));
        pol.defRoots.set((Complex[])roots.clone());
        return pol;
    }

    public static Polynomial fromData(IReadDataBlock data) {
        double[] d = new double[data.getLength()];
        data.copyTo(d, 0);
        return new Polynomial(d, Doubles.getUsedDegree(d));
    }

    public static Polynomial factor(double c, int n) {
        if (c == 0.0) {
            return ONE;
        }
        double[] p = new double[n + 1];
        p[0] = 1.0;
        p[n] = -c;
        Polynomial F2 = Polynomial.of(p);
        Complex[] ur = Complex.unitRoots(n);
        if (c > 0.0 || n % 2 == 1) {
            double rc = c > 0.0 ? Math.pow(1.0 / c, 1.0 / (double)n) : -Math.pow(-1.0 / c, 1.0 / (double)n);
            for (int i = 0; i < ur.length; ++i) {
                ur[i] = ur[i].times(rc);
            }
        } else {
            Complex rc = ComplexMath.pow(Complex.cart(1.0 / c, 0.0), 1.0 / (double)n);
            for (int i = 0; i < ur.length; ++i) {
                ur[i] = ur[i].times(rc);
            }
        }
        F2.setRoots(ur);
        return F2;
    }

    public static void setEpsilon(double value) {
        EPSILON = value;
    }

    private static Complex smooth(Complex c) {
        double re = c.getRe();
        double im = c.getIm();
        if (Math.abs(im) <= EPSILON) {
            im = 0.0;
        }
        if (Math.abs(re) <= EPSILON) {
            re = 0.0;
        }
        if (Math.abs(re - 1.0) <= EPSILON) {
            re = 1.0;
        }
        if (Math.abs(re + 1.0) <= EPSILON) {
            re = -1.0;
        }
        return Complex.cart(re, im);
    }

    public static IRootsSolver getDefRootsSearcher() {
        return defSolver.get().exemplar();
    }

    public static void setDefRootsSearcher(IRootsSolver value) {
        defSolver.set(value);
    }

    private Polynomial(double[] coefficients, int degree) {
        this.m_c = coefficients;
        this.degree = degree;
    }

    public Polynomial adjustDegree() {
        int n;
        for (n = this.degree; n >= 0 && Doubles.equals(0.0, this.get(n), EPSILON); --n) {
        }
        if (n < 0) {
            return ZERO;
        }
        if (n == this.degree) {
            return this;
        }
        return new Polynomial(this.m_c, n);
    }

    public Polynomial derivate() {
        if (this.degree == 0) {
            return ZERO;
        }
        double[] result = Doubles.fromDegree(this.degree - 1);
        for (int i = 1; i <= this.degree; ++i) {
            result[i - 1] = (double)i * this.get(i);
        }
        return new Polynomial(result, this.degree - 1);
    }

    public Polynomial divide(double d) {
        return this.times(1.0 / d);
    }

    public Polynomial divide(Polynomial r) {
        return Polynomial.of(Polynomial.divide(this.m_c, this.degree, r.m_c, r.degree));
    }

    public boolean equals(Object obj) {
        return obj instanceof Polynomial ? this.equals((Polynomial)obj, EPSILON) : false;
    }

    public boolean equals(Polynomial other, double epsilon) {
        if (this == other) {
            return true;
        }
        if (this.degree != other.degree) {
            return false;
        }
        for (int i = 0; i <= this.degree; ++i) {
            if (Doubles.equals(this.get(i), other.get(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    public Complex evaluateAt(Complex x) {
        int i = this.getDegree();
        double xr = x.getRe();
        double xi = x.getIm();
        double fr = this.get(i--);
        double fi = 0.0;
        while (i >= 0) {
            double tr = fr * xr - fi * xi + this.get(i);
            double ti = fr * xi + fi * xr;
            fr = tr;
            fi = ti;
            --i;
        }
        return Complex.cart(fr, fi);
    }

    public double evaluateAt(double x) {
        int i = this.getDegree();
        double f = this.get(i--);
        while (i >= 0) {
            f = this.m_c[i] + f * x;
            --i;
        }
        return f;
    }

    public static double revaluate(double[] c, double x) {
        int d = c.length;
        int p = 0;
        double y = c[p++];
        while (p < d) {
            y = c[p] + y * x;
            ++p;
        }
        return y;
    }

    public static double evaluate(double[] c, double x) {
        int p = c.length - 1;
        double y = c[p--];
        while (p >= 0) {
            y = c[p] + y * x;
            --p;
        }
        return y;
    }

    public static double evaluate(int degree, IntToDoubleFunction fn, double x) {
        int p = degree;
        double y = fn.applyAsDouble(p--);
        while (p >= 0) {
            y = fn.applyAsDouble(p) + y * x;
            --p;
        }
        return y;
    }

    public Complex evaluateAtFrequency(double w) {
        ComplexBuilder f = new ComplexBuilder(this.get(0));
        for (int i = 1; i <= this.degree; ++i) {
            f.add(Complex.polar(this.m_c[i], w * (double)i));
        }
        return f.build();
    }

    @Override
    public double get(int idx) {
        return this.m_c[idx];
    }

    public double[] getCoefficients() {
        return Arrays.copyOf(this.m_c, this.degree + 1);
    }

    public int getDegree() {
        return this.degree;
    }

    public int hashCode() {
        return Arrays.hashCode(this.m_c);
    }

    public boolean isZero() {
        return this.degree == 0 && this.get(0) == 0.0;
    }

    public boolean isIdentity() {
        return this.degree == 0 && this.get(0) == 1.0;
    }

    public Polynomial minus(double d) {
        return this.plus(-d);
    }

    public Polynomial minus(Polynomial r) {
        return this.plus(r.negate());
    }

    public Polynomial mirror() {
        if (this.degree == 0) {
            return this;
        }
        double[] result = Doubles.fromDegree(this.degree);
        for (int i = 0; i <= this.degree; ++i) {
            result[i] = this.get(this.degree - i);
        }
        return new Polynomial(result, Doubles.getUsedDegree(result));
    }

    public Polynomial negate() {
        return this.times(-1.0);
    }

    public Polynomial plus(double d) {
        if (d == 0.0) {
            return this;
        }
        double[] result = this.getCoefficients();
        result[0] = result[0] + d;
        return new Polynomial(result, this.degree);
    }

    public Polynomial plus(Polynomial r) {
        if (r.isZero()) {
            return this;
        }
        if (this.degree < r.degree) {
            return r.plus(this);
        }
        double[] result = this.getCoefficients();
        for (int i = 0; i <= r.degree; ++i) {
            int n = i;
            result[n] = result[n] + r.get(i);
        }
        int tmp = this.degree == r.degree ? Doubles.getUsedDegree(result) : this.degree;
        return new Polynomial(result, tmp);
    }

    public Complex[] roots() {
        Complex[] result = this.defRoots.get();
        if (result == null) {
            result = this.roots(Polynomial.getDefRootsSearcher());
            this.defRoots.set(result);
        }
        return result;
    }

    void setRoots(Complex[] roots) {
        this.defRoots.set(roots);
    }

    public Complex[] roots(IRootsSolver searcher) {
        if (this.getDegree() == 0) {
            return new Complex[0];
        }
        Polynomial tmp = this.adjustDegree();
        if (tmp.getDegree() == 0) {
            return new Complex[0];
        }
        if (searcher == null) {
            searcher = Polynomial.getDefRootsSearcher();
        }
        if (searcher.factorize(tmp)) {
            Complex[] roots = searcher.roots();
            searcher.clear();
            return roots;
        }
        return null;
    }

    public Polynomial smooth() {
        double[] result = this.getCoefficients();
        for (int i = 0; i < result.length; ++i) {
            double c = Math.round(result[i]);
            if (!Doubles.equals(c, result[i], EPSILON)) continue;
            result[i] = c;
        }
        return new Polynomial(result, Doubles.getUsedDegree(result));
    }

    public Polynomial times(double d) {
        if (d == 0.0 || this.isZero()) {
            return ZERO;
        }
        if (d == 1.0) {
            return this;
        }
        double[] coefficients = Doubles.fromDegree(this.degree);
        for (int i = 0; i <= this.degree; ++i) {
            coefficients[i] = this.get(i) * d;
        }
        Polynomial result = new Polynomial(coefficients, this.degree);
        result.defRoots.set(this.defRoots.get());
        return result;
    }

    public Polynomial times(Polynomial r) {
        return this.times(r, false);
    }

    public Polynomial times(Polynomial r, boolean computeroots) {
        if (r.isZero() || this.isZero()) {
            return ZERO;
        }
        if (r.isIdentity()) {
            return this;
        }
        if (this.isIdentity()) {
            return r;
        }
        double[] result = Doubles.fromDegree(this.degree + r.degree);
        result[this.degree + r.degree] = 0.0;
        for (int u = 0; u <= this.degree; ++u) {
            if (this.get(u) == 0.0) continue;
            for (int v = 0; v <= r.degree; ++v) {
                if (r.get(v) == 0.0) continue;
                int n = u + v;
                result[n] = result[n] + this.get(u) * r.get(v);
            }
        }
        Polynomial prod = Polynomial.of(result);
        Complex[] lRoots = this.defRoots.get();
        Complex[] rRoots = r.defRoots.get();
        if (lRoots != null && rRoots != null) {
            prod.defRoots.set(Arrays2.concat(lRoots, rRoots));
        } else if (computeroots) {
            prod.defRoots.set(Arrays2.concat(this.roots(), r.roots()));
        }
        return prod;
    }

    public String toString() {
        return this.toString('X', true);
    }

    public String toString(char var, boolean bSmooth) {
        return this.toString("%6g", var, bSmooth);
    }

    public String toString(String fmt, char var, boolean bSmooth) {
        Polynomial p = bSmooth ? this.smooth() : this;
        StringBuilder sb = new StringBuilder(512);
        boolean sign = false;
        int n = p.getDegree();
        if (n == 0) {
            sb.append(new Formatter().format(fmt, p.get(0)));
        } else {
            for (int i = 0; i <= n; ++i) {
                double v = Math.abs(p.get(i));
                if (!(v >= 1.0E-6)) continue;
                if (v > p.get(i)) {
                    sb.append(" - ");
                } else if (sign) {
                    sb.append(" + ");
                }
                if (v != 1.0 || i == 0) {
                    sb.append(new Formatter().format(fmt, v).toString());
                }
                sign = true;
                if (i > 0) {
                    sb.append(' ').append(var);
                }
                if (i <= 1) continue;
                sb.append('^').append(i);
            }
        }
        return sb.toString();
    }

    private static final class Cache {
        static final Polynomial p13 = new Polynomial(new double[]{1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 1.0}, 13);
        static final Polynomial p12 = new Polynomial(new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0}, 12);
        static final Polynomial p11 = new Polynomial(new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, 11);
        static final Polynomial p11_2 = new Polynomial(new double[]{12.0, 11.0, 10.0, 9.0, 8.0, 7.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0}, 11);
        static final Polynomial p4 = new Polynomial(new double[]{1.0, 0.0, 0.0, 0.0, -1.0}, 4);
        static final Polynomial p3 = new Polynomial(new double[]{1.0, 1.0, 1.0, 1.0}, 3);
        static final Polynomial p1 = new Polynomial(new double[]{1.0, -1.0}, 1);

        private Cache() {
        }

        static Polynomial find(double[] coefficients, int degree) {
            switch (degree) {
                case 0: {
                    if (coefficients[0] == 0.0) {
                        return ZERO;
                    }
                    if (coefficients[0] == 1.0) {
                        return ONE;
                    }
                    return null;
                }
                case 1: {
                    if (Cache.intEquals(coefficients, p1)) {
                        return p1;
                    }
                    return null;
                }
                case 3: {
                    if (Cache.intEquals(coefficients, p3)) {
                        return p3;
                    }
                    return null;
                }
                case 4: {
                    if (Cache.intEquals(coefficients, p4)) {
                        return p4;
                    }
                    return null;
                }
                case 11: {
                    if (Cache.intEquals(coefficients, p11)) {
                        return p11;
                    }
                    if (Cache.intEquals(coefficients, p11_2)) {
                        return p11_2;
                    }
                    return null;
                }
                case 12: {
                    if (Cache.intEquals(coefficients, p12)) {
                        return p12;
                    }
                    return null;
                }
                case 13: {
                    if (Cache.intEquals(coefficients, p13)) {
                        return p13;
                    }
                    return null;
                }
            }
            return null;
        }

        static boolean intEquals(double[] c, Polynomial p) {
            for (int i = 0; i <= p.getDegree(); ++i) {
                if (c[i] == p.get(i)) continue;
                return false;
            }
            return true;
        }
    }

    public static final class Doubles {
        private Doubles() {
        }

        public static double[] fromDegree(int degree) {
            double[] c = new double[degree + 1];
            c[degree] = 1.0;
            return c;
        }

        public static double[] zero() {
            return new double[]{0.0};
        }

        public static double[] one() {
            return new double[]{1.0};
        }

        public static double[] positiveInfinity() {
            return new double[]{Double.POSITIVE_INFINITY};
        }

        public static double[] negativeInfinity() {
            return new double[]{Double.NEGATIVE_INFINITY};
        }

        public static double[] nan() {
            return new double[]{Double.NaN};
        }

        public static int getUsedDegree(double[] coefficients) {
            int n;
            for (n = coefficients.length - 1; n > 0 && coefficients[n] == 0.0; --n) {
            }
            return n;
        }

        public static boolean equals(double a, double b, double epsilon) {
            return a > b ? a - epsilon <= b : b - epsilon <= a;
        }
    }

    public static class SimplifyingTool
    extends Simplifying<Polynomial> {
        @Override
        public boolean simplify(Polynomial left, Polynomial right) {
            this.clear();
            this.m_common = ONE;
            if (left.getDegree() >= right.getDegree()) {
                this.simplify(left, right, null);
            } else {
                this.simplify(right, left, null);
                Polynomial tmp = (Polynomial)this.m_left;
                this.m_left = this.m_right;
                this.m_right = tmp;
            }
            return ((Polynomial)this.m_common).getDegree() > 0;
        }

        private boolean simplify(Polynomial left, Polynomial right, Complex[] roots) {
            if (right.getDegree() <= 0) {
                return false;
            }
            if (this.simplifyExact(left, right)) {
                return true;
            }
            if (roots == null) {
                roots = right.roots();
            }
            double[] rtmp = Doubles.fromDegree(1);
            double[] ctmp = Doubles.fromDegree(2);
            for (Complex element : roots) {
                Polynomial xxx;
                if (!(left.evaluateAt(element).abs() < 1.0E-12)) continue;
                double a = element.getRe();
                double b = element.getIm();
                if (b == 0.0) {
                    rtmp[0] = -a;
                    xxx = Polynomial.of(rtmp);
                    left = left.divide(xxx);
                    this.m_common = ((Polynomial)this.m_common).times(xxx);
                    continue;
                }
                if (!(b > 0.0)) continue;
                ctmp[0] = a * a + b * b;
                ctmp[1] = -2.0 * a;
                xxx = Polynomial.of(ctmp);
                left = left.divide(xxx);
                this.m_common = ((Polynomial)this.m_common).times(xxx);
            }
            if (((Polynomial)this.m_common).getDegree() > 0) {
                this.m_left = left;
                this.m_right = right.divide((Polynomial)this.m_common);
                return true;
            }
            return false;
        }

        @Override
        public boolean simplify(Polynomial left, UnitRoots right) {
            this.clear();
            this.m_common = ONE;
            return this.simplify(left, right.toPolynomial(), right.roots());
        }

        private boolean simplifyExact(Polynomial left, Polynomial right) {
            LeastSquaresDivision div = new LeastSquaresDivision();
            if (!div.divide(left, right) || !div.isExact()) {
                return false;
            }
            this.m_left = div.getQuotient();
            this.m_right = ONE;
            this.m_common = right;
            return true;
        }
    }

    public static final class Division {
        private final Polynomial m_r;
        private final Polynomial m_q;

        private Division(Polynomial remainder, Polynomial quotient) {
            this.m_r = remainder;
            this.m_q = quotient;
        }

        public Polynomial getQuotient() {
            return this.m_q;
        }

        public Polynomial getRemainder() {
            return this.m_r;
        }

        public boolean isExact() {
            return this.m_r.isZero();
        }
    }
}

