/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.dstats;

import ec.tstoolkit.dstats.BoundaryType;
import ec.tstoolkit.dstats.DStatException;
import ec.tstoolkit.dstats.IContinuousDistribution;
import ec.tstoolkit.dstats.ProbInvFinder;
import ec.tstoolkit.dstats.ProbabilityType;
import ec.tstoolkit.dstats.SpecialFunctions;
import ec.tstoolkit.random.IRandomNumberGenerator;

public class Chi2
implements IContinuousDistribution {
    public static final String NAME = "Chi2";
    private int df_;
    private double b;
    private double vm;
    private double vd;
    private double vp;

    @Deprecated
    public Chi2() {
        this.df_ = 2;
        this.fillHelpers();
    }

    public Chi2(int df) {
        this.df_ = df;
        this.fillHelpers();
    }

    public int getDegreesofFreedom() {
        return this.df_;
    }

    @Override
    public double getDensity(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return SpecialFunctions.chiSquareDensity(x, this.df_);
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Chi2 with ");
        sb.append(this.df_);
        sb.append(" degrees of freedom ");
        return sb.toString();
    }

    @Override
    public double getExpectation() {
        if (this.df_ <= 2) {
            throw new DStatException("Expectation not defined for df <= 2", NAME);
        }
        return this.df_;
    }

    @Override
    public double getLeftBound() {
        return 0.0;
    }

    @Override
    public double getProbability(double x, ProbabilityType pt) {
        if (pt == ProbabilityType.Point) {
            return 0.0;
        }
        double res = SpecialFunctions.chiSquare(x, this.df_);
        if (pt == ProbabilityType.Upper) {
            res = 1.0 - res;
        }
        return res;
    }

    @Override
    public double getProbabilityInverse(double p, ProbabilityType pt) {
        if (pt == ProbabilityType.Upper) {
            p = 1.0 - p;
        }
        if (p < 1.0E-15 || 1.0 - p < 1.0E-15) {
            throw new DStatException("Can't compute probability inverse (value is too near 0 or 1)", NAME);
        }
        double start = this.df_;
        return ProbInvFinder.find(p, start, 1.0E-15, 1.0E-9, this);
    }

    @Override
    public double getRightBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getVariance() {
        if (this.df_ <= 2) {
            throw new DStatException("Variance not defined for df <= 2", NAME);
        }
        return (double)this.df_ * 2.0;
    }

    @Override
    public BoundaryType hasLeftBound() {
        return this.df_ <= 2 ? BoundaryType.Asymptotical : BoundaryType.Finite;
    }

    @Override
    public BoundaryType hasRightBound() {
        return BoundaryType.None;
    }

    @Override
    public boolean isSymmetrical() {
        return false;
    }

    @Override
    public double random(IRandomNumberGenerator rng) {
        double z;
        if (this.df_ == 1) {
            double z2;
            while (true) {
                double u = rng.nextDouble();
                double v = rng.nextDouble() * 0.857763884960707;
                z2 = v / u;
                if (z2 < 0.0) continue;
                double zz = z2 * z2;
                double r = 2.5 - zz;
                if (z2 < 0.0) {
                    r += zz * z2 / (3.0 * z2);
                }
                if (u < r * 0.3894003915) {
                    return z2 * z2;
                }
                if (!(zz > 1.036961043 / u + 1.4) && 2.0 * Math.log(u) < -zz * 0.5) break;
            }
            return z2 * z2;
        }
        while (true) {
            double u = rng.nextDouble();
            double v = rng.nextDouble() * this.vd + this.vm;
            z = v / u;
            if (z < -this.b) continue;
            double zz = z * z;
            double r = 2.5 - zz;
            if (z < 0.0) {
                r += zz * z / (3.0 * (z + this.b));
            }
            if (u < r * 0.3894003915) {
                return (z + this.b) * (z + this.b);
            }
            if (!(zz > 1.036961043 / u + 1.4) && 2.0 * Math.log(u) < Math.log(1.0 + z / this.b) * this.b * this.b - zz * 0.5 - z * this.b) break;
        }
        return (z + this.b) * (z + this.b);
    }

    @Deprecated
    public void setDegreesofFreedom(int df) {
        if (df < 1) {
            throw new DStatException("Degrees of freedom must be >= 1", NAME);
        }
        this.df_ = df;
        this.fillHelpers();
    }

    private void fillHelpers() {
        this.b = Math.sqrt((double)this.df_ - 1.0);
        this.vm = -0.6065306597 * (1.0 - 0.25 / (this.b * this.b + 1.0));
        this.vm = -this.b > this.vm ? -this.b : this.vm;
        this.vp = 0.6065306597 * (0.7071067812 + this.b) / (0.5 + this.b);
        this.vd = this.vp - this.vm;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(NAME).append('(');
        sb.append(this.df_);
        sb.append(')');
        return sb.toString();
    }
}

