/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.calendars;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.design.Singleton;
import ec.tstoolkit.timeseries.DayOfWeek;
import ec.tstoolkit.timeseries.calendars.GregorianCalendarManager;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.calendars.Utilities;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.List;

@Singleton
public class DefaultGregorianCalendarProvider
implements IGregorianCalendarProvider {
    public static final DefaultGregorianCalendarProvider instance = new DefaultGregorianCalendarProvider();

    protected DefaultGregorianCalendarProvider() {
    }

    @Override
    @Deprecated
    public void calendarData(TradingDaysType dtype, TsDomain domain, List<DataBlock> buffer, int start) {
        this.calendarData(dtype, domain, buffer.subList(start, start + this.count(dtype)));
    }

    @Override
    public void calendarData(TradingDaysType dtype, TsDomain domain, List<DataBlock> buffer) {
        int nreg = 0;
        switch (dtype) {
            case TradingDays: {
                nreg = 6;
                this.tradingDays(domain, buffer);
                break;
            }
            case WorkingDays: {
                nreg = 1;
                this.workingDays(domain, buffer.get(0));
            }
        }
    }

    public static String description(TradingDaysType dw, int idx) {
        if (idx >= dw.getVariablesCount()) {
            return "";
        }
        if (dw == TradingDaysType.TradingDays) {
            return DayOfWeek.valueOf(idx + 1).toString();
        }
        return "Week days";
    }

    @Override
    public List<DataBlock> holidays(TradingDaysType dtype, TsDomain domain) {
        return null;
    }

    protected void tradingDays(TsDomain domain, List<DataBlock> buffer) {
        int n = domain.getLength();
        int[][] days = Utilities.tradingDays(domain);
        for (int i = 0; i < 6; ++i) {
            DataBlock cur = buffer.get(i);
            for (int j = 0; j < n; ++j) {
                cur.set(j, days[i][j] - days[6][j]);
            }
        }
    }

    protected void workingDays(TsDomain domain, DataBlock buffer) {
        int n = domain.getLength();
        int[][] days = Utilities.tradingDays(domain);
        for (int j = 0; j < n; ++j) {
            int sum = 0;
            for (int i = 0; i < 5; ++i) {
                sum += days[i][j];
            }
            int sumf = days[5][j] + days[6][j];
            double d = (double)sum - 2.5 * (double)sumf;
            buffer.set(j, d);
        }
    }

    @Override
    public int count(TradingDaysType type) {
        return type.getVariablesCount();
    }

    public int count(LengthOfPeriodType type) {
        return type == LengthOfPeriodType.None ? 0 : 1;
    }

    @Override
    public String getDescription(TradingDaysType dtype, int idx) {
        if (idx >= this.count(dtype)) {
            return "";
        }
        if (dtype == TradingDaysType.TradingDays) {
            return DayOfWeek.valueOf(idx + 1).toString();
        }
        return "Week days";
    }

    public String getDescription(LengthOfPeriodType dtype) {
        switch (dtype) {
            case LeapYear: {
                return "Leap year";
            }
            case LengthOfPeriod: {
                return "Length of period";
            }
        }
        return "";
    }

    @Override
    public DefaultGregorianCalendarProvider withCalendarManager(GregorianCalendarManager manager) {
        return this;
    }
}

