/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client.custom;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.Message;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.client.RestSdmxClient;
import it.bancaditalia.oss.sdmx.parser.v21.CompactDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.parser.v21.RestQueryBuilder;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.SdmxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class EUROSTAT
extends RestSdmxClient {
    private static final String EUROSTAT_PROVIDER = "http://ec.europa.eu/eurostat/SDMX/diss-web/rest";
    private int sleepTime = 6000;
    private int retries = Integer.parseInt(Configuration.getLateResponseRetries(10));

    public EUROSTAT() throws MalformedURLException {
        super("Eurostat", new URL(EUROSTAT_PROVIDER), false, false, false);
    }

    @Override
    protected String buildFlowQuery(String string, String string2, String string3) throws SdmxException {
        String string4 = RestQueryBuilder.getDataflowQuery(this.endpoint, string, "ESTAT", string3);
        return string4;
    }

    @Override
    public List<PortableTimeSeries> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        Message message;
        DataParsingResult dataParsingResult = null;
        InputStreamReader inputStreamReader = null;
        List<PortableTimeSeries> list = null;
        dataParsingResult = this.getData(dataflow, dataFlowStructure, string, string2, string3, bl, string4, bl2);
        list = dataParsingResult.getData();
        if ((list == null || list.size() == 0) && (message = dataParsingResult.getMessage()) != null && message.getCode() != null && message.getCode().equalsIgnoreCase("413") && message.getUrl() != null) {
            inputStreamReader = this.pollLateResponse(message.getUrl());
            if (inputStreamReader != null) {
                try {
                    dataParsingResult = CompactDataParser.parse(inputStreamReader, dataFlowStructure, dataflow.getId(), !bl);
                }
                catch (Exception exception) {
                    logger.severe("Exception caught parsing results from call to provider " + this.name);
                    logger.log(Level.FINER, "Exception: ", exception);
                    throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    logger.severe("Exception caught closing stream.");
                }
            }
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        return dataParsingResult.getData();
    }

    private InputStreamReader pollLateResponse(String string) throws SdmxException {
        InputStreamReader inputStreamReader = null;
        if (string != null && !string.isEmpty()) {
            try {
                URL uRL = new URL(string);
                ZipInputStream zipInputStream = null;
                for (int i = 1; i <= this.retries; ++i) {
                    logger.info("Trying late retrieval with URL: " + uRL + ". Attempt n: " + i);
                    Thread.sleep(this.sleepTime);
                    this.conn = (HttpURLConnection)uRL.openConnection();
                    this.conn.setRequestMethod("GET");
                    int n = this.conn.getResponseCode();
                    if (n == 200) {
                        logger.fine("Connection opened. Code: " + n);
                        zipInputStream = new ZipInputStream(this.conn.getInputStream());
                        ZipEntry zipEntry = zipInputStream.getNextEntry();
                        if (zipEntry == null) continue;
                        inputStreamReader = new InputStreamReader(zipInputStream);
                    }
                    if (n != 404) continue;
                }
            }
            catch (MalformedURLException malformedURLException) {
                logger.warning("URL for late retrieval is not valid: " + string);
            }
            catch (Exception exception) {
                logger.severe("Exception during late retrieval. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                logger.log(Level.FINER, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
        } else {
            logger.warning("URL for late retrieval is not valid: " + string);
        }
        return inputStreamReader;
    }
}

