% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/EmpiricalOpCharac.R
\name{EmpiricalOpCharac}
\alias{EmpiricalOpCharac}
\title{Plot empirical operating characteristic}
\usage{
EmpiricalOpCharac(dataset, trts, rdrs, lgdPos = "bottom", opChType = "ROC")
}
\arguments{
\item{dataset}{Dataset to be used for plotting.}

\item{trts}{List or vector: indices of modalities to be plotted. See "Details".}

\item{rdrs}{List or vector. indices of readers to be plotted. See "Details".}

\item{lgdPos}{The positioning of the legend: \code{right}(the default), \code{left}, \code{top} or \code{bottom}.}

\item{opChType}{Type of operating characteristic to be plotted. Available choices are \code{ROC}(the default), \code{AFROC} and \code{FROC}.}
}
\value{
A \pkg{ggplot2} object of the plotted operating characteristics and a data frame containing the points of the operating characteristics are returned. Following are the returned objects of
\code{ROC} operating characteristics.

\item{ROCPlot}{\pkg{ggplot2} object: Use \code{print} function to display the saved object.}

\item{ROCPoints}{Data frame with four columns: abscissa, ordinate, class  (coding modality and reader) and type,
which can be "individual" or "averaged".}
}
\description{
Plot emprirical operating characteristics (operating points connected by straight lines) for specified trts and rdrs in the dataset.
}
\details{
\strong{Note} that \code{trts} and \code{rdrs} are the vectors or list of \strong{indices} not \strong{IDs}. For example, if the ID of the
first reader is "0". The corresponding value in \code{trts} should be \strong{1}  not \strong{0}.

If both of \code{trts} and \code{rdrs} are vectors, all possible combinations will be plotted.

If both of \code{trts} and \code{rdrs} are lists, they must have same length. Only the combination of modality and reader at same position will be
plotted. If some elements of the lists are vectors, the averaged operating characteristic over them will be plotted. See "Examples".
}
\examples{
plotM <- c(1:2)
plotR <- c(1:3)
EmpiricalOpCharac(dataset = rocData, trts = plotM, rdrs = plotR,
                  lgdPos = "bottom", opChType = "ROC")
## Above is the example of plotting individual ROC operating characteristics of modalities
## 1 and 2 and readers 1 to 3. Six operating characteristics will be plotted, which are
## operating characteristics of reader 1 modality 1, reader 1 modality 2, reader 2 modality
## 1, reader 2 modality 2, reader 3 modality 1 and reader 3 modality 2.

plotM <- list(1, 2, c(1:2))
plotR <- list(2, c(2:3), c(1:3))
EmpiricalOpCharac(dataset = rocData, trts = plotM, rdrs = plotR,
                  lgdPos = "bottom", opChType = "ROC")
EmpiricalOpCharac(dataset = frocData, trts = plotM, rdrs = plotR,
                  lgdPos = "bottom", opChType = "AFROC")
EmpiricalOpCharac(dataset = frocData, trts = plotM, rdrs = plotR,
                  lgdPos = "bottom", opChType = "FROC")
## Above is the example of plotting three ROC, AFROC and FROC operating characteristics.
## They are the individual operating characteristic of modality 1 reader 2, the
## averaged operating characteristic of modality 2 and reader 2 and 3 and the averaged
## operating characteristic of modality 1 and 2 and reader 1 to 3.
}

