% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DBMHAnalysis.R
\name{DBMHAnalysis}
\alias{DBMHAnalysis}
\title{DBM analysis with Hillis improvements}
\usage{
DBMHAnalysis(dataset, fom = "wJAFROC", alpha = 0.05, option = "ALL")
}
\arguments{
\item{dataset}{The dataset to be analyzed, see \link{RJafroc-package}.}

\item{fom}{The figure of merit to be used in the analysis, default is \code{"wJAFROC"}, see \link{FigureOfMerit}.}

\item{alpha}{The significance level of the test of the null hypothesis that all treatment effects are zero (default alpha is 0.05).}

\item{option}{The analysis option: it can be \code{"RRRC"}, \code{"FRRC"}, \code{"RRFC"} or \code{"ALL"} (the default), corresponding
random readers and random cases, fixed readers and random cases and random readers and fixed cases, respectively; this option
indicates which factors are treated as random and/or fixed factors in the analysis.}
}
\value{
The return value is a list with following elements:

\item{fomArray}{The figure of merit array of each reader and modality.}

\item{anovaY}{The ANOVA table of the pseudovalues.}

\item{anovaYi}{The ANOVA table of the pseudovalues for each modality.}

\item{varComp}{The DBM variance components estimates.}

\item{fRRRC}{The F statistic for testing the null hypothesis, for the RRRC condition.}

\item{ddfRRRC}{The denominator degrees of freedom of the F statistic, for the RRRC condition.}

\item{pRRRC}{The p-value of the significance test of the NH for the RRRC condition.}

\item{ciDiffTrtRRRC}{The confidence intervals and related tests for the FOM differences between pairs of modalities,
for the RRRC condition.}

\item{ciAvgRdrEachTrtRRRC}{The confidence intervals and related tests for rdr. avg. FOM in each modality, for the RRRC condition.}

\item{fFRRC}{The F statistic for testing the null hypothesis, for the FRRC condition.}

\item{ddfFRRC}{The denominator degrees of freedom of the FRRC F statistic.}

\item{pFRRC}{The p-value of the significance test of the NH, for the FRRC condition.}

\item{ciDiffTrtFRRC}{The confidence intervals and related tests for the FOM differences between pairs of modalities,
for the FRRC condition.}

\item{ciAvgRdrEachTrtFRRC}{The confidence intervals and related tests for rdr. avg. FOM in each modality, for the FRRC condition.}

\item{ssAnovaEachRdr}{The sum of squares table of the ANOVA of the pseudovalues for each reader (based on the data only
for the specified reader).}

\item{msAnovaEachRdr}{The mean squares table of the ANOVA of the pseudovalues for each reader (based on the data only
for the specified reader).}

\item{ciDiffTrtEachRdr}{The confidence intervals and related tests of the FOM differences between pairs of modalities for each reader.}

\item{fRRFC}{The F statistic for testing the null hypothesis, for the RRFC condition.}

\item{ddfRRFC}{The denominator degrees of freedom of the F statistic, for the RRFC condition.}

\item{pRRFC}{The p-value of the significance test of the NH, for the RRFC condition.}

\item{ciDiffTrtRRFC}{The confidence intervals and related tests for the FOM differences between pairs of modalities,
for the RRFC condition.}

\item{ciAvgRdrEachTrtRRFC}{The confidence intervals and related tests for rdr. avg. FOM in each modality, for the RRFC condition.}
}
\description{
Performs Dorfman-Berbaum-Metz significance testing, with Hillis improvements, for the specified dataset.
}
\examples{
retDbmRoc  <- DBMHAnalysis(rocData, fom = "Wilcoxon")

\dontrun{
retDbmwJAFROC  <- DBMHAnalysis(frocData) # default is weighted JAFROC

retDbmHrAuc  <- DBMHAnalysis(frocData, fom = "HrAuc")
print(retDbmHrAuc)

retDbmSongA1  <- DBMHAnalysis(frocData, fom = "SongA1")
print(retDbmSongA1)

retDbmSongA2  <- DBMHAnalysis(frocData, fom = "SongA2")
print(retDbmSongA2)

retDbmwJafroc1  <- DBMHAnalysis(frocData, fom = "wJAFROC1")
print(retDbmwJafroc1)

retDbmJafroc1  <- DBMHAnalysis(frocData, fom = "JAFROC1")
print(retDbmJafroc1)

retDbmJAFROC  <- DBMHAnalysis(frocData, fom = "JAFROC")
print(retDbmJAFROC)

retDbmROI  <- DBMHAnalysis(roiData, fom = "ROI")
print(retDbmROI)
}
}

