% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset12}
\alias{dataset12}
\title{Dobbins 2 ROC dataset}
\format{
A list with 3 elements: \code{$ratings}, \code{$lesions} and \code{$descriptions}; \code{$ratings}
   contain 3 elements, \code{$NL}, \code{$LL} and \code{$LL_IL} as sub-lists; \code{$lesions}
   contain 3 elements, \code{$perCase}, \code{$IDs} and \code{$weights} as sub-lists; \code{$descriptions}
   contain 7 elements, \code{$fileName}, \code{$type}, \code{$name},
   \code{$truthTableStr}, \code{$design}, \code{$modalityID} and \code{$readerID} as sub-lists;
\itemize{
\item{\code{rating$NL}}{, num [1:4, 1:5, 1:152, 1], ratings of non-lesion localizations, NLs}
\item{\code{rating$LL}}{, num [1:4, 1:5, 1:88, 1], ratings of lesion localizations, LLs}
\item{\code{rating$LL_IL}}{NA, this placeholder is used only for LROC data}
\item{\code{lesions$perCase}}{, int [1:88], number of lesions per diseased case}
\item{\code{lesions$IDs}}{, num [1:88, 1], numeric labels of lesions on diseased cases}
\item{\code{lesions$weights}}{, num [1:88, 1], weights (or clinical importances) of lesions}
\item{\code{descriptions$fileName}}{, chr, "dataset12", base name of dataset in `data` folder}
\item{\code{descriptions$type}}{, chr "ROC", the data type}
\item{\code{descriptions$name}}{, chr "DOBBINS-2", the name of the dataset}
\item{\code{descriptions$truthTableStr}}{, num [1:4, 1:5, 1:152, 1:2] , truth table structure}
\item{\code{descriptions$design}}{, chr "FCTRL", study design, factorial dataset}
\item{\code{descriptions$modalityID}}{, chr [1:4] "1" "2" "3" "4", treatment label(s)}
\item{\code{descriptions$readerID}}{, chr [1:5] "1" "2" "3" "4" ..., reader labels}
}
}
\usage{
dataset12
}
\description{
This is referred to in the code as the "DOB2" dataset. It contains actionability
ratings, i.e., do you recommend further follow up on the patient, one a 1 (definitely not)
to 5 (definitely yes), effectively an ROC dataset using a 5-point rating scale.
}
\examples{
str(dataset12)


}
\references{
Dobbins III JT et al. Multi-Institutional Evaluation of Digital 
Tomosynthesis, Dual-Energy Radiography, and Conventional Chest Radiography 
for the Detection and Management of Pulmonary Nodules. Radiology. 2016;282(1):236-250.
}
\keyword{datasets}
