/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers.forOPTICSAndDBScan.OPTICS_GUI;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import weka.clusterers.forOPTICSAndDBScan.OPTICS_GUI.GraphPanel;
import weka.clusterers.forOPTICSAndDBScan.OPTICS_GUI.ResultVectorTableModel;
import weka.clusterers.forOPTICSAndDBScan.OPTICS_GUI.SERFileFilter;
import weka.clusterers.forOPTICSAndDBScan.OPTICS_GUI.SERObject;
import weka.gui.LookAndFeel;

public class OPTICS_Visualizer {
    private SERObject serObject;
    private JFrame frame;
    private JFrame statisticsFrame;
    private JFrame helpFrame;
    private FrameListener frameListener;
    private JToolBar toolBar;
    private JButton toolBarButton_open;
    private JButton toolBarButton_save;
    private JButton toolBarButton_parameters;
    private JButton toolBarButton_help;
    private JButton toolBarButton_about;
    private JMenuBar defaultMenuBar;
    private JMenuItem open;
    private JMenuItem save;
    private JMenuItem exit;
    private JMenuItem parameters;
    private JMenuItem help;
    private JMenuItem about;
    private JTabbedPane tabbedPane;
    private JTable resultVectorTable;
    private GraphPanel graphPanel;
    private JScrollPane graphPanelScrollPane;
    private JPanel settingsPanel;
    private JCheckBox showCoreDistances;
    private JCheckBox showReachabilityDistances;
    private int verValue = 30;
    private JSlider verticalSlider;
    private JButton coreDistanceColorButton;
    private JButton reachDistanceColorButton;
    private JButton graphBackgroundColorButton;
    private JButton resetColorButton;
    private JFileChooser jFileChooser;
    private String lastPath;

    public OPTICS_Visualizer(SERObject sERObject, String string) {
        this.serObject = sERObject;
        LookAndFeel.setLookAndFeel();
        this.frame = new JFrame(string);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                OPTICS_Visualizer.this.frame.dispose();
            }
        });
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.setSize(new Dimension(800, 600));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = this.frame.getBounds();
        this.frame.setLocation((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
        this.frameListener = new FrameListener();
        this.jFileChooser = new JFileChooser();
        this.jFileChooser.setFileFilter(new SERFileFilter("ser", "Java Serialized Object File (*.ser)"));
        this.createGUI();
        this.frame.setVisible(true);
        this.frame.toFront();
    }

    private void createGUI() {
        this.setMenuBar(this.constructDefaultMenuBar());
        this.frame.getContentPane().add((Component)this.createToolBar(), "North");
        this.frame.getContentPane().add((Component)this.createTabbedPane(), "Center");
        this.frame.getContentPane().add((Component)this.createSettingsPanel(), "South");
        this.disableSettingsPanel();
    }

    private JComponent createSettingsPanel() {
        this.settingsPanel = new JPanel(new GridBagLayout());
        SettingsPanelListener settingsPanelListener = new SettingsPanelListener();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(" General Settings "));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        this.showCoreDistances = new JCheckBox("Show Core-Distances");
        this.showCoreDistances.setSelected(true);
        this.showReachabilityDistances = new JCheckBox("Show Reachability-Distances");
        this.showReachabilityDistances.setSelected(true);
        this.showCoreDistances.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    OPTICS_Visualizer.this.graphPanel.setShowCoreDistances(true);
                    OPTICS_Visualizer.this.graphPanel.adjustSize(OPTICS_Visualizer.this.serObject);
                    OPTICS_Visualizer.this.graphPanel.repaint();
                } else if (itemEvent.getStateChange() == 2) {
                    OPTICS_Visualizer.this.graphPanel.setShowCoreDistances(false);
                    OPTICS_Visualizer.this.graphPanel.adjustSize(OPTICS_Visualizer.this.serObject);
                    OPTICS_Visualizer.this.graphPanel.repaint();
                }
            }
        });
        this.showReachabilityDistances.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    OPTICS_Visualizer.this.graphPanel.setShowReachabilityDistances(true);
                    OPTICS_Visualizer.this.graphPanel.adjustSize(OPTICS_Visualizer.this.serObject);
                    OPTICS_Visualizer.this.graphPanel.repaint();
                } else if (itemEvent.getStateChange() == 2) {
                    OPTICS_Visualizer.this.graphPanel.setShowReachabilityDistances(false);
                    OPTICS_Visualizer.this.graphPanel.adjustSize(OPTICS_Visualizer.this.serObject);
                    OPTICS_Visualizer.this.graphPanel.repaint();
                }
            }
        });
        jPanel2.add(this.showCoreDistances);
        jPanel2.add(this.showReachabilityDistances);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        final JLabel jLabel = new JLabel("Vertical Adjustment: " + this.verValue);
        jPanel3.add((Component)jLabel, "North");
        this.verticalSlider = new JSlider(0, 0, this.frame.getHeight(), this.verValue);
        this.verticalSlider.setMajorTickSpacing(100);
        this.verticalSlider.setMinorTickSpacing(10);
        this.verticalSlider.setPaintTicks(true);
        this.verticalSlider.setPaintLabels(true);
        this.verticalSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!OPTICS_Visualizer.this.verticalSlider.getValueIsAdjusting()) {
                    OPTICS_Visualizer.this.verValue = OPTICS_Visualizer.this.verticalSlider.getValue();
                    jLabel.setText("Vertical Adjustment: " + OPTICS_Visualizer.this.verValue);
                    OPTICS_Visualizer.this.graphPanel.setVerticalAdjustment(OPTICS_Visualizer.this.verValue);
                    OPTICS_Visualizer.this.graphPanel.repaint();
                }
            }
        });
        jPanel3.add((Component)this.verticalSlider, "Center");
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.settingsPanel.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 3.0, 1.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(" Colors "));
        JPanel jPanel5 = new JPanel(new GridLayout(4, 2, 10, 10));
        jPanel5.add(new JLabel("Core-Distance: "));
        this.coreDistanceColorButton = new JButton();
        this.coreDistanceColorButton.setBackground(new Color(100, 100, 100));
        this.coreDistanceColorButton.addActionListener(settingsPanelListener);
        jPanel5.add(this.coreDistanceColorButton);
        jPanel5.add(new JLabel("Reachability-Distance: "));
        this.reachDistanceColorButton = new JButton();
        this.reachDistanceColorButton.setBackground(Color.orange);
        this.reachDistanceColorButton.addActionListener(settingsPanelListener);
        jPanel5.add(this.reachDistanceColorButton);
        jPanel5.add(new JLabel("Graph Background: "));
        this.graphBackgroundColorButton = new JButton();
        this.graphBackgroundColorButton.setBackground(new Color(255, 255, 179));
        this.graphBackgroundColorButton.addActionListener(settingsPanelListener);
        jPanel5.add(this.graphBackgroundColorButton);
        jPanel5.add(new JLabel());
        this.resetColorButton = new JButton("Reset");
        this.resetColorButton.addActionListener(settingsPanelListener);
        jPanel5.add(this.resetColorButton);
        jPanel4.add((Component)jPanel5, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.settingsPanel.add((Component)jPanel4, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return this.settingsPanel;
    }

    private void disableSettingsPanel() {
        this.verticalSlider.setEnabled(false);
        this.coreDistanceColorButton.setEnabled(false);
        this.reachDistanceColorButton.setEnabled(false);
        this.graphBackgroundColorButton.setEnabled(false);
        this.resetColorButton.setEnabled(false);
        this.settingsPanel.setVisible(false);
    }

    private void enableSettingsPanel() {
        this.verticalSlider.setEnabled(true);
        this.coreDistanceColorButton.setEnabled(true);
        this.reachDistanceColorButton.setEnabled(true);
        this.graphBackgroundColorButton.setEnabled(true);
        this.resetColorButton.setEnabled(true);
        this.settingsPanel.setVisible(true);
    }

    private JComponent createTabbedPane() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Table", new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/clusterers/forOPTICSAndDBScan/OPTICS_GUI/Graphics/Table16.gif"))), this.clusteringResultsTable(), "Show table of DataObjects, Core- and Reachability-Distances");
        this.tabbedPane.addTab("Graph - Epsilon: " + this.serObject.getEpsilon() + ", MinPoints: " + this.serObject.getMinPoints(), new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/clusterers/forOPTICSAndDBScan/OPTICS_GUI/Graphics/Graph16.gif"))), this.graphPanel(), "Show Plot of Core- and Reachability-Distances");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = OPTICS_Visualizer.this.tabbedPane.getSelectedIndex();
                if (n == 0) {
                    OPTICS_Visualizer.this.disableSettingsPanel();
                } else {
                    OPTICS_Visualizer.this.enableSettingsPanel();
                }
            }
        });
        return this.tabbedPane;
    }

    private JComponent createToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.setName("OPTICS Visualizer ToolBar");
        this.toolBar.setFloatable(false);
        this.toolBarButton_open = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/clusterers/forOPTICSAndDBScan/OPTICS_GUI/Graphics/Open16.gif"))));
        this.toolBarButton_open.setToolTipText("Open OPTICS-Session");
        this.toolBarButton_open.addActionListener(this.frameListener);
        this.toolBar.add(this.toolBarButton_open);
        this.toolBarButton_save = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/clusterers/forOPTICSAndDBScan/OPTICS_GUI/Graphics/Save16.gif"))));
        this.toolBarButton_save.setToolTipText("Save OPTICS-Session");
        this.toolBarButton_save.addActionListener(this.frameListener);
        this.toolBar.add(this.toolBarButton_save);
        this.toolBar.addSeparator(new Dimension(10, 25));
        this.toolBarButton_parameters = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/clusterers/forOPTICSAndDBScan/OPTICS_GUI/Graphics/Parameters16.gif"))));
        this.toolBarButton_parameters.setToolTipText("Show epsilon, MinPoints...");
        this.toolBarButton_parameters.addActionListener(this.frameListener);
        this.toolBar.add(this.toolBarButton_parameters);
        this.toolBar.addSeparator(new Dimension(10, 25));
        this.toolBarButton_help = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/clusterers/forOPTICSAndDBScan/OPTICS_GUI/Graphics/Help16.gif"))));
        this.toolBarButton_help.setToolTipText("Help topics");
        this.toolBarButton_help.addActionListener(this.frameListener);
        this.toolBar.add(this.toolBarButton_help);
        this.toolBarButton_about = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/clusterers/forOPTICSAndDBScan/OPTICS_GUI/Graphics/Information16.gif"))));
        this.toolBarButton_about.setToolTipText("About");
        this.toolBarButton_about.addActionListener(this.frameListener);
        this.toolBar.add(this.toolBarButton_about);
        return this.toolBar;
    }

    private JComponent clusteringResultsTable() {
        Serializable serializable;
        this.resultVectorTable = new JTable();
        String[] stringArray = new String[]{"Key", "DataObject", "Core-Distance", "Reachability-Distance"};
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        for (int i = 0; i < stringArray.length; ++i) {
            serializable = new TableColumn(i);
            serializable.setHeaderValue(stringArray[i]);
            defaultTableColumnModel.addColumn((TableColumn)serializable);
        }
        ResultVectorTableModel resultVectorTableModel = new ResultVectorTableModel(this.serObject.getResultVector());
        this.resultVectorTable = new JTable(resultVectorTableModel, defaultTableColumnModel);
        this.resultVectorTable.getColumnModel().getColumn(0).setPreferredWidth(70);
        this.resultVectorTable.getColumnModel().getColumn(1).setPreferredWidth(400);
        this.resultVectorTable.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.resultVectorTable.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.resultVectorTable.setAutoResizeMode(0);
        serializable = new JScrollPane(this.resultVectorTable, 22, 32);
        return serializable;
    }

    private JComponent graphPanel() {
        this.graphPanel = new GraphPanel(this.serObject.getResultVector(), this.verValue, true, true);
        this.graphPanel.setPreferredSize(new Dimension(10 * this.serObject.getDatabaseSize() + this.serObject.getDatabaseSize(), this.graphPanel.getHeight()));
        this.graphPanel.setBackground(new Color(255, 255, 179));
        this.graphPanel.setOpaque(true);
        this.graphPanelScrollPane = new JScrollPane(this.graphPanel, 22, 32);
        return this.graphPanelScrollPane;
    }

    private JMenuBar constructDefaultMenuBar() {
        this.defaultMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        this.open = new JMenuItem("Open...", new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/clusterers/forOPTICSAndDBScan/OPTICS_GUI/Graphics/Open16.gif"))));
        this.open.setMnemonic('O');
        this.open.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.open.addActionListener(this.frameListener);
        jMenu.add(this.open);
        this.save = new JMenuItem("Save...", new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/clusterers/forOPTICSAndDBScan/OPTICS_GUI/Graphics/Save16.gif"))));
        this.save.setMnemonic('S');
        this.save.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.save.addActionListener(this.frameListener);
        jMenu.add(this.save);
        jMenu.addSeparator();
        this.exit = new JMenuItem("Exit", 88);
        this.exit.addActionListener(this.frameListener);
        jMenu.add(this.exit);
        this.defaultMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("View");
        jMenu2.setMnemonic('V');
        this.parameters = new JMenuItem("Parameters...", new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/clusterers/forOPTICSAndDBScan/OPTICS_GUI/Graphics/Parameters16.gif"))));
        this.parameters.setMnemonic('P');
        this.parameters.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.parameters.addActionListener(this.frameListener);
        jMenu2.add(this.parameters);
        this.defaultMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu("Help");
        jMenu3.setMnemonic('H');
        this.help = new JMenuItem("Help Topics", new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/clusterers/forOPTICSAndDBScan/OPTICS_GUI/Graphics/Help16.gif"))));
        this.help.setMnemonic('H');
        this.help.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.help.addActionListener(this.frameListener);
        jMenu3.add(this.help);
        this.about = new JMenuItem("About...", new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/clusterers/forOPTICSAndDBScan/OPTICS_GUI/Graphics/Information16.gif"))));
        this.about.setMnemonic('A');
        this.about.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.about.addActionListener(this.frameListener);
        jMenu3.add(this.about);
        this.defaultMenuBar.add(jMenu3);
        return this.defaultMenuBar;
    }

    private void setMenuBar(JMenuBar jMenuBar) {
        this.frame.setJMenuBar(jMenuBar);
    }

    private void loadStatisticsFrame() {
        this.statisticsFrame = new JFrame("Parameters");
        this.statisticsFrame.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(9, 1));
        JPanel jPanel3 = new JPanel(new GridLayout(9, 1));
        jPanel2.add(new JLabel("Number of clustered DataObjects: "));
        jPanel3.add(new JLabel(Integer.toString(this.serObject.getDatabaseSize())));
        jPanel2.add(new JLabel("Number of attributes: "));
        jPanel3.add(new JLabel(Integer.toString(this.serObject.getNumberOfAttributes())));
        jPanel2.add(new JLabel("Epsilon: "));
        jPanel3.add(new JLabel(Double.toString(this.serObject.getEpsilon())));
        jPanel2.add(new JLabel("MinPoints: "));
        jPanel3.add(new JLabel(Integer.toString(this.serObject.getMinPoints())));
        jPanel2.add(new JLabel("Write results to file: "));
        jPanel3.add(new JLabel(this.serObject.isOpticsOutputs() ? "yes" : "no"));
        jPanel2.add(new JLabel("Index: "));
        jPanel3.add(new JLabel(this.serObject.getDatabase_Type()));
        jPanel2.add(new JLabel("Distance-Type: "));
        jPanel3.add(new JLabel(this.serObject.getDatabase_distanceType()));
        jPanel2.add(new JLabel("Number of generated clusters: "));
        jPanel3.add(new JLabel(Integer.toString(this.serObject.getNumberOfGeneratedClusters())));
        jPanel2.add(new JLabel("Elapsed-time: "));
        jPanel3.add(new JLabel(this.serObject.getElapsedTime()));
        jPanel.setBorder(BorderFactory.createTitledBorder(" OPTICS parameters "));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(1, 0, 1, 1, 3.0, 1.0, 10, 1, new Insets(0, 5, 2, 5), 0, 0));
        this.statisticsFrame.getContentPane().add((Component)jPanel, "Center");
        this.statisticsFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                OPTICS_Visualizer.this.statisticsFrame.dispose();
            }
        });
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("OK")) {
                    OPTICS_Visualizer.this.statisticsFrame.dispose();
                }
            }
        });
        jPanel4.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.statisticsFrame.getContentPane().add((Component)jPanel4, "South");
        this.statisticsFrame.setSize(new Dimension(500, 300));
        Rectangle rectangle = this.frame.getBounds();
        Point point = this.frame.getLocation();
        Rectangle rectangle2 = this.statisticsFrame.getBounds();
        this.statisticsFrame.setLocation((rectangle.width - rectangle2.width) / 2 + (int)point.getX(), (rectangle.height - rectangle2.height) / 2 + (int)point.getY());
        this.statisticsFrame.setVisible(true);
        this.statisticsFrame.toFront();
    }

    private void loadHelpFrame() {
        this.helpFrame = new JFrame("Help Topics");
        this.helpFrame.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.append("OPTICS Visualizer Help\n===========================================================\n\nOpen\n - Open OPTICS-Session\n   [Ctrl-O], File | Open\n\nSave\n - Save OPTICS-Session\n   [Ctrl-S], File | Save\n\nExit\n - Exit OPTICS Visualizer\n   [Alt-F4], File | Exit\n\nParameters\n - Show epsilon, MinPoints...\n   [Ctrl-P], View | Parameters\n\nHelp Topics\n - Show this frame\n   [Ctrl-H], Help | Help Topics\n\nAbout\n - Copyright-Information\n   [Ctrl-A], Help | About\n\n\nTable-Pane:\n-----------------------------------------------------------\nThe table represents the calculated clustering-order.\nTo save the table please select File | Save from the\nmenubar. Restart OPTICS with the -F option to obtain\nan ASCII-formatted file of the clustering-order.\n\nGraph-Pane:\n-----------------------------------------------------------\nThe graph draws the plot of core- and reachability-\ndistances. By (de-)activating core- and reachability-\ndistances in the 'General Settings'-Panel you can\ninfluence the visualization in detail. Simply use the\n'Vertical Adjustment'-Slider to emphasize the plot of\ndistances. The 'Colors'-Panel lets you define different\ncolors of the graph background, core- and reachability-\ndistances. Click the 'Reset'-Button to restore the\ndefaults.\n");
        final JScrollPane jScrollPane = new JScrollPane(jTextArea, 22, 32);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 7, 5), 0, 0));
        this.helpFrame.getContentPane().add((Component)jPanel, "Center");
        this.helpFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                OPTICS_Visualizer.this.helpFrame.dispose();
            }

            public void windowOpened(WindowEvent windowEvent) {
                jScrollPane.getVerticalScrollBar().setValue(0);
            }
        });
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Close")) {
                    OPTICS_Visualizer.this.helpFrame.dispose();
                }
            }
        });
        jPanel2.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.helpFrame.getContentPane().add((Component)jPanel2, "South");
        this.helpFrame.setSize(new Dimension(480, 400));
        Rectangle rectangle = this.frame.getBounds();
        Point point = this.frame.getLocation();
        Rectangle rectangle2 = this.helpFrame.getBounds();
        this.helpFrame.setLocation((rectangle.width - rectangle2.width) / 2 + (int)point.getX(), (rectangle.height - rectangle2.height) / 2 + (int)point.getY());
        this.helpFrame.setVisible(true);
        this.helpFrame.toFront();
    }

    private class SettingsPanelListener
    implements ActionListener {
        private SettingsPanelListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color;
            if (actionEvent.getSource() == OPTICS_Visualizer.this.coreDistanceColorButton && (color = this.getSelectedColor("Select 'Core-Distance' color")) != null) {
                OPTICS_Visualizer.this.coreDistanceColorButton.setBackground(color);
                OPTICS_Visualizer.this.graphPanel.setCoreDistanceColor(color);
            }
            if (actionEvent.getSource() == OPTICS_Visualizer.this.reachDistanceColorButton && (color = this.getSelectedColor("Select 'Reachability-Distance' color")) != null) {
                OPTICS_Visualizer.this.reachDistanceColorButton.setBackground(color);
                OPTICS_Visualizer.this.graphPanel.setReachabilityDistanceColor(color);
            }
            if (actionEvent.getSource() == OPTICS_Visualizer.this.graphBackgroundColorButton && (color = this.getSelectedColor("Select 'Graph Background' color")) != null) {
                OPTICS_Visualizer.this.graphBackgroundColorButton.setBackground(color);
                OPTICS_Visualizer.this.graphPanel.setBackground(color);
            }
            if (actionEvent.getSource() == OPTICS_Visualizer.this.resetColorButton) {
                OPTICS_Visualizer.this.coreDistanceColorButton.setBackground(new Color(100, 100, 100));
                OPTICS_Visualizer.this.graphPanel.setCoreDistanceColor(new Color(100, 100, 100));
                OPTICS_Visualizer.this.reachDistanceColorButton.setBackground(Color.orange);
                OPTICS_Visualizer.this.graphPanel.setReachabilityDistanceColor(Color.orange);
                OPTICS_Visualizer.this.graphBackgroundColorButton.setBackground(new Color(255, 255, 179));
                OPTICS_Visualizer.this.graphPanel.setBackground(new Color(255, 255, 179));
                OPTICS_Visualizer.this.graphPanel.repaint();
            }
        }

        private Color getSelectedColor(String string) {
            Color color = JColorChooser.showDialog(OPTICS_Visualizer.this.frame, string, Color.black);
            return color;
        }
    }

    private class FrameListener
    implements ActionListener {
        private FrameListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            if (actionEvent.getSource() == OPTICS_Visualizer.this.parameters || actionEvent.getSource() == OPTICS_Visualizer.this.toolBarButton_parameters) {
                OPTICS_Visualizer.this.loadStatisticsFrame();
            }
            if (actionEvent.getSource() == OPTICS_Visualizer.this.about || actionEvent.getSource() == OPTICS_Visualizer.this.toolBarButton_about) {
                JOptionPane.showMessageDialog(OPTICS_Visualizer.this.frame, "OPTICS Visualizer\n$ Rev 1.4 $\n\nCopyright (C) 2004 Rainer Holzmann, Zhanna Melnikova-Albrecht", "About", 1);
            }
            if (actionEvent.getSource() == OPTICS_Visualizer.this.help || actionEvent.getSource() == OPTICS_Visualizer.this.toolBarButton_help) {
                OPTICS_Visualizer.this.loadHelpFrame();
            }
            if (actionEvent.getSource() == OPTICS_Visualizer.this.exit) {
                OPTICS_Visualizer.this.frame.dispose();
            }
            if (actionEvent.getSource() == OPTICS_Visualizer.this.open || actionEvent.getSource() == OPTICS_Visualizer.this.toolBarButton_open) {
                OPTICS_Visualizer.this.jFileChooser.setDialogTitle("Open OPTICS-Session");
                if (OPTICS_Visualizer.this.lastPath == null) {
                    OPTICS_Visualizer.this.lastPath = System.getProperty("user.dir");
                }
                OPTICS_Visualizer.this.jFileChooser.setCurrentDirectory(new File(OPTICS_Visualizer.this.lastPath));
                int n = OPTICS_Visualizer.this.jFileChooser.showOpenDialog(OPTICS_Visualizer.this.frame);
                object2 = null;
                if (n == 0) {
                    object = OPTICS_Visualizer.this.jFileChooser.getSelectedFile();
                    try {
                        FileInputStream fileInputStream = new FileInputStream(((File)object).getAbsolutePath());
                        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                        object2 = (SERObject)objectInputStream.readObject();
                        objectInputStream.close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        JOptionPane.showMessageDialog(OPTICS_Visualizer.this.frame, "File not found.", "Error", 0);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        JOptionPane.showMessageDialog(OPTICS_Visualizer.this.frame, "OPTICS-Session could not be read.", "Error", 0);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(OPTICS_Visualizer.this.frame, "This file does not contain a valid OPTICS-Session.", "Error", 0);
                    }
                    if (object2 != null) {
                        int n2 = JOptionPane.showConfirmDialog(OPTICS_Visualizer.this.frame, "Open OPTICS-Session in a new window?", "Open", 1);
                        switch (n2) {
                            case 0: {
                                new OPTICS_Visualizer((SERObject)object2, "OPTICS Visualizer - " + ((File)object).getName());
                                break;
                            }
                            case 1: {
                                OPTICS_Visualizer.this.serObject = (SERObject)object2;
                                OPTICS_Visualizer.this.resultVectorTable.setModel(new ResultVectorTableModel(OPTICS_Visualizer.this.serObject.getResultVector()));
                                OPTICS_Visualizer.this.tabbedPane.setTitleAt(1, "Graph - Epsilon: " + OPTICS_Visualizer.this.serObject.getEpsilon() + ", MinPoints: " + OPTICS_Visualizer.this.serObject.getMinPoints());
                                OPTICS_Visualizer.this.graphPanel.setResultVector(OPTICS_Visualizer.this.serObject.getResultVector());
                                OPTICS_Visualizer.this.graphPanel.adjustSize(OPTICS_Visualizer.this.serObject);
                                OPTICS_Visualizer.this.graphPanel.repaint();
                                break;
                            }
                        }
                    }
                }
            }
            if (actionEvent.getSource() == OPTICS_Visualizer.this.save || actionEvent.getSource() == OPTICS_Visualizer.this.toolBarButton_save) {
                OPTICS_Visualizer.this.jFileChooser.setDialogTitle("Save OPTICS-Session");
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                object2 = gregorianCalendar.get(5) + "-" + (gregorianCalendar.get(2) + 1) + "-" + gregorianCalendar.get(1) + "--" + gregorianCalendar.get(11) + "-" + gregorianCalendar.get(12) + "-" + gregorianCalendar.get(13);
                object = "OPTICS_" + (String)object2 + ".ser";
                File file = new File((String)object);
                OPTICS_Visualizer.this.jFileChooser.setSelectedFile(file);
                if (OPTICS_Visualizer.this.lastPath == null) {
                    OPTICS_Visualizer.this.lastPath = System.getProperty("user.dir");
                }
                OPTICS_Visualizer.this.jFileChooser.setCurrentDirectory(new File(OPTICS_Visualizer.this.lastPath));
                int n = OPTICS_Visualizer.this.jFileChooser.showSaveDialog(OPTICS_Visualizer.this.frame);
                if (n == 0) {
                    file = OPTICS_Visualizer.this.jFileChooser.getSelectedFile();
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath());
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                        objectOutputStream.writeObject(OPTICS_Visualizer.this.serObject);
                        objectOutputStream.flush();
                        objectOutputStream.close();
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(OPTICS_Visualizer.this.frame, "OPTICS-Session could not be saved.", "Error", 0);
                    }
                }
            }
        }
    }
}

